/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.datasets.streamwrite.StreamWriterFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.streaming.python.ContinuousPythonRecipeParams;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpoint;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpointComparator;
import com.dataiku.dip.recipes.streaming.python.FunctionStreamingFeedParams;
import com.dataiku.dip.recipes.streaming.python.OffsetStoringAble;
import com.dataiku.dip.recipes.streaming.python.RowsSplittingHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.streaming.endpoints.Replayable;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaSimplePuller;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.SingleValueKafkaFormat;
import com.dataiku.dip.streaming.endpoints.kafka.ToKafkaStreamer;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class RowsPushingHandler {
    private static final DateTimeParser[] pythonDateParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS Z").getParser()};
    public static final DateTimeFormatter pythonDateParser = new DateTimeFormatterBuilder().append(null, pythonDateParsers).toFormatter().withZone(DateTimeZone.UTC);
    public static final DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private final Map<String, RowsPushingThread> pushThreads = Maps.newHashMap();
    private final Runnable notifyError;
    private volatile boolean closed = false;
    private final Object initLock = new Object();
    private volatile boolean initializing;
    private volatile boolean initDone;
    private volatile int pushThreadsStartedCount = 0;
    private static Logger logger = Logger.getLogger((String)"dip.streaming.function.rows.push");

    public RowsPushingHandler(AuthCtx authCtx, String projectKey, SerializedRecipe sr, ComputableFromRefService computableFromRefService, DatasetsDAO datasetsDAO, Runnable notifyError) throws IOException {
        this.notifyError = notifyError;
        FunctionStreamingFeedParams feedParams = sr.getParamsAs(ContinuousPythonRecipeParams.class).feedParams;
        for (SerializedRecipe.RecipeOutput output : sr.getFlatOutputs()) {
            FunctionStreamingFeedParams.CheckpointingParams checkpointingParams = feedParams.getOutputForRef(output.ref).getTypedParams();
            FlowComputable computable = computableFromRefService.get(projectKey, output.ref);
            RowsPushingThread pushThread = null;
            if (computable instanceof FlowStreamingEndpoint) {
                StreamingEndpoint streamingEndpoint = ((FlowStreamingEndpoint)computable).getStreamingEndpoint();
                pushThread = new StreamingEndpointRowsPushingThread(authCtx, this, streamingEndpoint, checkpointingParams, sr.getFullId());
            } else if (computable instanceof FlowDataset) {
                Dataset dataset = ((FlowDataset)computable).getMandatory(datasetsDAO);
                pushThread = new DatasetRowsPushingThread(authCtx, this, dataset, sr.getFullId(), checkpointingParams);
            }
            if (pushThread == null) continue;
            this.pushThreads.put(pushThread.getFullId(), pushThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startInitIfNeeded() throws InterruptedException {
        logger.info((Object)("Start init if needed thread=" + Thread.currentThread().getId()));
        Object object = this.initLock;
        synchronized (object) {
            while (!this.initDone && this.initializing) {
                this.initLock.wait();
            }
            logger.info((Object)("  > init if needed thread=" + Thread.currentThread().getId() + " initDone=" + this.initDone));
            if (this.initDone) {
                return false;
            }
            this.initializing = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInit(boolean done) {
        logger.info((Object)("Notify init done=" + done + " thread=" + Thread.currentThread().getId()));
        Object object = this.initLock;
        synchronized (object) {
            this.initDone = done;
            this.initializing = false;
            this.initLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitDone() throws InterruptedException {
        logger.info((Object)("Wait for init thread=" + Thread.currentThread().getId()));
        Object object = this.initLock;
        synchronized (object) {
            while (!this.initDone) {
                this.initLock.wait();
            }
        }
        logger.info((Object)("  > init done thread=" + Thread.currentThread().getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPushThreadStarted() {
        logger.info((Object)("Notify push thread start thread=" + Thread.currentThread().getId()));
        Object object = this.initLock;
        synchronized (object) {
            ++this.pushThreadsStartedCount;
            this.initLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllPushThreadsStarted() throws InterruptedException {
        logger.info((Object)("Wait for push threads thread=" + Thread.currentThread().getId()));
        Object object = this.initLock;
        synchronized (object) {
            while (this.pushThreadsStartedCount < this.pushThreads.size()) {
                this.initLock.wait();
            }
        }
        logger.info((Object)("   > waited for push threads thread=" + Thread.currentThread().getId()));
    }

    public List<FunctionCheckpoint> readLastCheckpointStored() throws Exception {
        ArrayList checkpoints = Lists.newArrayList();
        for (Map.Entry<String, RowsPushingThread> pushThreadEntry : this.pushThreads.entrySet()) {
            RowsPushingThread pushThread = pushThreadEntry.getValue();
            FunctionCheckpoint lastCommitted = pushThread.getLastCheckpointStored();
            if (lastCommitted == null) continue;
            checkpoints.add(lastCommitted);
        }
        logger.info((Object)("Retrieved last offsets are " + JSON.pretty((Object)checkpoints)));
        FunctionCheckpoint checkpointLowerBound = null;
        for (Object checkpoint : checkpoints) {
            FunctionCheckpoint minCheckpoint = ((FunctionCheckpoint)checkpoint).min;
            if (minCheckpoint == null || checkpointLowerBound != null && minCheckpoint.compareTo(checkpointLowerBound) <= 0) continue;
            checkpointLowerBound = minCheckpoint;
        }
        ArrayList filteredCheckpoints = Lists.newArrayList();
        if (checkpointLowerBound != null) {
            for (FunctionCheckpoint checkpoint : checkpoints) {
                if (checkpointLowerBound.compareTo(checkpoint) > 0) continue;
                filteredCheckpoints.add(checkpoint);
            }
        } else {
            filteredCheckpoints.addAll(checkpoints);
        }
        if (filteredCheckpoints.size() <= 1) {
            return filteredCheckpoints;
        }
        Collections.sort(filteredCheckpoints, new Comparator<FunctionCheckpoint>(){

            @Override
            public int compare(FunctionCheckpoint a, FunctionCheckpoint b) {
                return a.compareTo(b);
            }
        });
        long lastRun = -1L;
        long lastIdx = -1L;
        ArrayList uniqueCheckpoints = Lists.newArrayList();
        for (FunctionCheckpoint checkpoint : filteredCheckpoints) {
            if (checkpoint.run == lastRun && checkpoint.idx == lastIdx) continue;
            uniqueCheckpoints.add(checkpoint);
            lastRun = checkpoint.run;
            lastIdx = checkpoint.idx;
        }
        return uniqueCheckpoints;
    }

    public FunctionCheckpoint getCommittedUpTo() throws Exception {
        FunctionCheckpoint minCheckpoint = null;
        for (Map.Entry<String, RowsPushingThread> pushThreadEntry : this.pushThreads.entrySet()) {
            RowsPushingThread pushThread = pushThreadEntry.getValue();
            FunctionCheckpoint checkpoint = pushThread.getCommittedUpTo();
            if (minCheckpoint != null && (checkpoint == null || checkpoint.idx >= minCheckpoint.idx)) continue;
            minCheckpoint = checkpoint;
        }
        return minCheckpoint == null ? null : new FunctionCheckpoint(minCheckpoint);
    }

    public Map<String, Schema> getSchemas() throws IOException {
        HashMap schemas = Maps.newHashMap();
        for (RowsPushingThread pushThread : this.pushThreads.values()) {
            schemas.put(pushThread.fullId, pushThread.schema);
        }
        return schemas;
    }

    public void giveRowsToProcess(RowsSplittingHandler.OutputRowsBatch batch) throws Exception {
        FunctionCheckpoint currentCheckpoint = new FunctionCheckpoint(batch.checkpoint);
        currentCheckpoint.min = this.getCommittedUpTo();
        logger.info((Object)("Write up to current=" + JSON.json((Object)currentCheckpoint)));
        HashSet untouched = Sets.newHashSet(this.pushThreads.keySet());
        for (Map.Entry<String, List<List<Object>>> rowsBlockEntry : batch.rows.entrySet()) {
            String fullId = rowsBlockEntry.getKey();
            OutputRowsBlock rowsBlock = new OutputRowsBlock(fullId, currentCheckpoint);
            rowsBlock.rows.addAll((Collection<List<Object>>)rowsBlockEntry.getValue());
            RowsPushingThread pushThread = this.pushThreads.get(fullId);
            if (pushThread == null) {
                throw new Exception("Attempted to write data to unknown output " + fullId);
            }
            pushThread.queue.put(rowsBlock);
            untouched.remove(fullId);
        }
        for (String fullId : untouched) {
            OutputRowsBlock rowsBlock = new OutputRowsBlock(fullId, currentCheckpoint);
            RowsPushingThread pushThread = this.pushThreads.get(fullId);
            pushThread.queue.put(rowsBlock);
        }
    }

    public void startPush() throws Exception {
        for (RowsPushingThread pushThread : this.pushThreads.values()) {
            pushThread.startPush();
        }
    }

    public void stopPush() {
        logger.info((Object)("Stop push closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (RowsPushingThread pushThread : this.pushThreads.values()) {
            pushThread.stopPush();
        }
    }

    public void errorPush() {
        logger.info((Object)("Error push closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.notifyError != null) {
            this.notifyError.run();
        }
        for (RowsPushingThread pushThread : this.pushThreads.values()) {
            pushThread.errorPush();
        }
    }

    public void setFunctionCheckpointComparator(FunctionCheckpointComparator functionCheckpointComparator) {
        for (RowsPushingThread t : this.pushThreads.values()) {
            t.setFunctionCheckpointComparator(functionCheckpointComparator);
        }
    }

    private static class StreamingEndpointRowsPushingThread
    extends RowsPushingThread {
        @Autowired
        private StreamingEndpointsDAO streamingEndpointsDAO;
        private final AuthCtx authCtx;
        private final FunctionStreamingFeedParams.CheckpointingParams checkpointingParams;
        private final String sourceId;
        private StreamingEndpointSimpleWriter writer;

        public StreamingEndpointRowsPushingThread(AuthCtx authCtx, RowsPushingHandler handler, StreamingEndpoint streamingEndpoint, FunctionStreamingFeedParams.CheckpointingParams checkpointingParams, String sourceId) {
            super(streamingEndpoint.getFullId(), handler);
            this.authCtx = authCtx;
            this.checkpointingParams = checkpointingParams;
            this.sourceId = sourceId;
        }

        @Override
        protected FunctionCheckpoint fetchLastCheckpointStored() throws Exception {
            OneInit oneInit = this.buildWriterAndOffsetHandler();
            try {
                FunctionCheckpoint functionCheckpoint = oneInit.offsetStoringAble.readLastCheckpointStored();
                return functionCheckpoint;
            }
            finally {
                oneInit.writer.cancel();
            }
        }

        @Override
        public void initRun() throws Exception {
            OneInit oneInit = this.buildWriterAndOffsetHandler();
            this.schema = oneInit.streamingEndpoint.schema;
            this.writer = oneInit.writer;
            this.offsetStoringAble = oneInit.offsetStoringAble;
            this.writer.init();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private OneInit buildWriterAndOffsetHandler() throws Exception {
            OneInit ret = new OneInit();
            if (TransactionContext.hasAttachedTransaction()) {
                ret.streamingEndpoint = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(AnyLoc.resolveFull(this.getFullId()));
            } else {
                try (Transaction t = this.transactionService.beginRead();){
                    ret.streamingEndpoint = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(AnyLoc.resolveFull(this.getFullId()));
                }
            }
            ret.writer = StreamingEndpointsRegistry.getMeta(ret.streamingEndpoint).getSimpleWriter(this.authCtx, ret.streamingEndpoint, this.cf, new WarningsContext());
            if (this.checkpointingParams instanceof FunctionStreamingFeedParams.KafkaTransactionCheckpointingParams) {
                FunctionStreamingFeedParams.KafkaTransactionCheckpointingParams kafkaTransactionCheckpointingParams = (FunctionStreamingFeedParams.KafkaTransactionCheckpointingParams)this.checkpointingParams;
                if (!(ret.writer instanceof ToKafkaStreamer)) throw new IllegalArgumentException("Cannot use Kafka transactions on " + ret.writer.getClass().getCanonicalName());
                logger.info((Object)("Checkpointing with kafka every " + kafkaTransactionCheckpointingParams.checkpointInterval + " ms"));
                ret.offsetStoringAble = new KafkaTransationCheckpointStorer(this.authCtx, ret.streamingEndpoint, this.sourceId, (ToKafkaStreamer)ret.writer, kafkaTransactionCheckpointingParams.checkpointTopic, kafkaTransactionCheckpointingParams.checkpointInterval);
                return ret;
            } else if (this.checkpointingParams instanceof FunctionStreamingFeedParams.FileCheckpointingParams) {
                FunctionStreamingFeedParams.FileCheckpointingParams fileCheckpointingParams = (FunctionStreamingFeedParams.FileCheckpointingParams)this.checkpointingParams;
                logger.info((Object)("Checkpointing with file every " + fileCheckpointingParams.checkpointInterval + " ms or " + fileCheckpointingParams.checkpointMaxRows + " rows"));
                ret.offsetStoringAble = new FileCheckpointStorer(fileCheckpointingParams.path, fileCheckpointingParams.checkpointInterval, fileCheckpointingParams.checkpointMaxRows);
                return ret;
            } else {
                logger.info((Object)("No checkpointing settings defined (" + JSON.json((Object)this.checkpointingParams) + "), using default values"));
                ret.offsetStoringAble = new OffsetDummyNonStoring();
            }
            return ret;
        }

        @Override
        public void pushRow(Row row) throws Exception {
            this.writer.processRow(row);
        }

        @Override
        public void stopPush() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.writer != null) {
                    this.writer.postProcess();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close push to dataset", (Throwable)e);
            }
        }

        @Override
        public void errorPush() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.writer != null) {
                    this.writer.cancel();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close push to dataset", (Throwable)e);
            }
            this.handler.errorPush();
        }

        private static class OneInit {
            StreamingEndpoint streamingEndpoint;
            StreamingEndpointSimpleWriter writer;
            OffsetStoringAble offsetStoringAble;

            private OneInit() {
            }
        }
    }

    private static class DatasetRowsPushingThread
    extends RowsPushingThread {
        @Autowired
        private DatasetsDAO datasetsDAO;
        private final AuthCtx authCtx;
        private final String sourceId;
        private final FunctionStreamingFeedParams.CheckpointingParams checkpointingParams;
        private StreamWriter writer;

        public DatasetRowsPushingThread(AuthCtx authCtx, RowsPushingHandler handler, Dataset dataset, String sourceId, FunctionStreamingFeedParams.CheckpointingParams checkpointingParams) {
            super(dataset.getFullName(), handler);
            this.authCtx = authCtx;
            this.sourceId = sourceId;
            this.checkpointingParams = checkpointingParams;
        }

        @Override
        protected FunctionCheckpoint fetchLastCheckpointStored() throws Exception {
            OneInit oneInit = this.buildWriterAndOffsetHandler();
            try {
                FunctionCheckpoint functionCheckpoint = oneInit.offsetStoringAble.readLastCheckpointStored();
                return functionCheckpoint;
            }
            finally {
                oneInit.writer.close();
            }
        }

        @Override
        public void initRun() throws Exception {
            OneInit oneInit = this.buildWriterAndOffsetHandler();
            this.schema = oneInit.dataset.getSchema();
            this.writer = oneInit.writer;
            this.offsetStoringAble = oneInit.offsetStoringAble;
        }

        private OneInit buildWriterAndOffsetHandler() throws Exception {
            SerializedDataset sd;
            OneInit ret = new OneInit();
            if (TransactionContext.hasAttachedTransaction()) {
                sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(AnyLoc.resolveFull(this.getFullId()));
            } else {
                try (Transaction t = this.transactionService.beginRead();){
                    sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(AnyLoc.resolveFull(this.getFullId()));
                }
            }
            ret.dataset = Dataset.fromSerialized(this.getFullId(), sd);
            DatasetHandler datasetHandler = DatasetHandlerFactory.build(this.authCtx, ret.dataset);
            ret.writer = StreamWriterFactory.build(this.authCtx, datasetHandler, this.sourceId, 0);
            ret.writer.setColumnFactory(this.cf);
            if (this.checkpointingParams instanceof FunctionStreamingFeedParams.DatasetCheckpointingParams) {
                FunctionStreamingFeedParams.DatasetCheckpointingParams datasetCheckpointingParams = (FunctionStreamingFeedParams.DatasetCheckpointingParams)this.checkpointingParams;
                logger.info((Object)("Checkpointing in dataset every " + datasetCheckpointingParams.checkpointInterval + " ms or " + datasetCheckpointingParams.checkpointMaxRows + " rows"));
                ret.offsetStoringAble = new StreamWriterCheckpointStorer(ret.writer, datasetCheckpointingParams.checkpointInterval, datasetCheckpointingParams.checkpointMaxRows);
            } else if (this.checkpointingParams instanceof FunctionStreamingFeedParams.FileCheckpointingParams) {
                FunctionStreamingFeedParams.FileCheckpointingParams fileCheckpointingParams = (FunctionStreamingFeedParams.FileCheckpointingParams)this.checkpointingParams;
                logger.info((Object)("Checkpointing with file every " + fileCheckpointingParams.checkpointInterval + " ms or " + fileCheckpointingParams.checkpointMaxRows + " rows"));
                ret.offsetStoringAble = new FileCheckpointStorer(fileCheckpointingParams.path, fileCheckpointingParams.checkpointInterval, fileCheckpointingParams.checkpointMaxRows);
            } else {
                logger.info((Object)("No checkpointing settings defined (" + JSON.json((Object)this.checkpointingParams) + "), using default values"));
                ret.offsetStoringAble = new OffsetDummyNonStoring();
            }
            return ret;
        }

        @Override
        public void pushRow(Row row) throws Exception {
            this.writer.append(row);
        }

        @Override
        public void stopPush() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close push to dataset", (Throwable)e);
            }
        }

        @Override
        public void errorPush() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.writer != null) {
                    this.writer.cancel();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close push to dataset", (Throwable)e);
            }
            this.handler.errorPush();
        }

        private static class OneInit {
            Dataset dataset;
            StreamWriter writer;
            OffsetStoringAble offsetStoringAble;

            private OneInit() {
            }
        }
    }

    private static abstract class RowsPushingThread
    extends Thread {
        @Autowired
        protected TransactionService transactionService;
        protected final RowsPushingHandler handler;
        private final String fullId;
        private final LinkedBlockingQueue<OutputRowsBlock> queue = new LinkedBlockingQueue(10);
        protected OffsetStoringAble offsetStoringAble;
        protected Schema schema;
        protected final ColumnFactory cf;
        private final RowFactory rf;
        private FunctionCheckpointComparator functionCheckpointComparator;
        private boolean hasUncommittedRows = false;
        private FunctionCheckpoint committedUpTo;
        protected volatile boolean closed = false;
        private boolean hasReadLastCheckpointStored;
        private FunctionCheckpoint lastCheckpointStored;

        public RowsPushingThread(String fullId, RowsPushingHandler handler) {
            super("rows-push-thread-" + fullId);
            this.fullId = fullId;
            this.handler = handler;
            this.cf = new StreamColumnFactory();
            this.rf = new StreamRowFactory();
            SpringUtils.getInstance().autowire((Object)this);
        }

        public FunctionCheckpoint getLastCheckpointStored() throws Exception {
            if (!this.hasReadLastCheckpointStored) {
                this.lastCheckpointStored = this.fetchLastCheckpointStored();
                this.hasReadLastCheckpointStored = true;
            }
            return this.lastCheckpointStored;
        }

        protected abstract FunctionCheckpoint fetchLastCheckpointStored() throws Exception;

        public void setFunctionCheckpointComparator(FunctionCheckpointComparator functionCheckpointComparator) {
            this.functionCheckpointComparator = functionCheckpointComparator;
        }

        public String getFullId() {
            return this.fullId;
        }

        public synchronized FunctionCheckpoint getCommittedUpTo() {
            return this.committedUpTo;
        }

        public synchronized void setCommittedUpTo(FunctionCheckpoint committedUpTo) {
            this.committedUpTo = committedUpTo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.handler.waitForInitDone();
                this.initRun();
                FunctionCheckpoint lastCheckpointStored = this.getLastCheckpointStored();
                this.setCommittedUpTo(lastCheckpointStored);
                this.handler.notifyPushThreadStarted();
                logger.info((Object)(this.fullId + " - Suppress until " + JSON.json((Object)lastCheckpointStored)));
                while (!this.closed) {
                    OutputRowsBlock rowsBlock = this.queue.take();
                    if (lastCheckpointStored != null) {
                        if (this.functionCheckpointComparator != null && this.functionCheckpointComparator.lastStoredIsPastCurrent(lastCheckpointStored, rowsBlock.checkpoint)) {
                            logger.info((Object)(this.fullId + " - Already committed past " + JSON.json((Object)rowsBlock.checkpoint) + ", skipping"));
                            continue;
                        }
                        logger.info((Object)(this.fullId + " - Passed the last commit point"));
                        lastCheckpointStored = null;
                    }
                    if (rowsBlock.rows.isEmpty()) {
                        if (!this.hasUncommittedRows) {
                            this.setCommittedUpTo(rowsBlock.checkpoint);
                        }
                    } else {
                        this.hasUncommittedRows = true;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Push " + rowsBlock.rows.size() + " rows to " + this.getFullId()));
                        }
                        for (List<Object> row : rowsBlock.rows) {
                            this.pushRow(this.cellsToRow(row, this.schema));
                        }
                    }
                    if (!this.offsetStoringAble.newCheckpoint(rowsBlock.rows.size(), rowsBlock.checkpoint)) continue;
                    logger.info((Object)(this.fullId + " - + committed up to " + JSON.json((Object)rowsBlock.checkpoint)));
                    this.hasUncommittedRows = false;
                    this.setCommittedUpTo(rowsBlock.checkpoint);
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"Stopped rows push", (Throwable)e);
                this.errorPush();
            }
            catch (Exception e) {
                logger.error((Object)"Error rows push", (Throwable)e);
                this.errorPush();
            }
            finally {
                this.stopPush();
            }
        }

        protected abstract void initRun() throws Exception;

        public abstract void pushRow(Row var1) throws Exception;

        private Row cellsToRow(List<Object> cells, Schema schema) throws IOException {
            Row row = this.rf.row();
            for (int i = 0; i < cells.size(); ++i) {
                SchemaColumn sc = (SchemaColumn)schema.columns.get(i);
                Object v = cells.get(i);
                Column c2 = this.cf.column(sc.getName());
                if (v == null) {
                    row.empty(c2);
                    continue;
                }
                if (v instanceof Boolean) {
                    row.put(c2, ((Boolean)v).booleanValue());
                    continue;
                }
                if (v instanceof Long || v instanceof Integer || v instanceof Short || v instanceof Byte) {
                    row.put(c2, ((Number)v).longValue());
                    continue;
                }
                if (v instanceof Double || v instanceof Float || v instanceof BigDecimal) {
                    if (sc.getType().isFloatingPoint()) {
                        row.put(c2, ((Number)v).doubleValue());
                        continue;
                    }
                    row.put(c2, ((Number)v).longValue());
                    continue;
                }
                if (sc.getType() == Type.DATE) {
                    if ("NaT".equals(v)) {
                        row.empty(c2);
                        continue;
                    }
                    try {
                        row.put(c2, isoFormatter.print((ReadableInstant)pythonDateParser.parseDateTime(v.toString())));
                    }
                    catch (IllegalArgumentException e) {
                        row.empty(c2);
                    }
                    continue;
                }
                if (sc.getType() == Type.DATEONLY) {
                    if ("NaT".equals(v)) {
                        row.empty(c2);
                        continue;
                    }
                    try {
                        row.put(c2, v.toString().substring(0, 10));
                    }
                    catch (IllegalArgumentException e) {
                        row.empty(c2);
                    }
                    continue;
                }
                if (sc.getType() == Type.DATETIMENOTZ) {
                    if ("NaT".equals(v)) {
                        row.empty(c2);
                        continue;
                    }
                    try {
                        row.put(c2, DatetimeNoTz.CANONICAL_FORMATTER.print((ReadableInstant)pythonDateParser.parseDateTime(v.toString())));
                    }
                    catch (IllegalArgumentException e) {
                        row.empty(c2);
                    }
                    continue;
                }
                row.put(c2, v.toString());
            }
            return row;
        }

        public void startPush() throws Exception {
            this.start();
        }

        public abstract void stopPush();

        public abstract void errorPush();
    }

    public static class OutputRowsBlock {
        public final String fullId;
        public final List<List<Object>> rows = Lists.newArrayList();
        public final FunctionCheckpoint checkpoint;

        public OutputRowsBlock(String fullId, FunctionCheckpoint checkpoint) {
            this.fullId = fullId;
            this.checkpoint = checkpoint;
        }

        public OutputRowsBlock with(List<Object> row) {
            this.rows.add(row);
            return this;
        }
    }

    private static class KafkaTransationCheckpointStorer
    implements OffsetStoringAble {
        private final AuthCtx authCtx;
        private final StreamingEndpoint checkpointStreamingEndpoint;
        private final long checkpointInterval;
        private final ToKafkaStreamer writer;
        private final String checkpointKey;
        private long lastEmitted = System.currentTimeMillis();
        private Schema schema = new Schema().withColumn("k", Type.STRING).withColumn("v", Type.STRING);

        public KafkaTransationCheckpointStorer(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, String recipeFullId, ToKafkaStreamer writer, String checkpointTopic, long checkpointInterval) {
            this.authCtx = authCtx;
            this.checkpointStreamingEndpoint = this.makeCheckpointStreamingEndpoint(streamingEndpoint, checkpointTopic);
            this.writer = writer;
            this.checkpointInterval = checkpointInterval;
            this.checkpointKey = recipeFullId + " " + streamingEndpoint.getFullId();
            String expandedTopic = StreamingEndpointsRegistry.getMeta((StreamingEndpoint)this.checkpointStreamingEndpoint).getExpandedParams((String)this.checkpointStreamingEndpoint.projectKey, (StreamingEndpoint)this.checkpointStreamingEndpoint, KafkaStreamingEndpointParams.class).topic;
            writer.withTransactional(this.checkpointKey, expandedTopic);
        }

        private StreamingEndpoint makeCheckpointStreamingEndpoint(StreamingEndpoint streamingEndpoint, String checkpointTopic) {
            StreamingEndpoint se = (StreamingEndpoint)JSON.deepCopy((Object)streamingEndpoint);
            KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
            params.topic = checkpointTopic;
            SingleValueKafkaFormat.SingleValueKafkaFormatParams fp = new SingleValueKafkaFormat.SingleValueKafkaFormatParams();
            fp.columnType = SingleValueKafkaFormat.KeyType.STRING;
            fp.columnName = "v";
            SingleValueKafkaFormat.SingleValueKafkaFormatParams kfp = new SingleValueKafkaFormat.SingleValueKafkaFormatParams();
            kfp.columnType = SingleValueKafkaFormat.KeyType.STRING;
            kfp.columnName = "k";
            params.formatType = "single";
            params.formatParams = JSON.toJsonObject((Object)fp);
            params.keyFormatType = "single";
            params.keyFormatParams = JSON.toJsonObject((Object)kfp);
            params.consumerParams.properties.add(new SimpleKeyValue("isolation.level", "read_uncommitted"));
            return se;
        }

        @Override
        public FunctionCheckpoint readLastCheckpointStored() throws Exception {
            try (KafkaSimplePuller puller = (KafkaSimplePuller)StreamingEndpointsRegistry.getMeta(this.checkpointStreamingEndpoint).getSimplePuller(this.authCtx, this.checkpointStreamingEndpoint, false);){
                StreamColumnFactory cf = new StreamColumnFactory();
                puller.init((ColumnFactory)cf, (RowFactory)new StreamRowFactory(), this.schema, Replayable.BOS);
                String last = null;
                long cnt = 0L;
                while (!puller.hasPassedCommittedOffsets()) {
                    StreamingEndpointSimplePuller.RowsPulled pulled = puller.next();
                    for (Row row : pulled.rows) {
                        if (this.checkpointKey.equals(row.get((Column)cf.column("k")))) {
                            last = row.get((Column)cf.column("v"));
                        }
                        ++cnt;
                    }
                }
                logger.info((Object)("Read " + cnt + " messages to retrieve last checkpoint : " + last));
                FunctionCheckpoint functionCheckpoint = last == null ? null : (FunctionCheckpoint)JSON.parse(last, FunctionCheckpoint.class);
                return functionCheckpoint;
            }
        }

        @Override
        public boolean newCheckpoint(int nRows, FunctionCheckpoint checkpoint) throws Exception {
            if (System.currentTimeMillis() - this.lastEmitted > this.checkpointInterval) {
                this.writer.addToCurrentTransaction(this.checkpointKey, JSON.json((Object)checkpoint));
                this.writer.commitAndRenewTransaction();
                this.lastEmitted = System.currentTimeMillis();
                return true;
            }
            return false;
        }
    }

    private static class FileCheckpointStorer
    implements OffsetStoringAble {
        private final long checkpointInterval;
        private final long checkpointMaxRows;
        private final File checkpointFile;
        private long lastEmitted = System.currentTimeMillis();
        private long emitted = 0L;

        public FileCheckpointStorer(String path, long checkpointInterval, long checkpointMaxRows) {
            if (StringUtils.isBlank((String)path)) {
                throw new IllegalArgumentException("Path to store checkpoint is not defined");
            }
            this.checkpointInterval = checkpointInterval;
            this.checkpointMaxRows = checkpointMaxRows;
            File file = new File(path);
            this.checkpointFile = file.exists() && file.isDirectory() ? new File(file, "checkpoint.json") : file;
        }

        @Override
        public FunctionCheckpoint readLastCheckpointStored() throws Exception {
            if (this.checkpointFile.exists()) {
                try {
                    return (FunctionCheckpoint)JSON.parseFile((File)this.checkpointFile, FunctionCheckpoint.class);
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to read checkpoint, assuming none", (Throwable)e);
                }
            }
            return null;
        }

        @Override
        public boolean newCheckpoint(int nRows, FunctionCheckpoint checkpoint) throws Exception {
            this.emitted += (long)nRows;
            if (this.emitted > this.checkpointMaxRows || System.currentTimeMillis() - this.lastEmitted > this.checkpointInterval && this.emitted > 0L) {
                File checkpointDir = this.checkpointFile.getParentFile();
                if (!checkpointDir.exists()) {
                    DKUFileUtils.mkdirsParent((File)checkpointDir);
                }
                File tempFile = new File(checkpointDir, "_checkpoint.json");
                JSON.prettyToFile((Object)checkpoint, (File)tempFile);
                if (DKUtils.isOsWindows() && this.checkpointFile.exists()) {
                    Files.delete(this.checkpointFile.toPath());
                }
                if (!tempFile.renameTo(this.checkpointFile)) {
                    throw new Exception("Unable to checkpoint output");
                }
                this.emitted = 0L;
                this.lastEmitted = System.currentTimeMillis();
                return true;
            }
            return false;
        }
    }

    private static class StreamWriterCheckpointStorer
    implements OffsetStoringAble {
        private final StreamWriter writer;
        private final long checkpointInterval;
        private final long checkpointMaxRows;
        private long lastEmitted = System.currentTimeMillis();
        private long emitted = 0L;

        public StreamWriterCheckpointStorer(StreamWriter writer, long checkpointInterval, long checkpointMaxRows) {
            this.writer = writer;
            this.checkpointInterval = checkpointInterval;
            this.checkpointMaxRows = checkpointMaxRows;
        }

        @Override
        public FunctionCheckpoint readLastCheckpointStored() throws Exception {
            String state = this.writer.getRecordedState();
            return StringUtils.isNotBlank((String)state) ? (FunctionCheckpoint)JSON.parse((String)state, FunctionCheckpoint.class) : null;
        }

        @Override
        public boolean newCheckpoint(int nRows, FunctionCheckpoint checkpoint) throws Exception {
            this.emitted += (long)nRows;
            if (this.emitted > this.checkpointMaxRows || System.currentTimeMillis() - this.lastEmitted > this.checkpointInterval && this.emitted > 0L) {
                this.writer.checkpoint(JSON.json((Object)checkpoint));
                this.emitted = 0L;
                this.lastEmitted = System.currentTimeMillis();
                return true;
            }
            return false;
        }
    }

    private static class OffsetDummyNonStoring
    implements OffsetStoringAble {
        private OffsetDummyNonStoring() {
        }

        @Override
        public FunctionCheckpoint readLastCheckpointStored() {
            return null;
        }

        @Override
        public boolean newCheckpoint(int emitted, FunctionCheckpoint checkpoint) {
            return true;
        }
    }
}

