/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.scala;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.recipes.streaming.AbstractSparkBasedContinuousRecipeRunner;
import com.dataiku.dip.recipes.streaming.scala.StreamingSparkScalaRecipeMeta;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class StreamingSparkScalaRecipeRunner
extends AbstractSparkBasedContinuousRecipeRunner
implements AbortableRecipeRunner {
    @Autowired
    private RecipesDAO recipesDAO;

    public StreamingSparkScalaRecipeRunner(ContinuousActivity activity, SerializedRecipe sr) {
        super(activity, sr);
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void run() throws Exception {
        final String code = this.recipesDAO.getPayloadOrNull(this.activity.projectKey, this.activity.recipeId);
        final StreamingSparkScalaRecipeMeta.StreamingSparkScalaRecipeParams params = this.recipe.getParamsAs(StreamingSparkScalaRecipeMeta.StreamingSparkScalaRecipeParams.class);
        this.runSpark(SparkJobHelper.RunMode.SPARK, "Scala", null, params.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File tmpScriptData = new File(runDir, "recipe.scala");
                DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)code);
                Boolean useGlobalMetastore = params.useGlobalMetastore;
                Object metastoreDatabase = null;
                T job = helper.makeClassJob("Spark-Scala Recipe", true, effectiveConf, "com.dataiku.dip.spark.recipe.StreamingSparkScalaRecipeEntryPoint", tmpScriptData.getAbsolutePath(), params.codeMode.toString(), useGlobalMetastore.toString(), metastoreDatabase == null ? "" : metastoreDatabase);
                ((SparkJob)job).secretDriverFiles.add(tmpScriptData.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return params.sparkConfig;
            }
        }, null, null);
    }
}

