/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditDetector
implements SanityCheckDetectorBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.auditdetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        try (Transaction read = this.transactionService.beginRead();){
            generalSettings = this.generalSettingsDAO.getUnsafe();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get general settings", (Throwable)e);
            messages.addMessage(this.createFatalMessage(e));
            return messages;
        }
        if (!exclusionList.contains(Codes.WARN_MISC_AUDIT_NO_LOG4J_LOCAL_TARGET.getCode()) && generalSettings.auditTrailSettings.targets.stream().noneMatch(target -> target instanceof Log4JTargetSettings)) {
            messages.withWarning((InfoMessage.MessageCode)Codes.WARN_MISC_AUDIT_NO_LOG4J_LOCAL_TARGET, "No `Log4J` target has been set in the instance's audit settings. Events won't be recorded.");
        }
        if (!exclusionList.contains(Codes.WARN_MISC_EVENT_SERVER_NO_TARGET.getCode()) && "true".equals(ApplicationConfigurator.getIniValue((String)"eventserver", (String)"enabled", (String)"false")) && generalSettings.eventServerSettings.targets.size() == 0) {
            messages.withWarning((InfoMessage.MessageCode)Codes.WARN_MISC_EVENT_SERVER_NO_TARGET, "Event server is enabled but there is no target defined. All received events will be dropped.");
        }
        return messages;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_AUDIT_NO_LOG4J_LOCAL_TARGET("Auditing - no Log4j local target", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_MISC),
        WARN_MISC_EVENT_SERVER_NO_TARGET("Event Server - no target", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_MISC);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

