/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.sanitycheck.detectors.DiskDetector;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class EnvVarDetector
implements SanityCheckDetectorBase {
    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(DiskDetector.Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        if (!exclusionList.contains(Codes.WARN_MISC_ENVVAR_SPECIAL_CHAR.getCode())) {
            Map<String, String> env = System.getenv();
            List<String> excludedEnvVars = Arrays.asList("BASH_FUNC_which%%");
            List nastyEnvVars = env.keySet().stream().filter(key -> !key.matches(KubernetesExecUtils.ALLOWED_ENV_VARS.toString())).filter(key -> !excludedEnvVars.contains(key)).collect(Collectors.toList());
            if (!nastyEnvVars.isEmpty()) {
                messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_MISC_ENVVAR_SPECIAL_CHAR, "<p>Some of your environment variables contain special characters such as \"%\" or start by a number, which is not supported by kubernetes. These variables will be suppressed in containerized jobs.</p>", "List of the environment variables", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", nastyEnvVars))));
            }
        }
        return messages;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_ENVVAR_SPECIAL_CHAR("Environment variables with special characters", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

