/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(value=ProjectItem.class, type="PROJECT"), @Mapping(value=DatasetItem.class, type="DATASET"), @Mapping(value=RecipeItem.class, type="RECIPE"), @Mapping(value=DatasetPartitionItem.class, type="DATASET_PARTITION"), @Mapping(value=ScenarioItem.class, type="SCENARIO"), @Mapping(value=ScenarioStepItem.class, type="SCENARIO_STEP"), @Mapping(value=ScenarioTriggerItem.class, type="SCENARIO_TRIGGER"), @Mapping(value=ManagedFolderItem.class, type="MANAGED_FOLDER"), @Mapping(value=ManagedFolderPartitionItem.class, type="MANAGED_FOLDER_PARTITION"), @Mapping(value=ModelEvaluationStoreItem.class, type="MODEL_EVALUATION_STORE"), @Mapping(value=RetrievableKnowledgeItem.class, type="RETRIEVABLE_KNOWLEDGE"), @Mapping(value=ModelEvaluationStorePartitionItem.class, type="MODEL_EVALUATION_STORE_PARTITION"), @Mapping(value=ManagedFolderFileItem.class, type="MANAGED_FOLDER_FILE"), @Mapping(value=SavedModelItem.class, type="SAVED_MODEL"), @Mapping(value=SavedModelPartitionItem.class, type="SAVED_MODEL_PARTITION"), @Mapping(value=SQLConnectionItem.class, type="SQL_CONNECTION"), @Mapping(value=JobsItem.class, type="JOBS"), @Mapping(value=InsightItem.class, type="INSIGHT"), @Mapping(value=PythonItem.class, type="PYTHON"), @Mapping(value=LambdaServiceItem.class, type="LAMBDA_SERVICE"), @Mapping(value=BundleItem.class, type="BUNDLE"), @Mapping(value=DeploymentItem.class, type="DEPLOYMENT"), @Mapping(value=DashboardExportItem.class, type="DASHBOARD_EXPORT"), @Mapping(value=ModelDocumentationExportItem.class, type="MODEL_DOCUMENTATION_EXPORT"), @Mapping(value=FlowDocumentationExportItem.class, type="FLOW_DOCUMENTATION_EXPORT"), @Mapping(value=JupyterNotebookItem.class, type="JUPYTER_NOTEBOOK"), @Mapping(value=RMarkdownReportItem.class, type="RMARKDOWN_REPORT"), @Mapping(value=WikiArticleExportItem.class, type="WIKI_EXPORT_ARTICLE"), @Mapping(value=WikiExportItem.class, type="WIKI_EXPORT"), @Mapping(value=KeptFileItem.class, type="KEPT_FILE"), @Mapping(value=InlineHtmlItem.class, type="INLINE_HTML"), @Mapping(value=UrlItem.class, type="URL"), @Mapping(value=InlineResultTableItem.class, type="INLINE_RESULT_TABLE"), @Mapping(value=ClusterItem.class, type="CLUSTER"), @Mapping(value=JsonObjectItem.class, type="JSON_OBJECT"), @Mapping(value=ContinuousActivityItem.class, type="CONTINUOUS_ACTIVITY"), @Mapping(value=StreamingEndpointItem.class, type="STREAMING_ENDPOINT"), @Mapping(value=WebAppItem.class, type="WEBAPP"), @Mapping(value=CodeStudioItem.class, type="CODE_STUDIO"), @Mapping(value=PythonUnitTestItem.class, type="PYTHON_UNIT_TEST"), @Mapping(value=SwappableRecipeInputsItem.class, type="SWAPPABLE_RECIPE_INPUTS"), @Mapping(value=ComparableDatasetsItem.class, type="COMPARABLE_DATASETS"), @Mapping(value=InitialFlowTestStateItem.class, type="INITIAL_FLOW_TEST_STATE")}, enumClass=ReportTargetType.class)
public abstract class ReportTargetItem {
    public final ReportTargetType type = this.getType();

    public ReportTargetType getType() {
        return (ReportTargetType)JSON.getEnumType((Object)this);
    }

    public static enum ReportTargetType {
        PROJECT,
        DATASET,
        RECIPE,
        DATASET_PARTITION,
        MANAGED_FOLDER,
        MANAGED_FOLDER_PARTITION,
        MANAGED_FOLDER_FILE,
        SAVED_MODEL,
        SAVED_MODEL_PARTITION,
        MODEL_EVALUATION_STORE,
        MODEL_EVALUATION_STORE_PARTITION,
        RETRIEVABLE_KNOWLEDGE,
        SCENARIO,
        SCENARIO_TRIGGER,
        SCENARIO_STEP,
        SQL_CONNECTION,
        JOBS,
        INSIGHT,
        JUPYTER_NOTEBOOK,
        PYTHON,
        LAMBDA_SERVICE,
        BUNDLE,
        DEPLOYMENT,
        INLINE_HTML,
        KEPT_FILE,
        URL,
        INLINE_RESULT_TABLE,
        WEBAPP,
        CODE_STUDIO,
        RMARKDOWN_REPORT,
        DASHBOARD_EXPORT,
        WIKI_EXPORT,
        WIKI_EXPORT_ARTICLE,
        MODEL_DOCUMENTATION_EXPORT,
        FLOW_DOCUMENTATION_EXPORT,
        CLUSTER,
        JSON_OBJECT,
        CONTINUOUS_ACTIVITY,
        STREAMING_ENDPOINT,
        PYTHON_UNIT_TEST,
        SWAPPABLE_RECIPE_INPUTS,
        COMPARABLE_DATASETS,
        INITIAL_FLOW_TEST_STATE;

    }

    public static class InitialFlowTestStateItem
    extends ReportTargetItem {
        public boolean equals(Object o) {
            return o instanceof InitialFlowTestStateItem;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class ComparableDatasetsItem
    extends ReportTargetItem {
        private String resultItemId;
        @Nullable
        private String resultItemProjectKey;
        private String expectedItemId;
        @Nullable
        private String expectedItemProjectKey;
        @Nullable
        String partitionsSpec;
        private boolean contentComparison;
        private boolean allColumnsComparison;
        @Nullable
        List<String> equalityColumns;

        private ComparableDatasetsItem() {
        }

        public ComparableDatasetsItem(String resultItemId, @Nullable String resultItemProjectKey, String expectedItemId, @Nullable String expectedItemProjectKey, @Nullable String partitionsSpec, boolean contentComparison, boolean allColumnsComparison, @Nullable List<String> equalityColumns) {
            this.resultItemId = resultItemId;
            this.resultItemProjectKey = resultItemProjectKey;
            this.expectedItemId = expectedItemId;
            this.partitionsSpec = partitionsSpec;
            this.expectedItemProjectKey = expectedItemProjectKey;
            this.contentComparison = contentComparison;
            this.allColumnsComparison = allColumnsComparison;
            this.equalityColumns = equalityColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparableDatasetsItem that = (ComparableDatasetsItem)o;
            return this.contentComparison == that.contentComparison && Objects.equals(this.resultItemId, that.resultItemId) && Objects.equals(this.resultItemProjectKey, that.resultItemProjectKey) && Objects.equals(this.expectedItemId, that.expectedItemId) && Objects.equals(this.expectedItemProjectKey, that.expectedItemProjectKey) && Objects.equals(this.equalityColumns, that.equalityColumns);
        }

        public int hashCode() {
            return Objects.hash(this.resultItemId, this.resultItemProjectKey, this.expectedItemId, this.expectedItemProjectKey, this.contentComparison, this.equalityColumns);
        }
    }

    public static class SwappableRecipeInputsItem
    extends ReportTargetItem {
        private String recipeId;
        private String sourceItemId;
        @Nullable
        private String sourceItemProjectKey;
        private String targetItemId;
        @Nullable
        private String targetItemProjectKey;

        private SwappableRecipeInputsItem() {
        }

        public SwappableRecipeInputsItem(String recipeId, String sourceItemId, @Nullable String sourceItemProjectKey, String targetItemId, @Nullable String targetItemProjectKey) {
            this.recipeId = recipeId;
            this.sourceItemId = sourceItemId;
            this.sourceItemProjectKey = sourceItemProjectKey;
            this.targetItemId = targetItemId;
            this.targetItemProjectKey = targetItemProjectKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SwappableRecipeInputsItem that = (SwappableRecipeInputsItem)o;
            return Objects.equals(this.recipeId, that.recipeId) && Objects.equals(this.sourceItemId, that.sourceItemId) && Objects.equals(this.sourceItemProjectKey, that.sourceItemProjectKey) && Objects.equals(this.targetItemId, that.targetItemId) && Objects.equals(this.targetItemProjectKey, that.targetItemProjectKey);
        }

        public int hashCode() {
            return Objects.hash(this.recipeId, this.sourceItemId, this.sourceItemProjectKey, this.targetItemId, this.targetItemProjectKey);
        }
    }

    public static class PythonUnitTestItem
    extends ReportTargetItem {
        private String testsSelector;

        private PythonUnitTestItem() {
        }

        public PythonUnitTestItem(String testsSelector) {
            this.testsSelector = testsSelector;
        }

        public String getTestsSelector() {
            return this.testsSelector;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PythonUnitTestItem that = (PythonUnitTestItem)o;
            return Objects.equals(this.getTestsSelector(), that.getTestsSelector());
        }

        public int hashCode() {
            return Objects.hash(this.testsSelector);
        }
    }

    public static class StreamingEndpointItem
    extends ReportTargetItem {
        public String streamingEndpointId;
        public String projectKey;

        private StreamingEndpointItem() {
        }

        public StreamingEndpointItem(String projectKey, String StreamingEndpointId) {
            this.projectKey = projectKey;
            this.streamingEndpointId = StreamingEndpointId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StreamingEndpointItem)) {
                return false;
            }
            StreamingEndpointItem that = (StreamingEndpointItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.streamingEndpointId, that.streamingEndpointId);
        }
    }

    public static class ContinuousActivityItem
    extends ReportTargetItem {
        public String continuousActivityId;
        public String projectKey;

        private ContinuousActivityItem() {
        }

        public ContinuousActivityItem(String projectKey, String continuousActivityId) {
            this.projectKey = projectKey;
            this.continuousActivityId = continuousActivityId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ContinuousActivityItem)) {
                return false;
            }
            ContinuousActivityItem that = (ContinuousActivityItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.continuousActivityId, that.continuousActivityId);
        }
    }

    public static class ClusterItem
    extends ReportTargetItem {
        public String clusterId;

        private ClusterItem() {
        }

        public ClusterItem(String clusterId) {
            this.clusterId = clusterId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClusterItem)) {
                return false;
            }
            ClusterItem that = (ClusterItem)o;
            return Objects.equals(this.clusterId, that.clusterId);
        }
    }

    public static class InlineResultTableItem
    extends ReportTargetItem {
        public JsonObject table;

        private InlineResultTableItem() {
        }

        public InlineResultTableItem(JsonObject table) {
            this.table = table;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return false;
        }
    }

    public static class JsonObjectItem
    extends ReportTargetItem {
        public JsonObject object;

        private JsonObjectItem() {
        }

        public JsonObjectItem(JsonObject object) {
            this.object = object;
        }
    }

    public static class UrlItem
    extends ReportTargetItem {
        public String url;

        private UrlItem() {
        }

        public UrlItem(String url) {
            this.url = url;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UrlItem)) {
                return false;
            }
            UrlItem co2 = (UrlItem)o;
            return Objects.equals(this.url, co2.url);
        }
    }

    public static class InlineHtmlItem
    extends ReportTargetItem {
        public String data;

        private InlineHtmlItem() {
        }

        public InlineHtmlItem(String data) {
            this.data = data;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof InlineHtmlItem)) {
                return false;
            }
            InlineHtmlItem co2 = (InlineHtmlItem)o;
            return Objects.equals(this.data, co2.data);
        }
    }

    public static class KeptFileItem
    extends ReportTargetItem {
        public String path;
        public String fileType;
        public String mimeType;

        private KeptFileItem() {
        }

        public KeptFileItem(String fileType, String path, String mimeType) {
            this.fileType = fileType;
            this.path = path;
            this.mimeType = mimeType;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeptFileItem)) {
                return false;
            }
            KeptFileItem co2 = (KeptFileItem)o;
            return Objects.equals(this.fileType, co2.fileType) && Objects.equals(this.mimeType, co2.mimeType) && Objects.equals(this.path, co2.path);
        }
    }

    public static class DeploymentItem
    extends ReportTargetItem {
        public String deploymentId;

        private DeploymentItem() {
        }

        public DeploymentItem(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DeploymentItem)) {
                return false;
            }
            DeploymentItem co2 = (DeploymentItem)o;
            return Objects.equals(this.deploymentId, co2.deploymentId);
        }
    }

    public static class BundleItem
    extends ReportTargetItem {
        public String projectKey;
        public String bundleId;

        private BundleItem() {
        }

        public BundleItem(String projectKey, String bundleId) {
            this.projectKey = projectKey;
            this.bundleId = bundleId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleItem)) {
                return false;
            }
            BundleItem co2 = (BundleItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.bundleId, co2.bundleId);
        }
    }

    public static class LambdaServiceItem
    extends ReportTargetItem {
        public String projectKey;
        public String serviceId;

        private LambdaServiceItem() {
        }

        public LambdaServiceItem(String projectKey, String serviceId) {
            this.projectKey = projectKey;
            this.serviceId = serviceId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LambdaServiceItem)) {
                return false;
            }
            LambdaServiceItem co2 = (LambdaServiceItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.serviceId, co2.serviceId);
        }
    }

    public static class CodeStudioItem
    extends ReportTargetItem {
        public String projectKey;
        public String codeStudioId;

        @Override
        public ReportTargetType getType() {
            return ReportTargetType.CODE_STUDIO;
        }

        private CodeStudioItem() {
        }

        public CodeStudioItem(String projectKey, String codeStudioId) {
            this.projectKey = projectKey;
            this.codeStudioId = codeStudioId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CodeStudioItem)) {
                return false;
            }
            CodeStudioItem co2 = (CodeStudioItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.codeStudioId, co2.codeStudioId);
        }
    }

    public static class WebAppItem
    extends ReportTargetItem {
        public String projectKey;
        public String webAppId;

        private WebAppItem() {
        }

        public WebAppItem(String projectKey, String webAppId) {
            this.projectKey = projectKey;
            this.webAppId = webAppId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WebAppItem)) {
                return false;
            }
            WebAppItem co2 = (WebAppItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.webAppId, co2.webAppId);
        }
    }

    public static class WikiExportItem
    extends ReportTargetItem {
        public String projectKey;
        public String folderId;
        public String folderName;

        private WikiExportItem() {
        }

        public WikiExportItem(String projectKey, String folderId, String folderName) {
            this.projectKey = projectKey;
            this.folderId = folderId;
            this.folderName = folderName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WikiExportItem)) {
                return false;
            }
            WikiExportItem that = (WikiExportItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.folderId, that.folderId);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.folderId);
        }
    }

    public static class WikiArticleExportItem
    extends ReportTargetItem {
        public String projectKey;
        public String articleId;
        public String articleName;
        public String folderId;
        public String folderName;

        private WikiArticleExportItem() {
        }

        public WikiArticleExportItem(String projectKey, String articleId, String articleName, String folderId, String folderName) {
            this.projectKey = projectKey;
            this.articleId = articleId;
            this.articleName = articleName;
            this.folderId = folderId;
            this.folderName = folderName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WikiArticleExportItem)) {
                return false;
            }
            WikiArticleExportItem that = (WikiArticleExportItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.articleId, that.articleId) && Objects.equals(this.folderId, that.folderId);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.articleId, this.folderId);
        }
    }

    public static class RMarkdownReportItem
    extends ReportTargetItem {
        public String projectKey;
        public String reportId;

        private RMarkdownReportItem() {
        }

        public RMarkdownReportItem(String projectKey, String reportId) {
            this.projectKey = projectKey;
            this.reportId = reportId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RMarkdownReportItem)) {
                return false;
            }
            RMarkdownReportItem co2 = (RMarkdownReportItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.reportId, co2.reportId);
        }
    }

    public static class JupyterNotebookItem
    extends ReportTargetItem {
        public String projectKey;
        public String notebookId;

        private JupyterNotebookItem() {
        }

        public JupyterNotebookItem(String projectKey, String notebookId) {
            this.projectKey = projectKey;
            this.notebookId = notebookId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JupyterNotebookItem)) {
                return false;
            }
            JupyterNotebookItem co2 = (JupyterNotebookItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.notebookId, co2.notebookId);
        }
    }

    public static class FlowDocumentationExportItem
    extends ReportTargetItem {
        public String projectKey;
        public String folderId;
        public String folderName;

        private FlowDocumentationExportItem() {
        }

        public FlowDocumentationExportItem(String projectKey, String folderId, String folderName) {
            this.projectKey = projectKey;
            this.folderId = folderId;
            this.folderName = folderName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlowDocumentationExportItem)) {
                return false;
            }
            FlowDocumentationExportItem that = (FlowDocumentationExportItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.folderId, that.folderId);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.folderId);
        }
    }

    public static class ModelDocumentationExportItem
    extends ReportTargetItem {
        public String projectKey;
        public String fullModelId;
        public String folderId;
        private String folderName;
        private String mlTaskType;

        private ModelDocumentationExportItem() {
        }

        public ModelDocumentationExportItem(String projectKey, String fullModelId, String folderId, String folderName, String mlTaskType) {
            this.projectKey = projectKey;
            this.fullModelId = fullModelId;
            this.folderId = folderId;
            this.folderName = folderName;
            this.mlTaskType = mlTaskType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModelDocumentationExportItem)) {
                return false;
            }
            ModelDocumentationExportItem that = (ModelDocumentationExportItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.fullModelId, that.fullModelId) && Objects.equals(this.folderId, that.folderId);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.fullModelId, this.folderId);
        }
    }

    public static class DashboardExportItem
    extends ReportTargetItem {
        public String projectKey;
        public String dashboardId;
        public String dashboardName;
        public String folderId;
        public String folderName;

        private DashboardExportItem() {
        }

        public DashboardExportItem(String projectKey, String dashboardId, String dashboardName, String folderId, String folderName) {
            this.projectKey = projectKey;
            this.dashboardId = dashboardId;
            this.dashboardName = dashboardName;
            this.folderId = folderId;
            this.folderName = folderName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DashboardExportItem)) {
                return false;
            }
            DashboardExportItem that = (DashboardExportItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.dashboardId, that.dashboardId) && Objects.equals(this.folderId, that.folderId);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.dashboardId, this.folderId);
        }
    }

    public static class InsightItem
    extends ReportTargetItem {
        public String projectKey;
        public String insightId;

        private InsightItem() {
        }

        public InsightItem(String projectKey, String insightId) {
            this.projectKey = projectKey;
            this.insightId = insightId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof InsightItem)) {
                return false;
            }
            InsightItem co2 = (InsightItem)o;
            return this.projectKey.equals(co2.projectKey) && this.insightId.equals(co2.insightId);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.insightId);
        }
    }

    public static class PythonItem
    extends ReportTargetItem {
        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof PythonItem;
        }
    }

    public static class JobsItem
    extends ReportTargetItem {
        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof JobsItem;
        }
    }

    public static class SQLConnectionItem
    extends ReportTargetItem {
        public String connection;

        private SQLConnectionItem() {
        }

        public SQLConnectionItem(String connection) {
            this.connection = connection;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SQLConnectionItem)) {
                return false;
            }
            SQLConnectionItem co2 = (SQLConnectionItem)o;
            return this.connection.equals(co2.connection);
        }
    }

    public static class ManagedFolderFileItem
    extends ReportTargetItem {
        public String projectKey;
        public String folderId;
        public String itemPath;

        private ManagedFolderFileItem() {
        }

        public ManagedFolderFileItem(String projectKey, String folderId, String itemPath) {
            this.projectKey = projectKey;
            this.folderId = folderId;
            this.itemPath = itemPath;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ManagedFolderFileItem)) {
                return false;
            }
            ManagedFolderFileItem co2 = (ManagedFolderFileItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.folderId, co2.folderId) && Objects.equals(this.itemPath, co2.itemPath);
        }
    }

    public static class RetrievableKnowledgeItem
    extends ReportTargetItem {
        public String projectKey;
        public String retrievableKnowledgeId;

        private RetrievableKnowledgeItem() {
        }

        public RetrievableKnowledgeItem(String projectKey, String retrievableKnowledgeId) {
            this.projectKey = projectKey;
            this.retrievableKnowledgeId = retrievableKnowledgeId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RetrievableKnowledgeItem)) {
                return false;
            }
            RetrievableKnowledgeItem co2 = (RetrievableKnowledgeItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.retrievableKnowledgeId, co2.retrievableKnowledgeId);
        }
    }

    public static class ModelEvaluationStorePartitionItem
    extends ReportTargetItem
    implements DowncastableItem {
        public String projectKey;
        public String evaluationStoreId;
        public String partition;

        private ModelEvaluationStorePartitionItem() {
        }

        public ModelEvaluationStorePartitionItem(String projectKey, String evaluationStoreId, String partition) {
            this.projectKey = projectKey;
            this.evaluationStoreId = evaluationStoreId;
            this.partition = partition;
        }

        @Override
        public ReportTargetItem downcast() {
            return new ModelEvaluationStoreItem(this.projectKey, this.evaluationStoreId);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ModelEvaluationStorePartitionItem)) {
                return false;
            }
            ModelEvaluationStorePartitionItem co2 = (ModelEvaluationStorePartitionItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.evaluationStoreId, co2.evaluationStoreId) && Objects.equals(this.partition, co2.partition);
        }
    }

    public static class ModelEvaluationStoreItem
    extends ReportTargetItem {
        public String projectKey;
        public String evaluationStoreId;

        private ModelEvaluationStoreItem() {
        }

        public ModelEvaluationStoreItem(String projectKey, String evaluationStoreId) {
            this.projectKey = projectKey;
            this.evaluationStoreId = evaluationStoreId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ModelEvaluationStoreItem)) {
                return false;
            }
            ModelEvaluationStoreItem co2 = (ModelEvaluationStoreItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.evaluationStoreId, co2.evaluationStoreId);
        }
    }

    public static class ManagedFolderPartitionItem
    extends ReportTargetItem
    implements DowncastableItem {
        public String projectKey;
        public String folderId;
        public String partition;

        private ManagedFolderPartitionItem() {
        }

        public ManagedFolderPartitionItem(String projectKey, String folderId, String partition) {
            this.projectKey = projectKey;
            this.folderId = folderId;
            this.partition = partition;
        }

        @Override
        public ReportTargetItem downcast() {
            return new ManagedFolderItem(this.projectKey, this.folderId);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ManagedFolderPartitionItem)) {
                return false;
            }
            ManagedFolderPartitionItem co2 = (ManagedFolderPartitionItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.folderId, co2.folderId) && Objects.equals(this.partition, co2.partition);
        }
    }

    public static class ManagedFolderItem
    extends ReportTargetItem {
        public String projectKey;
        public String folderId;

        private ManagedFolderItem() {
        }

        public ManagedFolderItem(String projectKey, String folderId) {
            this.projectKey = projectKey;
            this.folderId = folderId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ManagedFolderItem)) {
                return false;
            }
            ManagedFolderItem co2 = (ManagedFolderItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.folderId, co2.folderId);
        }
    }

    public static class SavedModelPartitionItem
    extends ReportTargetItem {
        public String projectKey;
        public String modelId;
        public String partition;

        private SavedModelPartitionItem() {
        }

        public SavedModelPartitionItem(String projectKey, String modelId, String partition) {
            this.projectKey = projectKey;
            this.modelId = modelId;
            this.partition = partition;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SavedModelPartitionItem)) {
                return false;
            }
            SavedModelPartitionItem co2 = (SavedModelPartitionItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.modelId, co2.modelId) && Objects.equals(this.partition, co2.partition);
        }
    }

    public static class SavedModelItem
    extends ReportTargetItem {
        public String projectKey;
        public String modelId;

        private SavedModelItem() {
        }

        public SavedModelItem(String projectKey, String modelId) {
            this.projectKey = projectKey;
            this.modelId = modelId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SavedModelItem)) {
                return false;
            }
            SavedModelItem co2 = (SavedModelItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.modelId, co2.modelId);
        }
    }

    public static class ScenarioTriggerItem
    extends ReportTargetItem {
        public String projectKey;
        public String scenarioId;
        public String triggerId;

        private ScenarioTriggerItem() {
        }

        public ScenarioTriggerItem(String projectKey, String scenarioId, String triggerId) {
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
            this.triggerId = triggerId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScenarioTriggerItem)) {
                return false;
            }
            ScenarioTriggerItem co2 = (ScenarioTriggerItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.scenarioId, co2.scenarioId) && Objects.equals(this.triggerId, co2.triggerId);
        }
    }

    public static class ScenarioStepItem
    extends ReportTargetItem {
        public String projectKey;
        public String scenarioId;
        public String stepId;

        private ScenarioStepItem() {
        }

        public ScenarioStepItem(StepRun stepRun) {
            this(stepRun.getScenarioRun(), stepRun.getStep().getId());
        }

        public ScenarioStepItem(ScenarioRun scenarioRun, String stepId) {
            this(scenarioRun.getScenario().getProjectKey(), scenarioRun.getScenario().getId(), stepId);
        }

        public ScenarioStepItem(String projectKey, String scenarioId, String stepId) {
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
            this.stepId = stepId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScenarioStepItem)) {
                return false;
            }
            ScenarioStepItem co2 = (ScenarioStepItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.scenarioId, co2.scenarioId) && Objects.equals(this.stepId, co2.stepId);
        }
    }

    public static class ScenarioItem
    extends ReportTargetItem {
        public String projectKey;
        public String scenarioId;

        private ScenarioItem() {
        }

        public ScenarioItem(ScenarioRun scenarioRun) {
            this(scenarioRun.getScenario());
        }

        public ScenarioItem(Scenario scenario) {
            this(scenario.getProjectKey(), scenario.getId());
        }

        public ScenarioItem(String projectKey, String scenarioId) {
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScenarioItem)) {
                return false;
            }
            ScenarioItem co2 = (ScenarioItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.scenarioId, co2.scenarioId);
        }
    }

    public static class DatasetPartitionItem
    extends ReportTargetItem
    implements DowncastableItem {
        public String projectKey;
        public String datasetName;
        public String partition;

        private DatasetPartitionItem() {
        }

        public DatasetPartitionItem(String projectKey, String datasetName, String partition) {
            this.projectKey = projectKey;
            this.datasetName = datasetName;
            this.partition = partition;
        }

        @Override
        public ReportTargetItem downcast() {
            return new DatasetItem(this.projectKey, this.datasetName);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DatasetPartitionItem)) {
                return false;
            }
            DatasetPartitionItem co2 = (DatasetPartitionItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.datasetName, co2.datasetName) && Objects.equals(this.partition, co2.partition);
        }
    }

    public static class DatasetItem
    extends ReportTargetItem {
        public String projectKey;
        public String datasetName;

        private DatasetItem() {
        }

        public DatasetItem(String projectKey, String datasetName) {
            this.projectKey = projectKey;
            this.datasetName = datasetName;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DatasetItem)) {
                return false;
            }
            DatasetItem co2 = (DatasetItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.datasetName, co2.datasetName);
        }
    }

    public static class RecipeItem
    extends ReportTargetItem {
        public String projectKey;
        public String recipeName;

        private RecipeItem() {
        }

        public RecipeItem(String projectKey, String recipeName) {
            this.projectKey = projectKey;
            this.recipeName = recipeName;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RecipeItem)) {
                return false;
            }
            RecipeItem co2 = (RecipeItem)o;
            return Objects.equals(this.projectKey, co2.projectKey) && Objects.equals(this.recipeName, co2.recipeName);
        }
    }

    public static class ProjectItem
    extends ReportTargetItem {
        public final String projectKey;

        private ProjectItem() {
            this.projectKey = null;
        }

        public ProjectItem(String projectKey) {
            this.projectKey = projectKey;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProjectItem)) {
                return false;
            }
            ProjectItem co2 = (ProjectItem)o;
            return Objects.equals(this.projectKey, co2.projectKey);
        }
    }

    public static interface DowncastableItem {
        public ReportTargetItem downcast();
    }
}

