/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.scheduler.runnables.DSSRunnableMeta;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;

public class DSSRunnableRegistry {
    static Map<String, DSSRunnableMeta> library = Maps.newLinkedHashMap();

    public static synchronized DSSRunnableMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        if (type.startsWith("jrunnable") || type.startsWith("pyrunnable")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Unknown runnable type: " + type);
        }
        throw new Error("Unknown runnable type " + type);
    }

    public static synchronized Iterable<DSSRunnableMeta> getAllMeta() {
        return new ArrayList<DSSRunnableMeta>(library.values());
    }

    public static synchronized void register(DSSRunnableMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static synchronized void deregister(String type) {
        library.remove(type);
    }
}

