/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.scheduler.PerScenarioLoggingAppender;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.springframework.stereotype.Service;

@Service
public class ScenarioRunContext {
    private InheritableThreadLocal<ScenarioFromJobLoc> currentJob = new InheritableThreadLocal();
    private InheritableThreadLocal<ScenarioRun> currentScenarioRun = new InheritableThreadLocal();
    private InheritableThreadLocal<StepRun> currentStepRun = new InheritableThreadLocal();
    private PerScenarioLoggingAppender appender = new PerScenarioLoggingAppender(this);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.scenario.run.context");

    public void setScenarioRun(ScenarioRun scenarioRun) {
        this.currentScenarioRun.set(scenarioRun);
        if (scenarioRun != null && scenarioRun.getTrigger() != null && scenarioRun.getTrigger().getParams() != null && scenarioRun.getTrigger().getParams().has("fromJob")) {
            try {
                JsonObject fromJob = scenarioRun.getTrigger().getParams().get("fromJob").getAsJsonObject();
                ScenarioFromJobLoc loc = new ScenarioFromJobLoc();
                loc.projectKey = fromJob.get("projectKey").getAsString();
                loc.jobId = fromJob.get("jobId").getAsString();
                loc.activityId = fromJob.get("activityId").getAsString();
                if (StringUtils.isBlank((String)loc.projectKey)) {
                    throw new IllegalArgumentException("No projectKey in fromJob");
                }
                if (StringUtils.isBlank((String)loc.jobId)) {
                    throw new IllegalArgumentException("No jobId in fromJob");
                }
                if (StringUtils.isBlank((String)loc.activityId)) {
                    throw new IllegalArgumentException("No activityId in fromJob");
                }
                this.currentJob.set(loc);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to find job from which scenario started", (Throwable)e);
                this.currentJob.set(null);
            }
        } else {
            this.currentJob.set(null);
        }
    }

    public void clearScenarioRun() {
        this.currentScenarioRun.set(null);
        this.currentJob.set(null);
    }

    public ScenarioRun getScenarioRun() {
        return (ScenarioRun)this.currentScenarioRun.get();
    }

    public void setStepRun(StepRun stepRun) {
        this.currentStepRun.set(stepRun);
    }

    public void clearStepRun() {
        this.currentStepRun.set(null);
    }

    public StepRun getStepRun() {
        return (StepRun)this.currentStepRun.get();
    }

    public ScenarioFromJobLoc getJob() {
        return (ScenarioFromJobLoc)this.currentJob.get();
    }

    public JsonObject getVariablesObject() {
        JsonObject scenarioVariables = new JsonObject();
        ScenarioRun scenarioRun = (ScenarioRun)this.currentScenarioRun.get();
        if (scenarioRun != null) {
            scenarioVariables.add("scenarioTriggerParams", (JsonElement)scenarioRun.getTrigger().getParams());
            scenarioVariables.addProperty("scenarioTriggerState", scenarioRun.getTrigger().getTriggerState());
            scenarioVariables.addProperty("scenarioTriggerTime", (Number)scenarioRun.getTrigger().getTimestamp());
            scenarioVariables.addProperty("scenarioTriggerRunId", scenarioRun.getTrigger().getRunId());
            if (scenarioRun.getTrigger() != null) {
                for (Map.Entry e : scenarioRun.getTrigger().getParams().entrySet()) {
                    scenarioVariables.add("scenarioTriggerParam_" + (String)e.getKey(), (JsonElement)e.getValue());
                }
            }
            for (Map.Entry e : scenarioRun.getVariables().entrySet()) {
                scenarioVariables.add((String)e.getKey(), (JsonElement)e.getValue());
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Computed scenario-level variables: " + JSON.json((Object)scenarioVariables)));
        }
        return scenarioVariables;
    }

    public String getActiveCluster() {
        ScenarioRun scenarioRun = (ScenarioRun)this.currentScenarioRun.get();
        if (scenarioRun != null) {
            return scenarioRun.clusterIdOverride;
        }
        return null;
    }

    public String getActiveK8sCluster() {
        ScenarioRun scenarioRun = (ScenarioRun)this.currentScenarioRun.get();
        if (scenarioRun != null) {
            return scenarioRun.k8sClusterIdOverride;
        }
        return null;
    }

    public static File scenariosFolder(String projectKey) {
        return DKUFileUtils.getWithin((File)ApplicationConfigurator.getFile((String)"scenarios"), (String[])new String[]{projectKey});
    }

    public static File scenarioFolder(String projectKey, String scenarioId) {
        return DKUFileUtils.getWithin((File)ScenarioRunContext.scenariosFolder(projectKey), (String[])new String[]{scenarioId});
    }

    public static File scenarioRunFolder(String projectKey, String scenarioId, String runId) {
        return DKUFileUtils.getWithin((File)ScenarioRunContext.scenarioFolder(projectKey, scenarioId), (String[])new String[]{runId});
    }

    public static File scenarioRunFolder(ScenarioRun scenarioRun) {
        Scenario scenario = scenarioRun.getScenario();
        return ScenarioRunContext.scenarioRunFolder(scenario.getProjectKey(), scenario.getId(), scenarioRun.getRunId());
    }

    public static File getLog(ScenarioRun scenarioRun) {
        Scenario scenario = scenarioRun.getScenario();
        if (scenario.getProjectKey().contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        if (scenario.getId().contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        if (scenarioRun.getRunId().contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        return DKUApp.getFile((String[])new String[]{"scenarios", scenario.getProjectKey(), scenario.getId(), scenarioRun.getRunId(), "log.log"});
    }

    public static File getLogFile(ScenariosService.ScenarioRunDetails runDetails, @Nullable String stepId) {
        if (StringUtils.isNotBlank((String)stepId)) {
            return runDetails.stepRuns.stream().filter(sr -> sr.getStep().getId().equals(stepId)).findFirst().map(ScenarioRunContext::getLog).orElse(null);
        }
        File runDir = ScenarioRunContext.scenarioRunFolder(runDetails.scenarioRun.scenario.projectKey, runDetails.scenarioRun.scenario.id, runDetails.scenarioRun.runId);
        File logFileCompressed = new File(runDir, "log.log.gz");
        return logFileCompressed.isFile() && logFileCompressed.canRead() ? logFileCompressed : new File(runDir, "log.log");
    }

    public static File getLog(StepRun stepRun) {
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        Scenario scenario = scenarioRun.getScenario();
        if (scenario.getProjectKey().contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        if (scenario.getId().contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        if (stepRun.getRunId().contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        return DKUApp.getFile((String[])new String[]{"scenarios", scenario.getProjectKey(), scenario.getId(), scenarioRun.getRunId(), "step_" + stepRun.getStep().type + "_" + stepRun.getRunId() + ".log"});
    }

    public static File getScenarioRunFile(ScenarioRun scenarioRun) {
        Scenario scenario = scenarioRun.getScenario();
        return ScenarioRunContext.getScenarioRunFile(scenario.getProjectKey(), scenario.getId(), scenarioRun.getRunId());
    }

    public static File getScenarioCheckFile(ScenarioRun scenarioRun) {
        Scenario scenario = scenarioRun.getScenario();
        return new File(ScenarioRunContext.scenarioRunFolder(scenario.getProjectKey(), scenario.getId(), scenarioRun.getRunId()), "checks.json");
    }

    public static File getScenarioRunFile(String projectKey, String scenarioId, String runId) {
        return new File(ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId), "run.json");
    }

    public void startLogAppender() {
        DKUtils.startLogAppender((Appender)this.appender);
    }

    public Appender getLogAppender() {
        return this.appender;
    }

    public static class ScenarioFromJobLoc {
        public String projectKey;
        public String jobId;
        public String activityId;
    }
}

