/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.WorkspacePermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/discussions"})
public class DiscussionsController
extends DIPInternalControllerBase {
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private WorkspacePermissionsService workspacePermissionsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.discussions.controller");

    @AuditedCall(value={"msgType", "discussion-counts", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/get-discussion-counts"})
    public void getDiscussionCounts(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String workspaceKey) throws Exception {
        AuthCtx authCtx = this.checkPermissions(req, projectKey, null, null, workspaceKey);
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        DiscussionsInternalDB.DiscussionCounts counts = this.discussionsService.getCountsForObject(projectKey, workspaceKey, taggableType, objectId, authCtx);
        DiscussionsController.writeJSON((HttpServletResponse)resp, (Object)counts);
    }

    @AuditedCall(value={"msgType", "discussions-get", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/get-for-object"})
    public void getForObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String workspaceKey) throws Exception {
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        this.checkPermissions(req, projectKey, taggableType, objectId, workspaceKey);
        DiscussionsList ret = new DiscussionsList();
        ret.discussions = this.discussionsService.getForObject(projectKey, workspaceKey, taggableType, objectId);
        try (Transaction t = this.transactionService.beginRead();){
            for (Discussion c2 : ret.discussions) {
                this.discussionsService.enrich(c2);
            }
        }
        DiscussionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "discussions-create", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "topic", "${topic}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String topic, @RequestParam String reply, @RequestParam(required=false) String workspaceKey) throws Exception {
        this.checkDiscussionsEnabled();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.checkPermissions(req, projectKey, taggableType, objectId, workspaceKey);
        Discussion conv = this.discussionsService.create(taggableType, projectKey, workspaceKey, objectId, topic, reply, authCtx);
        this.interestsService.addWatchIfNotExplicit_NT(authCtx.getIdentifier(), taggableType, projectKey, objectId, conv.workspaceKey);
        DiscussionsController.writeJSON((HttpServletResponse)resp, (Object)new Id(conv.id));
    }

    @AuditedCall(value={"msgType", "discussions-save", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "discussionId", "${discussionId}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String discussionId, @RequestParam String topic, @RequestParam(required=false) String workspaceKey) throws Exception {
        this.checkDiscussionsEnabled();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.checkPermissions(req, projectKey, null, null, workspaceKey);
        this.discussionsService.save(taggableType, projectKey, workspaceKey, objectId, discussionId, topic, authCtx);
    }

    @AuditedCall(value={"msgType", "discussions-reply", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "discussionId", "${discussionId}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/reply"})
    public void reply(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String discussionId, @RequestParam String replyId, @RequestParam String content, @RequestParam(required=false) String workspaceKey) throws Exception {
        this.checkDiscussionsEnabled();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.checkPermissions(req, projectKey, null, null, workspaceKey);
        this.discussionsService.reply(taggableType, projectKey, workspaceKey, objectId, discussionId, replyId, content, authCtx);
        this.interestsService.addWatchIfNotExplicit_NT(authCtx.getIdentifier(), taggableType, projectKey, objectId, workspaceKey);
    }

    @AuditedCall(value={"msgType", "discussions-ack", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "discussionId", "${discussionId}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/ack"})
    public void ack(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String discussionId, @RequestParam(required=false) String workspaceKey) throws Exception {
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.catalog.discussions.enabled", true)) {
            logger.info((Object)"Discussions writes are disabled on this instance, ignoring ack");
            return;
        }
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.checkPermissions(req, projectKey, null, null, workspaceKey);
        this.discussionsService.ack(projectKey, workspaceKey, taggableType, objectId, discussionId, authCtx);
    }

    @AuditedCall(value={"msgType", "discussion-close", "projectKey", "${projectKey}", "discussionId", "${discussionId}", "closed", "${closed}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/close"})
    public void close(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String discussionId, @RequestParam String closed, @RequestParam(required=false) String workspaceKey) throws Exception {
        this.checkDiscussionsEnabled();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.checkPermissions(req, projectKey, null, null, workspaceKey);
        this.discussionsService.close(projectKey, workspaceKey, taggableType, objectId, discussionId, !"false".equals(closed), authCtx);
    }

    @AuditedCall(value={"msgType", "discussion-delete", "projectKey", "${projectKey}", "discussionId", "${discussionId}", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/delete-discussion"})
    public void deleteDiscussion(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String discussionId, @RequestParam(required=false) String workspaceKey) throws Exception {
        this.checkDiscussionsEnabled();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.checkPermissions(req, projectKey, null, null, workspaceKey);
        this.discussionsService.deleteDiscussion(taggableType, projectKey, workspaceKey, objectId, discussionId, authCtx);
    }

    private void checkDiscussionsEnabled() {
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.catalog.discussions.enabled", true)) {
            throw new IllegalArgumentException("Discussions writes were disabled in the instance configuration");
        }
    }

    private AuthCtx checkPermissions(HttpServletRequest req, @Nullable String projectKey, @Nullable ITaggingService.TaggableType taggableType, @Nullable String objectId, @Nullable String workspaceKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.projectsService.checkReadDashboardPerm(req, projectKey, taggableType, objectId);
            } else if (StringUtils.isNotBlank((String)workspaceKey)) {
                this.workspacePermissionsService.checkWorkspacePrivileges(this.authService.getMandatoryUser(req), workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
            } else {
                throw ErrorContext.iae((String)"Missing projectKey or workspaceKey");
            }
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    static class DiscussionsList {
        List<Discussion> discussions = new ArrayList<Discussion>();

        DiscussionsList() {
        }
    }

    static class UnreadCount {
        int unread;

        UnreadCount() {
        }
    }
}

