/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectDuplicator {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private TaggableObjectsDeletionService taggableObjectsDeletionService;
    @Autowired
    private ProjectsService projectsService;
    private final String projectKey;
    private final String targetProjectKey;

    public ProjectDuplicator(String projectKey, String targetProjectKey) {
        this.projectKey = projectKey;
        this.targetProjectKey = targetProjectKey;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void shareForeignObjects() throws Exception {
        ProjectFlowGraph projectGraph = this.graphService.getProjectGraphWithOrphansUnsafe(this.projectKey, false);
        List<TaggableObjectsService.TaggableObjectRef> foreignObjects = this.gatherUsedForeignObjects(projectGraph);
        for (TaggableObjectsService.TaggableObjectRef object : foreignObjects) {
            if (!this.projectsService.isObjectAvailableInProject(new SmartObjectRef(object.projectKey, object.type, object.id), this.projectKey)) continue;
            this.exposedObjectsService.addExposedObject(object.projectKey, object.type, object.id, this.targetProjectKey);
        }
    }

    public ExposedInputDatasets shareAndRemapInputObjects() throws Exception {
        ExposedInputDatasets exposedInputDatasets = this.shareInputObjects();
        this.remapInputDatasets(exposedInputDatasets);
        return exposedInputDatasets;
    }

    @VisibleForTesting
    void remapInputDatasets(ExposedInputDatasets exposedInputDatasets) throws IOException {
        List<String> recipes = this.recipesDAO.listUsedNames(this.targetProjectKey);
        Map<String, AnyLoc> toRemap = exposedInputDatasets.toRemap;
        for (String recipe : recipes) {
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(this.targetProjectKey, recipe);
            Map<String, SerializedRecipe.InputRole> inputsUnsafe = sr.getInputsUnsafe();
            boolean hasChangedInput = false;
            for (Map.Entry<String, SerializedRecipe.InputRole> entry : inputsUnsafe.entrySet()) {
                SerializedRecipe.InputRole inputUnsafe = entry.getValue();
                List<SerializedRecipe.RecipeInput> items = inputUnsafe.items;
                int itemNumber = 0;
                for (SerializedRecipe.RecipeInput item : items) {
                    AnyLoc loc = item.getLoc(this.targetProjectKey);
                    String id = loc.getId();
                    AnyLoc locId = toRemap.get(id);
                    if (locId != null) {
                        String targetId = locId.getFullName();
                        inputUnsafe.items.set(itemNumber, new SerializedRecipe.RecipeInput(targetId));
                        hasChangedInput = true;
                    }
                    ++itemNumber;
                }
            }
            if (hasChangedInput) {
                sr.setInputs_INT(inputsUnsafe);
            }
            String payload = this.recipesDAO.getPayloadOrNull(this.projectKey, recipe);
            this.recipesDAO.save(this.targetProjectKey, recipe, sr, payload);
        }
    }

    @VisibleForTesting
    ExposedInputDatasets shareInputObjects() throws Exception {
        FlowComputable fd;
        ProjectFlowGraph projectGraph = this.graphService.getProjectGraphUnsafe(this.projectKey);
        ExposedInputDatasets ret = new ExposedInputDatasets();
        for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(this.projectKey)) {
            fd = projectGraph.getDataset(this.projectKey, dataset.name);
            if (fd == null || !FlowGraph.isSource(fd)) continue;
            ITaggingService.TaggableType objectType = dataset.getTaggableType();
            String objectId = dataset.getId();
            this.exposedObjectsService.addExposedObject(this.projectKey, objectType, objectId, this.targetProjectKey);
            this.replaceObject(objectType, objectId, ret);
        }
        for (ManagedFolder folder : this.managedFolderDAO.listUnsafe(this.projectKey)) {
            fd = projectGraph.getFolder(this.projectKey, folder.getId());
            if (fd == null || !FlowGraph.isSource(fd)) continue;
            ITaggingService.TaggableType taggableType = folder.getTaggableType();
            String id = folder.getId();
            this.exposedObjectsService.addExposedObject(this.projectKey, taggableType, id, this.targetProjectKey);
            this.replaceObject(taggableType, id, ret);
        }
        return ret;
    }

    private void replaceObject(ITaggingService.TaggableType objectType, String objectId, ExposedInputDatasets exposedInputDatasets) throws IOException {
        exposedInputDatasets.toRemap.put(objectId, new AnyLoc(this.projectKey, objectId));
        TaggableObjectsDeletionService.DeletionRequestItem deletionRequestItem = new TaggableObjectsDeletionService.DeletionRequestItem(this.targetProjectKey, objectType, objectId);
        exposedInputDatasets.deletionRequestItems.add(deletionRequestItem);
        AnyLoc loc = deletionRequestItem.getLoc().resolved();
        exposedInputDatasets.taggableObjectsMap.put(deletionRequestItem, this.taggableObjectsReadService.getMandatoryUnsafe(loc.getProjectKey(), deletionRequestItem.type, loc.getId()));
        exposedInputDatasets.ignored.add(new TaggableObjectsService.TaggableObjectRef(deletionRequestItem.projectKey, deletionRequestItem.type, deletionRequestItem.id));
    }

    private List<TaggableObjectsService.TaggableObjectRef> gatherUsedForeignObjects(FlowGraph projectGraph) {
        ArrayList<TaggableObjectsService.TaggableObjectRef> ep = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        this.gatherUsedForeignObjects(ep, projectGraph.datasets);
        this.gatherUsedForeignObjects(ep, projectGraph.folders);
        this.gatherUsedForeignObjects(ep, projectGraph.models);
        this.gatherUsedForeignObjects(ep, projectGraph.streamingEndpoints);
        this.gatherUsedForeignObjects(ep, projectGraph.evaluationStores);
        this.gatherUsedForeignObjects(ep, projectGraph.retrievableKnowledges);
        return ep;
    }

    private void gatherUsedForeignObjects(List<TaggableObjectsService.TaggableObjectRef> foreignObjects, Map<String, ? extends FlowComputable> computables) {
        if (computables != null) {
            for (FlowComputable flowComputable : computables.values()) {
                AnyLoc loc = AnyLoc.resolveFull(flowComputable.getFullId());
                boolean isLocal = loc.getProjectKey().equals(this.projectKey);
                if (isLocal) continue;
                foreignObjects.add(new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), flowComputable.getType().toTaggableType(), loc.getId()));
            }
        }
    }

    public static class ExposedInputDatasets {
        Map<String, AnyLoc> toRemap = new HashMap<String, AnyLoc>();
        Set<TaggableObjectsDeletionService.DeletionRequestItem> deletionRequestItems = new HashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        Map<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject> taggableObjectsMap = new HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject>();
        Set<TaggableObjectsService.TaggableObjectRef> ignored = new HashSet<TaggableObjectsService.TaggableObjectRef>();
    }
}

