/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSynchronizer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class StreamingEndpointsController
extends DIPInternalControllerBase {
    @Autowired
    private StreamingEndpointsDAO dao;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private StreamingEndpointService streamingEndpointService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private InterestsService interestsService;
    private static Logger logger = Logger.getLogger((String)"dku.streamingendpoints.controller");

    @AuditedCall(value={"msgType", "streamingendpoint-list", "projectKey", "${projectKey}", "streamingEdnpointId", "${id}"})
    @RequestMapping(value={"/api/streaming-endpoints/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<StreamingEndpointListItem> heads = new ArrayList<StreamingEndpointListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            for (StreamingEndpoint sr : this.dao.listUnsafe(projectKey)) {
                try {
                    StreamingEndpointListItem head = new StreamingEndpointListItem(sr);
                    this.taggableObjectsService.setEditionInfoFromTags(sr, head);
                    heads.add(head);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read streaming endpoint " + String.valueOf(sr)), (Throwable)e);
                }
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "streamingendpoint-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/streaming-endpoints/list-names"})
    public void listNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<String> steamingEndpointsNames;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            steamingEndpointsNames = this.dao.listUsedNames(projectKey);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, steamingEndpointsNames);
    }

    @AuditedCall(value={"msgType", "streamingendpoint-get", "projectKey", "${projectKey}", "streamingEdnpointId", "${id}"})
    @RequestMapping(value={"/api/streaming-endpoints/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        StreamingEndpoint si;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            si = (StreamingEndpoint)this.dao.getMandatory(projectKey, id);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)si);
    }

    @RequestMapping(value={"/api/streaming-endpoints/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String streamingEndpoint) throws Exception {
        StreamingEndpointService.StreamingEndpointProto proto = (StreamingEndpointService.StreamingEndpointProto)JSON.parse((String)streamingEndpoint, StreamingEndpointService.StreamingEndpointProto.class);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        StreamingEndpoint se = this.streamingEndpointService.create_NT(authCtx, projectKey, proto);
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)se);
    }

    @RequestMapping(value={"/api/streaming-endpoints/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String streamingEndpoint, @RequestParam(required=false) String saveInfo) throws Exception {
        StreamingEndpoint si = (StreamingEndpoint)JSON.parse((String)streamingEndpoint, StreamingEndpoint.class);
        TaggableObjectsService.TaggableObjectSaveInfo info = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkProjectPrivileges(rwt.getUser(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            StreamingEndpoint saved = this.streamingEndpointService.save((RWTransactionRef)rwt, projectKey, si);
            if (info.summaryOnly) {
                rwt.commit("Updated summary of streaming endpoint " + projectKey + "." + saved.id, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                rwt.commit("Updated settings of streaming endpoint " + projectKey + "." + saved.id);
            }
            StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)saved.versionTag);
        }
    }

    @AuditedCall(value={"msgType", "streamingendpoint-get", "projectKey", "${projectKey}", "streamingEdnpointId", "${id}"})
    @RequestMapping(value={"/api/streaming-endpoints/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.StreamingEndpointFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            info = this.navigatorService.getStreamingEndpointFullInfo(loc, projectKey, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "streamingendpoint-get", "projectKey", "${projectKey}", "streamingEdnpointId", "${id}"})
    @RequestMapping(value={"/api/streaming-endpoints/collect-sample"})
    public void collectSample(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="streamingEndpoint") String streamingEndpointStr, @RequestParam(required=false, defaultValue="100") int limit, @RequestParam(required=false, defaultValue="60") int timeout, @RequestParam(required=false, defaultValue="false") boolean inferStorageTypes) throws Exception {
        AuthCtx authCtx;
        StreamingEndpoint streamingEndpoint = (StreamingEndpoint)JSON.parse((String)streamingEndpointStr, StreamingEndpoint.class);
        if (StringUtils.isNotBlank((String)streamingEndpoint.projectKey) && !streamingEndpoint.projectKey.equals(projectKey)) {
            throw new IllegalArgumentException("Cannot test endpoint in another project");
        }
        streamingEndpoint.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, this.streamingEndpointService.collectSample(authCtx, streamingEndpoint, limit, timeout * 1000, inferStorageTypes));
    }

    @AuditInline
    @RequestMapping(value={"/api/streaming-endpoints/test-kafka"})
    public void testKafka(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="streamingEndpoint") String streamingEndpointStr) throws Exception {
        AuthCtx authCtx;
        StreamingEndpoint streamingEndpoint = (StreamingEndpoint)JSON.parse((String)streamingEndpointStr, StreamingEndpoint.class);
        if (StringUtils.isNotBlank((String)streamingEndpoint.projectKey) && !streamingEndpoint.projectKey.equals(projectKey)) {
            throw new IllegalArgumentException("Cannot test endpoint in another project");
        }
        streamingEndpoint.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointService.testKafka_NT(authCtx, streamingEndpoint));
        this.auditTrailService.generic("streamingendpoint-test").with("projectKey", projectKey).with("streamingEndpointId", streamingEndpoint.id).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/streaming-endpoints/test-sqs"})
    public void testSQS(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="streamingEndpoint") String streamingEndpointStr) throws Exception {
        AuthCtx authCtx;
        StreamingEndpoint streamingEndpoint = (StreamingEndpoint)JSON.parse((String)streamingEndpointStr, StreamingEndpoint.class);
        if (StringUtils.isNotBlank((String)streamingEndpoint.projectKey) && !streamingEndpoint.projectKey.equals(projectKey)) {
            throw new IllegalArgumentException("Cannot test endpoint in another project");
        }
        streamingEndpoint.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointService.testSQS_NT(authCtx, streamingEndpoint));
        this.auditTrailService.generic("streamingendpoint-test").with("projectKey", projectKey).with("streamingEndpointId", streamingEndpoint.id).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/streaming-endpoints/test-httpsse"})
    public void testHttpSSE(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="streamingEndpoint") String streamingEndpointStr) throws Exception {
        StreamingEndpoint streamingEndpoint = (StreamingEndpoint)JSON.parse((String)streamingEndpointStr, StreamingEndpoint.class);
        if (StringUtils.isNotBlank((String)streamingEndpoint.projectKey) && !streamingEndpoint.projectKey.equals(projectKey)) {
            throw new IllegalArgumentException("Cannot test endpoint in another project");
        }
        streamingEndpoint.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointService.testHttpSSE_NT(streamingEndpoint));
        this.auditTrailService.generic("streamingendpoint-test").with("projectKey", projectKey).with("streamingEndpointId", streamingEndpoint.id).emit();
    }

    @AuditedCall(value={"msgType", "streamingendpoint-sync-ksql", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/api/streaming-endpoints/sync-ksql"})
    public void syncKsql(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String streamingEndpointId, @RequestParam boolean terminateQueries) throws Exception {
        StreamingEndpoint se;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            se = this.streamingEndpointService.getOrNull(new AnyLoc(projectKey, streamingEndpointId));
            if (se == null) {
                throw new IllegalArgumentException("No streaming endpoint " + streamingEndpointId);
            }
        }
        if (!"kafka".equals(se.type)) {
            throw new IllegalArgumentException("Streaming endpoint " + streamingEndpointId + " is not a kafka endpoint");
        }
        KafkaStreamingEndpointParams params = StreamingEndpointsRegistry.getMeta(se).getExpandedParams(projectKey, se, KafkaStreamingEndpointParams.class);
        se.setParams(params);
        KafkaConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, params.connection, KafkaConnection.class);
        if (StringUtils.isBlank((String)connection.params.ksqlConnectionParams.serverUrl)) {
            throw new IllegalArgumentException("No KSQL url set on connection " + connection.name + " used by streaming endpoint " + streamingEndpointId);
        }
        KsqlSyncResult ret = new KsqlSyncResult();
        try (KsqlRESTClient client = new KsqlRESTClient(connection.getKSqlParameters());){
            boolean doSync;
            boolean doDrop;
            KsqlSynchronizer synchronizer = new KsqlSynchronizer(client);
            if (synchronizer.getTypeIfExists(se) != null) {
                doDrop = true;
                List<String> queries = synchronizer.listQueries(se, false);
                if (!queries.isEmpty()) {
                    if (terminateQueries) {
                        doSync = true;
                    } else {
                        ret.reason = "There are " + queries.size() + " running queries using the streaming endpoint";
                        doSync = false;
                    }
                } else {
                    doSync = true;
                }
            } else {
                doDrop = false;
                doSync = true;
            }
            if (doSync) {
                if (doDrop) {
                    synchronizer.dropTableOrStream(se, false, terminateQueries);
                }
                synchronizer.createTableOrStream(se);
                ret.done = true;
            } else {
                ret.done = false;
            }
        }
        catch (Exception e) {
            ret.failure = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/api/streaming-endpoints/fetch-kafka-schema"})
    public void fetchKafkaSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="streamingEndpoint") String streamingEndpointStr) throws Exception {
        AuthCtx authCtx;
        StreamingEndpoint streamingEndpoint = (StreamingEndpoint)JSON.parse((String)streamingEndpointStr, StreamingEndpoint.class);
        if (StringUtils.isNotBlank((String)streamingEndpoint.projectKey) && !streamingEndpoint.projectKey.equals(projectKey)) {
            throw new IllegalArgumentException("Cannot test endpoint in another project");
        }
        streamingEndpoint.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        StreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointService.fetchKafkaSchema_NT(authCtx, streamingEndpoint));
        this.auditTrailService.generic("streamingendpoint-test").with("projectKey", projectKey).with("streamingEndpointId", streamingEndpoint.id).emit();
    }

    public static class StreamingEndpointListItem
    extends TaggableObjectsService.TaggableListItem {
        public final String type;

        public StreamingEndpointListItem(StreamingEndpoint sr) {
            super(sr);
            this.type = sr.type;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.STREAMING_ENDPOINT;
        }
    }

    public static class KsqlSyncResult {
        public boolean done;
        public String reason;
        public String failure;
    }

    public static class SmartIdDecoder
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.get().has("smartId") && obj.get().has("contextProjectKey")) {
                AnyLoc loc = AnyLoc.resolveSmart(obj.get().get("contextProjectKey").getAsString(), obj.get().get("smartId").getAsString());
                obj.with("projectKey", loc.getProjectKey());
                obj.with("folderId", loc.getId());
            }
        }
    }
}

