/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.theming;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import com.dataiku.dip.theming.service.DSSVisualizationThemeService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api/theming/dss-visualizations"})
public class DSSVisualizationThemeController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private DSSVisualizationThemeService service;
    @Autowired
    private GeneralSettingsService generalSettingsService;

    @ResponseBody
    @AuditedCall(value={"msgType", "dss-visualizations-list"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public DSSVisualizationTheme getChartTheme(HttpServletRequest req, HttpServletResponse resp, @PathVariable String id) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            DSSVisualizationTheme dSSVisualizationTheme = this.service.get(id);
            return dSSVisualizationTheme;
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @AuditedCall(value={"msgType", "dss-visualizations-delete", "id", "${id}"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
            this.service.delete(id);
            t.commit("Deleted visualization theme with id: " + id);
        }
    }

    @ResponseBody
    @AuditedCall(value={"msgType", "dss-visualizations-list"})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<DSSVisualizationTheme> listThemes(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List<DSSVisualizationTheme> list = this.service.list();
            return list;
        }
    }

    @ResponseBody
    @AuditedCall(value={"msgType", "dss-visualizations-create"})
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public DSSVisualizationTheme createNewTheme(HttpServletRequest req, HttpServletResponse resp, @ModelAttribute DSSVisualizationTheme newTheme, @RequestParam(required=false) boolean setAsDefault, @RequestParam(required=false) String lang) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
            this.service.create(newTheme, lang);
            DSSVisualizationTheme newDSSVisualizationTheme = this.service.get(newTheme.getId());
            String commitMsg = "Create new visualization theme: " + newTheme.getId();
            if (setAsDefault) {
                GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
                settings.selectedDSSVisualizationThemeId = newTheme.getId();
                this.generalSettingsService.save(authCtx, settings);
                commitMsg = commitMsg + " and set as default";
            }
            t.commit(commitMsg);
            DSSVisualizationTheme dSSVisualizationTheme = newDSSVisualizationTheme;
            return dSSVisualizationTheme;
        }
    }
}

