/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.python;

import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.server.datasets.renaming.code.RegexCodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import com.dataiku.dip.server.datasets.renaming.code.WhitespaceParser;
import com.dataiku.dip.server.datasets.renaming.code.python.CommentParser;
import com.dataiku.dip.server.datasets.renaming.code.python.DatasetBuildParser;
import com.dataiku.dip.server.datasets.renaming.code.python.DatasetInstantiationParser;
import com.dataiku.dip.server.datasets.renaming.code.python.DocstringParser;
import com.dataiku.dip.server.datasets.renaming.code.python.MultilineCommentParser;
import com.dataiku.dip.server.datasets.renaming.code.python.QuoteParser;
import com.dataiku.dip.server.datasets.renaming.code.python.SingleQuoteParser;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class PythonCodeRenamer
extends RegexCodeRenamer {
    public static final List<String> RECIPE_TYPES = Arrays.asList(PythonRecipeMeta.META.getType(), PySparkRecipeMeta.META.getType());
    private final List<RegexParser> parsers;

    public PythonCodeRenamer(String contextProjectKey, String datasetName) {
        this(contextProjectKey, new DatasetLocUtils.DatasetLoc(contextProjectKey, datasetName));
    }

    public PythonCodeRenamer(String contextProjectKey, DatasetLocUtils.DatasetLoc dataset) {
        this(contextProjectKey, contextProjectKey, dataset, dataset);
    }

    public PythonCodeRenamer(String contextProjectKey, String datasetProjectKey, String oldDataset, String newDataset) {
        this(contextProjectKey, contextProjectKey, new DatasetLocUtils.DatasetLoc(datasetProjectKey, oldDataset), new DatasetLocUtils.DatasetLoc(datasetProjectKey, newDataset));
    }

    public PythonCodeRenamer(String oldContextProjectKey, String newContextProjectKey, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset) {
        this(oldContextProjectKey, newContextProjectKey, oldDataset, newDataset, null, null);
    }

    public PythonCodeRenamer(String oldContextProjectKey, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, String user, Date date) {
        this(oldContextProjectKey, oldContextProjectKey, oldDataset, newDataset, user, date);
    }

    public PythonCodeRenamer(String oldContextProjectKey, String newContextProjectKey, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, String user, Date date) {
        super(oldContextProjectKey, newContextProjectKey, oldDataset, newDataset, user, date);
        String datasetNameRegex = oldContextProjectKey.equals(oldDataset.getProjectKey()) ? String.format("(?:%s\\.)?%s", oldDataset.getProjectKey(), oldDataset.getName()) : oldDataset.getFullName();
        String datasetNameReplacement = String.format("$1\"%s\"$2", newDataset.getSmartName(newContextProjectKey));
        this.parsers = Arrays.asList(new WhitespaceParser(), new CommentParser(), new MultilineCommentParser(), new SingleQuoteParser(), new DocstringParser(), new QuoteParser(), new DatasetInstantiationParser(datasetNameRegex, datasetNameReplacement), new DatasetBuildParser(datasetNameRegex, datasetNameReplacement));
    }

    @Override
    public List<String> getRecipeTypes() {
        return RECIPE_TYPES;
    }

    @Override
    public List<RegexParser> getParsers() {
        return this.parsers;
    }
}

