/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractInviteEmailSendService {
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.access.invited");

    private String buildFailedInvitationEmailErrorMessage(String email) {
        return String.format("Failed to send invitation email to '%s'", email);
    }

    public void sendInviteEmails(InvitationEmailSendResult result, String projectKey, String email, String triggeredByUser, GeneralSettingsDAO.GeneralSettings generalSettings) {
        if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
            result.infoMessages.addMessage(InfoMessage.error((String)this.buildFailedInvitationEmailErrorMessage(email), (String)"Invitations by email are disabled"));
            result.failedEmails.add(email);
            return;
        }
        if (StringUtils.isBlank((String)generalSettings.notifications.emailChannelId)) {
            logger.warn((Object)"Email channel is disabled or not configured, no email was sent");
            result.failedEmails.add(email);
            return;
        }
        try {
            Future<InfoMessage.InfoMessages> ft = this.sendInviteEmail(generalSettings, email, projectKey, triggeredByUser);
            InfoMessage.InfoMessages infoMessages = ft.get();
            if (!infoMessages.anyMessage) {
                result.sentEmails.add(email);
            } else {
                logger.warn((Object)this.buildFailedInvitationEmailErrorMessage(email));
                result.failedEmails.add(email);
                result.infoMessages.messages.addAll(infoMessages.messages);
            }
        }
        catch (Exception e) {
            logger.warn((Object)this.buildFailedInvitationEmailErrorMessage(email), (Throwable)e);
            result.failedEmails.add(email);
            result.infoMessages.addMessage(InfoMessage.error((String)this.buildFailedInvitationEmailErrorMessage(email), (String)e.getMessage()));
        }
    }

    abstract Future<InfoMessage.InfoMessages> sendInviteEmail(GeneralSettingsDAO.GeneralSettings var1, String var2, String var3, @Nullable String var4) throws Exception;

    @UIModel
    public static class InvitationEmailSendResult {
        Set<String> sentEmails = new HashSet<String>();
        Set<String> failedEmails = new HashSet<String>();
        public InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();

        public boolean isEmpty() {
            return this.sentEmails.isEmpty() && this.failedEmails.isEmpty();
        }
    }

    public static enum InvitationEmailStatus {
        PENDING,
        SENT,
        FAILED;

    }
}

