/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DatasetDependency;
import com.dataiku.dip.ProcessorWithDependencies;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.ScriptUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShakerRecipeService {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private DataService dataService;
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    private AchievementsService achievementService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private FlowZonesService flowZonesService;
    public static final String ROLE_SCRIPTDEP = "scriptDeps";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.recipe");

    public static void fixupImpossibleStorageTypes(String outputDatasetType, MemColumn mc) {
        assert (outputDatasetType != null);
        assert (mc.recipeSchemaColumn != null);
        if (DatasetInspector.isSQL(outputDatasetType) && !DatasetInspector.isBigQuery(outputDatasetType)) {
            mc.recipeSchemaColumn.storableAs.put("object", false);
            mc.recipeSchemaColumn.storableAs.put("map", false);
            mc.recipeSchemaColumn.storableAs.put("array", false);
            switch (mc.recipeSchemaColumn.column.getType()) {
                case MAP: 
                case OBJECT: 
                case ARRAY: {
                    mc.recipeSchemaColumn.column.setType(Type.STRING);
                    break;
                }
            }
        }
    }

    public static void fixupImpossibleStorageTypes(String outputDatasetType, SchemaColumn sc) {
        assert (outputDatasetType != null);
        if (DatasetInspector.isSQL(outputDatasetType)) {
            switch (sc.getType()) {
                case MAP: 
                case OBJECT: 
                case ARRAY: {
                    sc.setType(Type.STRING);
                    break;
                }
            }
        }
    }

    public RecipeCreator.CreationResult executeAddToFlow(PreDeployed pd, String zoneId) throws Exception {
        WithMessages<SerializedDataset> datasetWithMessages;
        TransactionContext.assertAttachedRWTransaction();
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        SerializedDataset sds = pd.dataset.serialize();
        if (pd.createOutput) {
            DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(pd.recipe);
            datasetWithMessages = this.saveService.create(pd.dataset.getProjectKey(), sds, dsCtx, TransactionContext.retrieveWrite().getUser());
        } else {
            datasetWithMessages = this.saveService.save(pd.dataset.getProjectKey(), pd.dataset.getName(), sds, TransactionContext.retrieveWrite().getUser());
        }
        ret.messages.mergeFrom(datasetWithMessages.getMessages());
        this.flowZonesService.attachObjectToZone(zoneId, sds.projectKey, sds);
        if (pd.recipeBaseName == null || pd.recipeBaseName.isEmpty()) {
            pd.recipeBaseName = this.recipeSaveService.transmogrifyName(pd.recipeProjectKey, "compute_" + pd.dataset.getName());
        }
        pd.recipe.name = pd.recipeBaseName;
        pd.recipe.projectKey = pd.recipeProjectKey;
        new PDepsFixuper().fixupInPlace(pd.recipe);
        this.flowZonesService.attachObjectToZone(zoneId, pd.recipe.projectKey, pd.recipe);
        this.recipeSaveService.create(pd.recipeProjectKey, pd.recipe, JSON.pretty((Object)pd.ss));
        this.tryUpdateShakerRecipeDependencies(pd.recipeProjectKey, pd.recipeBaseName);
        ret.messages.mergeFrom(pd.messages);
        ret.id = pd.recipeBaseName;
        return ret;
    }

    public PreDeployed prepareAddToFlow_NT(AuthCtx user, Dataset inputDataset, SerializedShakerScript ss, String outputProjectKey, boolean createOutputDataset, String outputDatasetName, ManagedDatasetsCreationService.ManagedDatasetCreationSettings creationSettings, boolean newlyCreatedRecipe) throws Exception {
        PreDeployed ret = new PreDeployed();
        Dataset outputDataset = null;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            if (createOutputDataset) {
                this.connectionsDAO.getMandatoryConnection(user, creationSettings.connectionId);
            } else {
                outputDataset = this.datasetAccessService.getMandatory(outputProjectKey, outputDatasetName);
            }
            if (creationSettings != null && StringUtils.isBlank((String)creationSettings.zone)) {
                Dataset targetZoneDataset = createOutputDataset ? inputDataset : outputDataset;
                creationSettings.zone = this.flowZonesService.retrieveZone(outputProjectKey, targetZoneDataset.serialize());
            }
        }
        if (createOutputDataset) {
            t = this.transactionService.beginRead();
            try {
                outputDataset = this.mdcService.prepare(user, outputProjectKey, outputDatasetName, creationSettings);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        assert (outputDataset != null);
        String outputDatasetType = outputDataset.getType();
        ss = (SerializedShakerScript)JSON.deepCopy((Object)ss);
        for (ScriptStep step : ss.steps) {
            if (step instanceof GroupScriptStep) {
                for (ProcessorScriptStep substep : ((GroupScriptStep)step).steps) {
                    substep.preview = false;
                }
            }
            step.preview = false;
        }
        DataService.ShakerRecipeSchema fakeCurrentOutputSchema = this.createFakeOutputSchema(ss.analysisColumnData, outputDatasetType);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Getting inference with set meanings: " + JSON.json((Object)fakeCurrentOutputSchema)));
        }
        SerializedShakerScript scriptCopy = ss.deepCopy();
        scriptCopy.origin = SerializedShakerScript.ShakerOrigin.PREPARE_RECIPE;
        scriptCopy.recipeSchema = fakeCurrentOutputSchema;
        scriptCopy.contextProjectKey = outputProjectKey;
        MemScriptRunner.TableWithReport twr = this.dataService.get_NOTRANSACTION(inputDataset, scriptCopy, null, null, true, user);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Shaker wants to set schema: " + JSON.json((Object)twr.newRecipeSchema)));
        }
        Dataset fakeDataset = Dataset.fromSerialized((SerializedDataset)JSON.deepCopy((Object)outputDataset.serialize()));
        fakeDataset.setFullName("DOESNOT.matter");
        fakeDataset.setSchema(new Schema(inputDataset.getSchema()));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Schema of the input dataset: " + JSON.json((Object)inputDataset.getSchema())));
        }
        boolean stronglyTypedDataset = DatasetInspector.shouldBeConsideredAsStronglyTypedForPrepareTypeInference(inputDataset);
        RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult = this.getSchemaUpdateResult_NT(user, "outputref", twr.newRecipeSchema, fakeDataset, newlyCreatedRecipe, stronglyTypedDataset, true, inputDataset.getSchema());
        Schema finalSchema = schemaResult.computables.get((int)0).newSchema;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Merge result: " + JSON.json((Object)finalSchema)));
        }
        finalSchema = finalSchema.fixup();
        ret.recipeProjectKey = outputProjectKey;
        outputDataset.setSchema(finalSchema);
        ret.messages.mergeFrom(outputDataset.fixupSchemaPerDatasetConstraint(user, finalSchema));
        ret.dataset = outputDataset;
        ret.createOutput = createOutputDataset;
        SerializedRecipe recipe = new SerializedRecipe();
        recipe.type = "shaker";
        recipe.params = new ShakerRecipeParams();
        recipe.addInput("main", inputDataset.getLoc().getSmartName(outputProjectKey));
        recipe.addOutput("main", outputDatasetName, false);
        try (Transaction t = this.transactionService.beginRead();){
            RecipeCreationUtils.setupShakerRecipeEngineParams(user, outputProjectKey, (ShakerRecipeParams)recipe.params);
        }
        ret.recipe = recipe;
        ret.ss = ss;
        return ret;
    }

    private DataService.ShakerRecipeSchema createFakeOutputSchema(Map<String, SerializedShakerScript.AnalysisColumnData> analysisColumnData, String outputDatasetType) {
        DataService.ShakerRecipeSchema fakeCurrentOutputSchema = new DataService.ShakerRecipeSchema();
        fakeCurrentOutputSchema.outputDatasetType = outputDatasetType;
        for (Map.Entry<String, SerializedShakerScript.AnalysisColumnData> overridenInAnalysis : analysisColumnData.entrySet()) {
            if (overridenInAnalysis.getValue().meaning == null && overridenInAnalysis.getValue().comment == null && overridenInAnalysis.getValue().customFields == null) continue;
            DataService.ShakerRecipeSchemaColumn fakeCol = new DataService.ShakerRecipeSchemaColumn();
            fakeCol.persistent = false;
            fakeCol.column = new SchemaColumn(overridenInAnalysis.getKey(), Type.STRING);
            if (overridenInAnalysis.getValue().meaning != null) {
                fakeCol.column.setMeaning(overridenInAnalysis.getValue().meaning);
            }
            if (overridenInAnalysis.getValue().comment != null) {
                fakeCol.column.comment = overridenInAnalysis.getValue().comment;
            }
            if (overridenInAnalysis.getValue().customFields != null) {
                fakeCol.column.customFields = (JsonObject)JSON.deepCopy((Object)overridenInAnalysis.getValue().customFields);
            }
            fakeCol.column.isColumnEdited = overridenInAnalysis.getValue().isColumnEdited;
            fakeCurrentOutputSchema.columns.put(overridenInAnalysis.getKey(), fakeCol);
        }
        return fakeCurrentOutputSchema;
    }

    public RecipeCreator.CreationResult deployFromAnalysis_NT(AuthCtx user, String projectKey, Dataset inputDataset, AnalysisCoreParams acp, boolean createOutput, String outputDatasetName, ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputCreationSettings, boolean exportCharts) throws Exception {
        PreDeployed pd = this.prepareAddToFlow_NT(user, inputDataset, acp.script, projectKey, createOutput, outputDatasetName, outputCreationSettings, false);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(user);){
            if (exportCharts) {
                DatasetExploreSettings exploreSettings = this.exploresService.get(projectKey, outputDatasetName);
                for (AnalysisCoreParams.AnalysisChart fromChart : acp.charts) {
                    DatasetExploreSettings.DatasetChart toChart = new DatasetExploreSettings.DatasetChart();
                    toChart.def = fromChart.def;
                    toChart.refreshableSelection = fromChart.refreshableSelection;
                    toChart.copySelectionFromScript = fromChart.copySelectionFromScript;
                    exploreSettings.charts.add(toChart);
                }
                this.exploresService.save(projectKey, outputDatasetName, exploreSettings);
            }
            RecipeCreator.CreationResult creationResult = this.executeAddToFlow(pd, outputCreationSettings.zone);
            this.achievementService.win(t.getUser(), AchievementsService.AchievementId.LETS_GET_COOKING);
            t.commit("Created recipe " + projectKey + "." + creationResult.id + " from analysis");
            RecipeCreator.CreationResult creationResult2 = creationResult;
            return creationResult2;
        }
    }

    public static List<StepDependency> determineAdditionalDependencies(List<ScriptStep> steps) throws Exception {
        ArrayList<StepDependency> allDeps = new ArrayList<StepDependency>();
        for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(steps)) {
            if (step.disabled) continue;
            Processor p = BaseProcessorsFactory.build(step, BaseProcessorsFactory.PipelineContext.fakePipelineContext());
            List<DatasetDependency> stepDeps = null;
            if (p instanceof ProcessorWithDependencies) {
                stepDeps = ((ProcessorWithDependencies)p).listDependencies();
            }
            if (stepDeps == null) continue;
            for (DatasetDependency dep : stepDeps) {
                StepDependency sd = new StepDependency();
                sd.dependency = dep;
                sd.step = step;
                allDeps.add(sd);
            }
        }
        return allDeps;
    }

    public static List<DatasetDependency> mergeDatasetDependencies(List<DatasetDependency> deps) {
        ArrayList<DatasetDependency> deduplicatedDeps = new ArrayList<DatasetDependency>();
        for (DatasetDependency newDsDep : deps) {
            boolean found = false;
            for (DatasetDependency dsDep : deduplicatedDeps) {
                if (!StringUtils.equals((String)dsDep.datasetSM, (String)newDsDep.datasetSM)) continue;
                found = true;
                if (dsDep.columnNames == null || newDsDep.columnNames == null) {
                    dsDep.columnNames = null;
                    break;
                }
                HashSet<String> mergedCols = new HashSet<String>();
                mergedCols.addAll(dsDep.columnNames);
                mergedCols.addAll(newDsDep.columnNames);
                dsDep.columnNames = new ArrayList<String>(mergedCols);
            }
            if (found) continue;
            deduplicatedDeps.add(newDsDep);
        }
        return deduplicatedDeps;
    }

    public SerializedRecipe tryUpdateShakerRecipeDependencies(String projectKey, String recipeName) throws Exception {
        SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
        String recipeData = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
        ErrorContext.checkNotNull((Object)recipeData, (String)("Recipe data for " + recipeName + " doesn't exist"));
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)recipeData, SerializedShakerScript.class);
        ErrorContext.checkNotNull((Object)ss, (String)("Shaker script for recipe " + recipeName + " doesn't exist"));
        this.updateDependenciesOnAnyRecipe(projectKey, sr, ss);
        return this.recipeSaveService.saveNoVersionNorNotifications(projectKey, sr, JSON.pretty((Object)ss));
    }

    public RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaUpdateResult_NT(AuthCtx authCtx, String outRef, DataService.ShakerRecipeSchema recipeOutSchema, Dataset dataset, boolean newlyCreatedRecipe, boolean stronglyTypedDataset, Schema inputDatasetSchema) throws Exception {
        return this.getSchemaUpdateResult_NT(authCtx, outRef, recipeOutSchema, dataset, newlyCreatedRecipe, stronglyTypedDataset, false, inputDatasetSchema);
    }

    public RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaUpdateResult_NT(AuthCtx authCtx, String outRef, DataService.ShakerRecipeSchema recipeOutSchema, Dataset dataset, boolean newlyCreatedRecipe, boolean stronglyTypedDataset, boolean datasetIsFake, Schema inputDatasetSchema) throws Exception {
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        RecipeSchemaService.ComputableSchemaAutoupdateResult dsRet = RecipeSchemaService.ComputableSchemaAutoupdateResult.forDataset();
        dsRet.datasetName = outRef;
        Schema schemaBefore = dataset.getSchema();
        dsRet.newSchema.userModified = schemaBefore.userModified;
        GeneralSettingsDAO.GlobalDefaultRecipeCreationSettings.PrepareRecipeColumnTypeMode columnTypeMode = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().defaultRecipeCreationSettings.prepareRecipeColumnTypeMode;
        for (String name : recipeOutSchema.columnsOrder) {
            SchemaColumn newCol;
            SchemaColumn colInPrevSchema = schemaBefore.getColumn(name);
            SchemaColumn inputDatasetColumn = inputDatasetSchema != null ? inputDatasetSchema.getColumn(name) : null;
            DataService.ShakerRecipeSchemaColumn colInRecipe = recipeOutSchema.columns.get(name);
            assert (colInRecipe != null);
            if (colInRecipe.deleted) continue;
            if (inputDatasetColumn != null && !StringUtils.isEmpty((String)inputDatasetColumn.comment) && !colInRecipe.column.isColumnEdited) {
                colInRecipe.column.comment = inputDatasetColumn.comment;
            }
            if (colInPrevSchema == null) {
                logger.trace(() -> String.format("New column: %s", name));
                newCol = new SchemaColumn();
                newCol.setName(name);
                newCol.setType(colInRecipe.column.getType());
            } else {
                logger.trace(() -> String.format("Update column: %s with %s", JSON.json((Object)colInPrevSchema), JSON.json((Object)colInRecipe)));
                newCol = (SchemaColumn)JSON.deepCopy((Object)colInPrevSchema);
                if (newlyCreatedRecipe && newCol.isColumnEdited) {
                    newCol.isColumnEdited = false;
                }
                if (this.shouldOverrideColumnType(colInPrevSchema, colInRecipe, newlyCreatedRecipe, stronglyTypedDataset, columnTypeMode)) {
                    newCol.setType(colInRecipe.column.getType());
                }
            }
            newCol.updateColumnContentIfNotNull(colInRecipe.column);
            if (logger.isTraceEnabled()) {
                logger.traceV("New Col is " + JSON.json((Object)newCol), new Object[0]);
            }
            dsRet.newSchema.columns.add(newCol);
        }
        for (SchemaColumn oldCol : schemaBefore.columns) {
            if (recipeOutSchema.columns.get(oldCol.getName()) != null || oldCol.getType().isPrimitive()) continue;
            logger.infoV("Complex Column %s has disappeared, will specifically warn", new Object[]{oldCol.getName()});
            dsRet.lostComplexTypes.add(oldCol.getName());
        }
        this.recipeSchemaService.fillDatasetSchemaUpdateResultStep2(authCtx, dsRet, dataset, schemaBefore, datasetIsFake);
        ret.computables.add(dsRet);
        ret.totalIncompatibilities += dsRet.incompatibilities.size();
        return ret;
    }

    private boolean shouldOverrideColumnType(SchemaColumn colInPrevSchema, DataService.ShakerRecipeSchemaColumn colInRecipe, boolean newlyCreatedRecipe, boolean stronglyTypedDataset, GeneralSettingsDAO.GlobalDefaultRecipeCreationSettings.PrepareRecipeColumnTypeMode columnTypeMode) {
        if (colInPrevSchema.getType() == Type.OBJECT && colInRecipe.column.getType() == Type.MAP && !colInRecipe.persistent) {
            logger.infoV("NOT overriding object by map in column: %s", new Object[]{colInPrevSchema.getName()});
            return false;
        }
        if (!newlyCreatedRecipe) {
            return true;
        }
        switch (columnTypeMode) {
            case ALWAYS_INFER: {
                return true;
            }
            case ALWAYS_USE_INPUT_TYPES: {
                return false;
            }
            case KEEP_STRONGLY_TYPED_INPUTS: {
                return !stronglyTypedDataset;
            }
        }
        throw new IllegalArgumentException("unhandled column type mode: " + String.valueOf((Object)columnTypeMode));
    }

    public void updateDependenciesOnAnyRecipe(String projectKey, SerializedRecipe sr, SerializedShakerScript sss) throws Exception {
        this.updateDependenciesOnAnyRecipe(projectKey, sr, sss, "main");
    }

    public void updateDependenciesOnAnyRecipe(String projectKey, SerializedRecipe sr, SerializedShakerScript sss, String ... outputRoles) throws Exception {
        List<StepDependency> additionalDeps = ShakerRecipeService.determineAdditionalDependencies(sss.steps);
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.buildSingleRecipe(sr);
        assert (flowGraph.recipes.size() == 1);
        FlowRecipe flowRecipe = flowGraph.recipes.get(0);
        RecipeRunnableSubgraph subgraph = new RecipeRunnableSubgraph(flowRecipe);
        String mainInputRef = sr.getSingleInput((String)"main").ref;
        AnyLoc mainInputLoc = AnyLoc.resolveSmart(sr.projectKey, mainInputRef);
        FlowDataset mainInputDataset = subgraph.getSourceDataset(mainInputLoc.getFullName());
        if (subgraph.getTargets().size() == 0) {
            throw ErrorContext.iae((String)"Recipe has 0 outputs, unexpected !");
        }
        PartitioningScheme targetPartitioning = null;
        String targetSM = null;
        block8: for (String outputRole : outputRoles) {
            List<SerializedRecipe.RecipeOutput> outputs = sr.getOutputsForRole(outputRole);
            if (outputs.size() == 0) continue;
            SerializedRecipe.RecipeOutput recipeOutput = outputs.get(0);
            targetSM = recipeOutput.ref;
            FlowComputable target = subgraph.getTargets().get(0);
            switch (target.getType()) {
                case DATASET: {
                    targetPartitioning = ((FlowDataset)target).getMandatory(this.datasetsDAO).getPartitioningSchema();
                    continue block8;
                }
                case SAVED_MODEL: {
                    targetPartitioning = new PartitioningScheme();
                    continue block8;
                }
                case MANAGED_FOLDER: {
                    targetPartitioning = new PartitioningScheme();
                    continue block8;
                }
                case MODEL_EVALUATION_STORE: {
                    targetPartitioning = new PartitioningScheme();
                    continue block8;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    targetPartitioning = new PartitioningScheme();
                    continue block8;
                }
                case STREAMING_ENDPOINT: {
                    throw new IllegalStateException("Cannot use streaming endpoints on any recipe");
                }
            }
        }
        if (targetPartitioning == null) {
            throw new IllegalStateException("No output found to define a partitioning scheme");
        }
        List<SerializedRecipe.RecipeInput> previousDepsInputs = sr.getInputsForRole(ROLE_SCRIPTDEP);
        sr.clearInputsForRole(ROLE_SCRIPTDEP);
        sr.clearInputsForRole("reference");
        HashSet<String> alreadyProcessedDeps = new HashSet<String>();
        for (StepDependency dep : additionalDeps) {
            if (alreadyProcessedDeps.contains(dep.dependency.datasetSM)) continue;
            alreadyProcessedDeps.add(dep.dependency.datasetSM);
            Dataset ds = this.datasetAccessService.getOrNull(DatasetLocUtils.resolveSmart(projectKey, dep.dependency.datasetSM));
            if (ds == null) {
                throw ErrorContext.iae((String)("Recipe depends on the non-existing dataset \"" + dep.dependency.datasetSM + "\" (implied by " + dep.step.type + ")"));
            }
            if (StringUtils.equals((String)mainInputLoc.getSmartName(sr.projectKey), (String)dep.dependency.datasetSM)) {
                throw ErrorContext.iae((String)("A recipe cannot uses its main input as an additional dependency (implied by " + dep.step.type + ")"));
            }
            List<SerializedRecipe.SDep> foundDeps = null;
            for (SerializedRecipe.RecipeInput previousDepInput : previousDepsInputs) {
                if (!previousDepInput.ref.equals(dep.dependency.datasetSM)) continue;
                foundDeps = previousDepInput.deps;
                break;
            }
            SerializedRecipe.RecipeInput newInput = sr.addInput(dep.dependency.role, dep.dependency.datasetSM);
            if (foundDeps != null) {
                newInput.deps = foundDeps;
                continue;
            }
            if (!ds.getPartitioningSchema().isPartitioned()) continue;
            PartitioningScheme partitionSchema = ds.getPartitioningSchema();
            for (String dimension : partitionSchema.getDimensionNames()) {
                if (targetPartitioning.getDimensionNames().contains(dimension)) {
                    newInput.deps.add(new SerializedRecipe.SDep(targetSM, dimension, dimension, "equals"));
                    continue;
                }
                newInput.deps.add(new SerializedRecipe.SDep(targetSM, dimension, null, "all_available"));
            }
        }
    }

    public Schema getInputDatasetSchema(SerializedRecipe serializedRecipe) throws IOException {
        if (serializedRecipe == null) {
            return null;
        }
        SerializedRecipe.RecipeInput singleInput = serializedRecipe.getSingleInput("main");
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(serializedRecipe.projectKey, singleInput.ref);
        Dataset inputDataset = this.datasetAccessService.getMandatory(loc);
        return inputDataset.getSchema();
    }

    public static class PreDeployed {
        String recipeProjectKey;
        public Dataset dataset;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        boolean createOutput;
        public SerializedRecipe recipe;
        String recipeBaseName;
        String zone;
        SerializedShakerScript ss;
    }

    public static class StepDependency {
        public DatasetDependency dependency;
        public ProcessorScriptStep step;
    }
}

