/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.samples;

import com.google.common.collect.Lists;
import java.util.List;

public enum SnippetType {
    PYTHON("python", "py"),
    JULIA("julia", "julia"),
    R("R", "R"),
    SCALA("scala", "scala"),
    HIVE("hive", "sql"),
    KSQL("ksql", "sql"),
    SQL("sql", "sql"),
    PIG("pig", "pig"),
    IMPALA("impala", "sql"),
    SHELL("shell", "sh"),
    WEBAPP_STANDARD("webapp_standard", null),
    WEBAPP_BOKEH("webapp_bokeh", null),
    WEBAPP_DASH("webapp_dash", null),
    WEBAPP_SHINY("webapp_shiny", null),
    RMARKDOWN("rmarkdown", "Rmd");

    private String name;
    private String extension;

    private SnippetType(String name, String extension) {
        this.name = name;
        this.extension = extension;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public List<String> getAllReadFolders() {
        return Lists.newArrayList((Object[])new String[]{this.name});
    }

    public static SnippetType getSnippetTypeByName(String name) {
        for (SnippetType snippetType : SnippetType.values()) {
            if (!snippetType.getName().equals(name)) continue;
            return snippetType;
        }
        throw new IllegalArgumentException("Invalid snippet type " + name);
    }
}

