/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UIType;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessibleObjectsService {
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    private ReportsDAO reportsDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ModelComparisonsCRUDService modelComparisonsCRUDService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private DataCollectionsService dataCollectionsService;
    @Autowired
    private AppsService appsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.services.accessibleObjects");

    public Map<ITaggingService.TaggableType, Integer> countAccessibleObjects(String projectKey) throws IOException {
        EnumMap<ITaggingService.TaggableType, Integer> counts = new EnumMap<ITaggingService.TaggableType, Integer>(ITaggingService.TaggableType.class);
        block26: for (ITaggingService.TaggableType type : ITaggingService.TaggableType.values()) {
            if (type.isFakeType()) continue;
            switch (type) {
                case DATASET: {
                    counts.put(type, this.datasetsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case RECIPE: {
                    counts.put(type, this.recipesDAO.approximateCount(projectKey));
                    continue block26;
                }
                case LABELING_TASK: {
                    counts.put(type, this.labelingTasksDAO.approximateCount(projectKey));
                    continue block26;
                }
                case SAVED_MODEL: {
                    counts.put(type, this.savedModelsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case MODEL_EVALUATION_STORE: {
                    counts.put(type, this.modelEvaluationStoresDAO.approximateCount(projectKey));
                    continue block26;
                }
                case MANAGED_FOLDER: {
                    counts.put(type, this.managedFolderDAO.approximateCount(projectKey));
                    continue block26;
                }
                case STREAMING_ENDPOINT: {
                    counts.put(type, this.streamingEndpointsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case WEB_APP: {
                    counts.put(type, this.webAppsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case CODE_STUDIO: {
                    counts.put(type, this.codeStudioObjectsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case REPORT: {
                    counts.put(type, this.reportsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case JUPYTER_NOTEBOOK: {
                    counts.put(type, this.jupyterService.approximateCount(projectKey));
                    continue block26;
                }
                case SCENARIO: {
                    counts.put(type, this.scenariosDAO.approximateCount(projectKey));
                    continue block26;
                }
                case DASHBOARD: {
                    counts.put(type, this.dashboardsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case INSIGHT: {
                    counts.put(type, this.insightsDAO.approximateCount(projectKey));
                    continue block26;
                }
                case SQL_NOTEBOOK: {
                    counts.put(type, this.sqlNotebooksDAO.approximateCount(projectKey));
                    continue block26;
                }
                case SEARCH_NOTEBOOK: {
                    counts.put(type, this.searchNotebooksDAO.approximateCount(projectKey));
                    continue block26;
                }
                case ANALYSIS: {
                    counts.put(type, this.analysisCRUDService.approximateCount(projectKey));
                    continue block26;
                }
                case STATISTICS_WORKSHEET: {
                    counts.put(type, this.worksheetsService.approximateCount(projectKey));
                    continue block26;
                }
                case MODEL_COMPARISON: {
                    counts.put(type, this.modelComparisonsCRUDService.approximateCount(projectKey));
                    continue block26;
                }
                case ARTICLE: {
                    counts.put(type, this.articlesDAO.approximateCount(projectKey));
                    continue block26;
                }
                case LAMBDA_SERVICE: {
                    counts.put(type, this.lambdaServicesDAO.approximateCount(projectKey));
                    continue block26;
                }
                case FLOW_ZONE: {
                    counts.put(type, this.zonesDAO.approximateCount(projectKey));
                    continue block26;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    counts.put(type, this.retrievableKnowledgeDAO.approximateCount(projectKey));
                    continue block26;
                }
                case DATA_COLLECTION: {
                    continue block26;
                }
            }
        }
        return counts;
    }

    public AccessibleObjectsCount countAccessibleObjectsWithTotal(String projectKey) throws IOException {
        return AccessibleObjectsCount.fromCounts(this.countAccessibleObjects(projectKey));
    }

    public List<AccessibleObject> listAccessibleExposedObjectsUnsafe(AuthCtx user, @Nullable String projectKey, @Nullable ITaggingService.TaggableType type, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>();
        SerializedProject contextProject = this.projectsService.getMandatoryUnsafe(projectKey);
        for (SerializedProject project : this.projectsService.listAllUnsafe()) {
            if (project.projectKey.equals(projectKey)) continue;
            for (ExposedObject exposedObject : project.exposedObjects.objects) {
                SmartObjectRef ref;
                if (type != null && exposedObject.type != type || !exposedObject.canAccess(projectKey) || !this.projectsService.hasObjectLocalPermission(user, ref = new SmartObjectRef(project.projectKey, exposedObject.type, exposedObject.localName), contextProject, mode)) continue;
                TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getOrNullUnsafe(project.projectKey, exposedObject.type, exposedObject.localName);
                if (to == null) {
                    logger.info((Object)(String.valueOf((Object)exposedObject.type) + " does not exist: " + exposedObject.localName + " (" + project.projectKey + ")"));
                    continue;
                }
                ret.add(AccessibleObject.fromTaggableObject(to, false, contextProject.dashboardAuthorizations.hasObjectAuthorization(ref, mode)));
            }
        }
        return ret;
    }

    public List<AccessibleObject> listAccessibleLocalObjectsUnsafe(AuthCtx user, String projectKey, @Nullable ITaggingService.TaggableType type, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>();
        SerializedProject contextProject = this.projectsService.getMandatoryUnsafe(projectKey);
        for (TaggableObjectsService.TaggableObject taggableObject : this.taggableObjectsReadService.listUnsafe(projectKey, type)) {
            SmartObjectRef ref = new SmartObjectRef(taggableObject.getTaggableType(), taggableObject.getId());
            if (!this.projectsService.hasObjectLocalPermission(user, ref, contextProject, mode)) continue;
            ret.add(AccessibleObject.fromTaggableObject(taggableObject, true, contextProject.dashboardAuthorizations.hasObjectAuthorization(ref, mode)));
        }
        return ret;
    }

    public List<AccessibleObject> listAccessibleWorkspacesUnsafe(AuthCtx authCtx) throws IOException {
        ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>();
        for (Workspace workspace : this.workspacesService.listAccessibleWorkspacesUnsafe(authCtx)) {
            ret.add(AccessibleObject.fromTaggableObject(workspace, true, false));
        }
        return ret;
    }

    public List<AccessibleObject> listAccessibleProjectsUnsafe(AuthCtx authCtx) throws Exception {
        ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>();
        for (ProjectsService.UIProject project : this.projectsService.listAccessibleUnsafe(authCtx)) {
            ret.add(AccessibleObject.fromProject(project));
        }
        return ret;
    }

    public List<AccessibleObject> listAppTemplatesUnsafe(AuthCtx authCtx) throws Exception {
        ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>();
        for (AppsService.AppListItem project : this.appsService.listAppTemplates_T((AuthCtx)authCtx, (boolean)false, (boolean)false).items) {
            ret.add(AccessibleObject.fromAppTemplate(project));
        }
        return ret;
    }

    public List<AccessibleObject> listAccessibleDataCollectionsUnsafe(AuthCtx authCtx) throws Exception {
        ArrayList<AccessibleObject> ret = new ArrayList<AccessibleObject>();
        for (DataCollection dataCollection : this.dataCollectionsService.listAccessibleUnsafe(authCtx, Privileges.DataCollectionLevelPrivilegeType.READ)) {
            ret.add(AccessibleObject.fromTaggableObject(dataCollection, true, false));
        }
        return ret;
    }

    public List<AccessibleObject> listAccessibleObjectsUnsafe(AuthCtx user, @Nullable String projectKey, @Nullable ITaggingService.TaggableType type, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        List<AccessibleObject> ret = this.listAccessibleLocalObjectsUnsafe(user, projectKey, type, mode);
        ret.addAll(this.listAccessibleExposedObjectsUnsafe(user, projectKey, type, mode));
        return ret;
    }

    public void addKernelSpecInfo_NT(AuthCtx authCtx, List<AccessibleObject> objects) {
        ArrayList notebooks = Lists.newArrayList();
        for (AccessibleObject object : objects) {
            if (!(object.object instanceof JupyterUtils.JupyterNotebookListEntry)) continue;
            notebooks.add((JupyterUtils.JupyterNotebookListEntry)object.object);
        }
        this.jupyterService.addKernelSpecInfo(authCtx, notebooks);
    }

    @UIModel
    public static class AccessibleObjectsCount {
        private Map<ITaggingService.TaggableType, Integer> counts;
        private int totalCount;
        private int totalFlowCount;
        private boolean isBigFlow;
        public static final int BIG_FLOW_THRESHOLD = 200;

        public static AccessibleObjectsCount fromCounts(Map<ITaggingService.TaggableType, Integer> counts) {
            AccessibleObjectsCount accessibleObjectsCount = new AccessibleObjectsCount();
            accessibleObjectsCount.setCounts(counts);
            accessibleObjectsCount.setTotalCount(counts.values().stream().reduce(0, Integer::sum));
            List<ITaggingService.TaggableType> flowTaggableTypes = Arrays.asList(ITaggingService.TaggableType.DATASET, ITaggingService.TaggableType.FLOW_ZONE, ITaggingService.TaggableType.LABELING_TASK, ITaggingService.TaggableType.MANAGED_FOLDER, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, ITaggingService.TaggableType.RECIPE, ITaggingService.TaggableType.SAVED_MODEL, ITaggingService.TaggableType.STREAMING_ENDPOINT);
            flowTaggableTypes.forEach(taggableType -> accessibleObjectsCount.totalFlowCount += ((Integer)counts.get(taggableType)).intValue());
            accessibleObjectsCount.setIsBigFlow(accessibleObjectsCount.getTotalFlowCount() >= 200);
            return accessibleObjectsCount;
        }

        public Map<ITaggingService.TaggableType, Integer> getCounts() {
            return this.counts;
        }

        public void setCounts(Map<ITaggingService.TaggableType, Integer> counts) {
            this.counts = counts;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getTotalFlowCount() {
            return this.totalFlowCount;
        }

        public void setTotalFlowCount(int totalFlowCount) {
            this.totalFlowCount = totalFlowCount;
        }

        public boolean getIsBigFlow() {
            return this.isBigFlow;
        }

        public void setIsBigFlow(boolean isBigFlow) {
            this.isBigFlow = isBigFlow;
        }
    }

    @UIModel
    public static class AccessibleObject {
        @UIType(value="`${ITaggingService.TaggableType}` | 'APP'")
        public String type;
        public String subtype;
        public String projectKey;
        public String id;
        public String smartId;
        public String label;
        public boolean localProject;
        public boolean isReaderAccessible;
        public Object object;

        public static AccessibleObject fromTaggableObject(TaggableObjectsService.TaggableObject taggableObject, boolean isLocal, boolean isReaderAccessible) {
            AccessibleObject ret = new AccessibleObject();
            ret.type = taggableObject.getTaggableType().toString();
            ret.projectKey = taggableObject.getProjectKey();
            ret.id = taggableObject.getId();
            ret.localProject = isLocal;
            ret.smartId = isLocal ? taggableObject.getId() : taggableObject.getProjectKey() + "." + taggableObject.getId();
            ret.label = taggableObject.getDisplayName();
            ret.object = taggableObject;
            ret.isReaderAccessible = isReaderAccessible;
            ret.subtype = taggableObject.getSubtype();
            return ret;
        }

        public static AccessibleObject fromProject(TaggableObjectsService.TaggableObject project) {
            AccessibleObject ret = AccessibleObject.fromTaggableObject(project, true, false);
            ret.label = project.getDisplayName() + " (" + project.getProjectKey() + ")";
            return ret;
        }

        public static AccessibleObject fromAppTemplate(AppsService.AppListItem appListItem) {
            AccessibleObject ret = new AccessibleObject();
            ret.type = "APP";
            ret.id = appListItem.appId;
            ret.localProject = true;
            ret.smartId = appListItem.appId;
            ret.label = appListItem.label;
            ret.object = appListItem;
            ret.isReaderAccessible = false;
            return ret;
        }
    }
}

