/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.WatchTriggeredEvent;
import com.dataiku.dip.server.notifications.frontend.UIConnectionStateChangedEvent;
import com.dataiku.dip.server.notifications.frontend.UIIdleStateChangedEvent;
import com.dataiku.dip.server.notifications.frontend.UIStateChangedEvent;
import com.dataiku.dip.server.notifications.frontend.WatchListChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TrackingSessionUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserActivityService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrackingService {
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private UserActivityService activityService;
    private Cache<String, TrackingSession> sessions = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).expireAfterAccess(1L, TimeUnit.DAYS).concurrencyLevel(1).build();
    protected static DKULogger logger = DKULogger.getLogger(TrackingService.class);

    private boolean userHasAnyNonIdleSession(String login) {
        for (TrackingSession ts : this.sessions.asMap().values()) {
            if (!login.equals(ts.user.login) || ts.isIdle()) continue;
            return true;
        }
        return false;
    }

    private TrackingSession getMostRecentNonIdleSession(String login) {
        ArrayList<TrackingSession> valids = new ArrayList<TrackingSession>();
        for (TrackingSession ts : this.sessions.asMap().values()) {
            if (!login.equals(ts.user.login) || ts.isIdle()) continue;
            valids.add(ts);
        }
        if (valids.size() == 0) {
            return null;
        }
        Collections.sort(valids, new Comparator<TrackingSession>(){

            @Override
            public int compare(TrackingSession o1, TrackingSession o2) {
                return -Long.compare(o1.lastRefreshed, o2.lastRefreshed);
            }
        });
        return (TrackingSession)valids.get(0);
    }

    private void updateUserTimers(String login) {
        if (this.userHasAnyNonIdleSession(login)) {
            TrackingSession mostRecentNonIdle = this.getMostRecentNonIdleSession(login);
            assert (mostRecentNonIdle != null);
            String projectKey = mostRecentNonIdle.getStateParamAsString("projectKey");
            if (projectKey != null) {
                this.activityService.startUserTimer(login, projectKey);
            } else {
                this.activityService.startUserGlobalTimer(login);
            }
        } else {
            this.activityService.stopUserTimers(login);
        }
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init tracking service");
        this.pubSub.subscribe("ui-state-changed", (DSSEventListener)new DSSEventListener<UIStateChangedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(UIStateChangedEvent evt) {
                try (Transaction t = TrackingService.this.transactionService.beginRead();){
                    TrackingService trackingService = TrackingService.this;
                    synchronized (trackingService) {
                        TrackingSession session = TrackingService.this.getSession(evt.getUserLogin(), evt.getWebSocketSessionId());
                        if (!Objects.equals(session.getState(), evt.getStateName()) || !Objects.equals(session.getStateParams(), evt.getStateParams())) {
                            String prevState = session.getState();
                            Map<String, Object> prevParams = session.getStateParams();
                            session.setState(evt.getStateName(), evt.getStateParams());
                            if (prevState != null) {
                                TrackingService.this.triggerWatches(prevState, prevParams);
                            }
                            TrackingService.this.triggerWatches(session.getState(), session.getStateParams());
                            TrackingService.this.updateUserTimers(evt.getUserLogin());
                        }
                    }
                }
            }
        });
        this.pubSub.subscribe("ui-idle-state-changed", (DSSEventListener)new DSSEventListener<UIIdleStateChangedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(UIIdleStateChangedEvent evt) {
                try (Transaction t = TrackingService.this.transactionService.beginRead();){
                    TrackingService trackingService = TrackingService.this;
                    synchronized (trackingService) {
                        TrackingSession session = TrackingService.this.getSession(evt.getUserLogin(), evt.getWebSocketSessionId());
                        session.setIdle(evt.isIdle());
                        if (session.getState() != null) {
                            TrackingService.this.triggerWatches(session.getState(), session.getStateParams());
                        }
                        TrackingService.this.updateUserTimers(evt.getUserLogin());
                    }
                }
            }
        });
        this.pubSub.subscribe("ui-connection-state-changed", (DSSEventListener)new DSSEventListener<UIConnectionStateChangedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(UIConnectionStateChangedEvent evt) {
                TrackingService trackingService = TrackingService.this;
                synchronized (trackingService) {
                    if (!evt.isConnected()) {
                        TrackingSession session = (TrackingSession)TrackingService.this.sessions.getIfPresent((Object)evt.getWebSocketSessionId());
                        TrackingService.this.sessions.invalidate((Object)evt.getWebSocketSessionId());
                        if (session != null && session.getState() != null) {
                            TrackingService.this.triggerWatches(session.getState(), session.getStateParams());
                        }
                    }
                    TrackingService.this.updateUserTimers(evt.getUserLogin());
                }
            }
        });
        this.pubSub.subscribe("watch-list-changed", (DSSEventListener)new DSSEventListener<WatchListChangedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(WatchListChangedEvent evt) {
                try (Transaction t = TrackingService.this.transactionService.beginRead();){
                    TrackingService trackingService = TrackingService.this;
                    synchronized (trackingService) {
                        TrackingSession session = TrackingService.this.getSession(evt.getUserLogin(), evt.getWebSocketSessionId());
                        session.setWatches(evt.getWatches());
                        TrackingService.this.recomputeWatches(session);
                    }
                }
            }
        });
        DSSMetrics.registry().register("dku.collaboration.trackingSessions", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return TrackingService.this.sessions.size();
            }
        });
        DSSMetrics.registry().register("dku.collaboration.activeUsers", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                HashSet<String> users = new HashSet<String>();
                for (TrackingSession ts : TrackingService.this.listSessions()) {
                    if (ts.isIdle()) continue;
                    if (ts.getUser() == null) {
                        users.add("null");
                        continue;
                    }
                    users.add(ts.getUser().login);
                }
                return users.size();
            }
        });
        DSSMetrics.registry().register("dku.collaboration.activeTrackingSessions", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                int count = 0;
                for (TrackingSession ts : TrackingService.this.listSessions()) {
                    if (ts.isIdle()) continue;
                    ++count;
                }
                return count;
            }
        });
        logger.debug((Object)"Done init tracker service");
    }

    public synchronized TrackingSession getSession(String userLogin, String sessionId) {
        TrackingSession session = (TrackingSession)this.sessions.getIfPresent((Object)sessionId);
        if (session == null) {
            PublicUser user;
            try {
                user = this.usersService.getPublicUser(userLogin);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error:" + e.getMessage(), e);
            }
            session = new TrackingSession(user, sessionId);
            this.sessions.put((Object)sessionId, (Object)session);
        }
        return session;
    }

    public ArrayList<TrackingSession> listSessions() {
        return new ArrayList<TrackingSession>(this.sessions.asMap().values());
    }

    public Set<PublicUser> getUsersOnProject(String projectKey) {
        HashSet<PublicUser> users = new HashSet<PublicUser>();
        for (TrackingSession session : this.listSessions()) {
            if (!TrackingSessionUtils.isOnProject(session, projectKey)) continue;
            users.add(session.getUser());
        }
        return users;
    }

    public Set<PublicUser> getUsersOnObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        HashSet<PublicUser> users = new HashSet<PublicUser>();
        for (TrackingSession session : this.listSessions()) {
            if (!TrackingSessionUtils.isOnObjectPage(session, objectType, projectKey, objectId)) continue;
            users.add(session.getUser());
        }
        return users;
    }

    public Set<PublicUser> getConnectedUsers() {
        HashSet<PublicUser> users = new HashSet<PublicUser>();
        for (TrackingSession session : this.listSessions()) {
            users.add(session.getUser());
        }
        return users;
    }

    private synchronized void triggerWatches(String stateName, Map<String, Object> stateParams) {
        ArrayList<TrackingSession> sessionList = this.listSessions();
        for (TrackingSession session : sessionList) {
            boolean recompute = false;
            block1: for (WatchListChangedEvent.Watch watch : session.getWatches()) {
                if (!stateName.startsWith(watch.getStatePrefix())) continue;
                for (Map.Entry<String, String> entry : watch.getStateParams().entrySet()) {
                    if (Objects.equals(entry.getValue(), stateParams.get(entry.getKey()))) continue;
                    continue block1;
                }
                recompute = true;
                break;
            }
            if (!recompute) continue;
            this.recomputeWatches(session);
        }
    }

    public List<PublicUser> anonymizeUsers(AuthCtx authCtx, Collection<PublicUser> users) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        ArrayList<PublicUser> anonymizedUsers = new ArrayList<PublicUser>();
        if (gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin()) {
            for (PublicUser user : users) {
                if (this.usersService.userHasACommonGroupWithAuthCtx(authCtx, user.login)) {
                    anonymizedUsers.add(user);
                    continue;
                }
                anonymizedUsers.add(TrackingService.anonymizeUser(user));
            }
        } else {
            anonymizedUsers.addAll(users);
        }
        return anonymizedUsers;
    }

    private static PublicUser anonymizeUser(PublicUser user) {
        PublicUser anonymizedUser = new PublicUser(user);
        anonymizedUser.email = null;
        anonymizedUser.login = "anonymous-bird-" + DigestUtils.md5Hex((String)user.login);
        anonymizedUser.displayName = "Anonymous Bird";
        return anonymizedUser;
    }

    private synchronized void recomputeWatches(TrackingSession session) {
        ArrayList sessionList = new ArrayList(this.sessions.asMap().values());
        ArrayList<WatchResult> watchesResults = new ArrayList<WatchResult>();
        for (WatchListChangedEvent.Watch watch : session.getWatches()) {
            WatchResult watchResult = new WatchResult();
            watchResult.watchId = watch.getWatchId();
            block8: for (TrackingSession otherSession : sessionList) {
                if (otherSession.getState() == null || !otherSession.getState().startsWith(watch.getStatePrefix())) continue;
                for (Map.Entry<String, String> entry : watch.getStateParams().entrySet()) {
                    if (Objects.equals(entry.getValue(), otherSession.getStateParams().get(entry.getKey()))) continue;
                    continue block8;
                }
                SessionResult sessionResult = new SessionResult(otherSession.isIdle(), otherSession.getUser(), otherSession.getSessionId());
                watchResult.sessions.add(sessionResult);
            }
            watchesResults.add(watchResult);
        }
        List<WatchResult> previousWatchesResults = session.getPreviousWatchesResults();
        if (!Objects.equals(previousWatchesResults, watchesResults)) {
            session.setPreviousWatchesResults(watchesResults);
            try {
                GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
                if (gs.security.restrictUsersAndGroupsVisibility) {
                    try (Transaction t = this.transactionService.retrieveOrBeginRead();){
                        DSSAuthCtx authCtx = DSSAuthCtx.forUserFromUI(this.usersService, session.user.login, null);
                        if (!authCtx.isAdmin()) {
                            for (WatchResult watchResult : watchesResults) {
                                for (SessionResult sessionResult : watchResult.sessions) {
                                    if (this.usersService.userHasACommonGroupWithAuthCtx((AuthCtx)authCtx, sessionResult.user.login)) continue;
                                    sessionResult.user = TrackingService.anonymizeUser(sessionResult.user);
                                }
                            }
                        }
                    }
                }
                this.pubSub.publish((DSSEvent)new WatchTriggeredEvent(session.getSessionId(), watchesResults));
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to check visibility of users in session", (Throwable)e);
            }
        }
    }

    public static class TrackingSession {
        private final PublicUser user;
        private List<WatchListChangedEvent.Watch> watches = Collections.emptyList();
        private List<WatchResult> previousWatchesResults;
        private String stateName;
        private Map<String, Object> stateParams;
        private boolean isIdle;
        private String sessionId;
        private long lastRefreshed;

        public TrackingSession(TrackingSession session) {
            this.user = new PublicUser(session.user);
            this.isIdle = session.isIdle;
            this.sessionId = session.sessionId;
            this.lastRefreshed = System.currentTimeMillis();
        }

        protected TrackingSession(PublicUser user, String sessionId) {
            this.user = (PublicUser)Preconditions.checkNotNull((Object)new PublicUser(user));
            this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId);
            this.lastRefreshed = System.currentTimeMillis();
        }

        public List<WatchListChangedEvent.Watch> getWatches() {
            return this.watches;
        }

        public void setWatches(List<WatchListChangedEvent.Watch> watches) {
            this.watches = watches;
            this.lastRefreshed = System.currentTimeMillis();
        }

        protected void setState(String stateName, Map<String, Object> stateParams) {
            this.stateName = stateName;
            this.stateParams = stateParams;
            this.lastRefreshed = System.currentTimeMillis();
        }

        public String getState() {
            return this.stateName;
        }

        @Nullable
        public Map<String, Object> getStateParams() {
            return this.stateParams;
        }

        @Nullable
        public String getStateParamAsString(String key) {
            Object param = this.stateParams == null || key == null ? null : this.stateParams.get(key);
            return param == null ? null : param.toString();
        }

        public List<WatchResult> getPreviousWatchesResults() {
            return this.previousWatchesResults;
        }

        public void setPreviousWatchesResults(List<WatchResult> previousWatchesResults) {
            this.previousWatchesResults = previousWatchesResults;
        }

        public boolean isIdle() {
            return this.isIdle;
        }

        protected void setIdle(boolean isIdle) {
            this.isIdle = isIdle;
            this.lastRefreshed = System.currentTimeMillis();
        }

        public long getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public PublicUser getUser() {
            return this.user;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TrackingSession) {
                TrackingSession ts = (TrackingSession)obj;
                return Objects.equals(ts.sessionId, this.sessionId) && Objects.equals(ts.isIdle, this.isIdle) && Objects.equals(ts.user, this.user);
            }
            return false;
        }
    }

    public static class WatchResult {
        String watchId;
        List<SessionResult> sessions = new ArrayList<SessionResult>();

        private WatchResult() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WatchResult) {
                WatchResult wr = (WatchResult)obj;
                return Objects.equals(wr.watchId, this.watchId) && Objects.equals(wr.sessions, this.sessions);
            }
            return false;
        }
    }

    public static class SessionResult {
        final boolean isIdle;
        PublicUser user;
        final String sessionId;

        public SessionResult(boolean isIdle, PublicUser user, String sessionId) {
            this.isIdle = isIdle;
            this.user = user;
            this.sessionId = sessionId;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SessionResult) {
                SessionResult s = (SessionResult)obj;
                return Objects.equals(s.isIdle, this.isIdle) && Objects.equals(s.user, this.user);
            }
            return false;
        }
    }
}

