/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.TextTermVectorField;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Field;
import com.dataiku.dss.shadelib.org.apache.lucene.document.IntField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LongField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.SortedNumericDocValuesField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.StoredField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.StringField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.TextField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class LuceneDocBuilder {
    private String docType;
    private LuceneMappingsAnalyzer luceneMappingsAnalyzer;
    private HashMap<String, Object> fieldsMap = new HashMap();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.LuceneDocBuilder");

    private LuceneDocBuilder(String docType, LuceneMappingsAnalyzer luceneMappingsAnalyzer, @Nullable String id) {
        this.docType = docType;
        this.luceneMappingsAnalyzer = luceneMappingsAnalyzer;
        this.fieldsMap.put("_type", docType);
        if (id != null) {
            this.fieldsMap.put("_id", id);
        }
    }

    public static LuceneDocBuilder from(String docType, LuceneMappingsAnalyzer luceneMappingsAnalyzer) {
        return LuceneDocBuilder.from(docType, luceneMappingsAnalyzer, null);
    }

    public static LuceneDocBuilder from(String docType, LuceneMappingsAnalyzer luceneMappingsAnalyzer, @Nullable String id) {
        if (!luceneMappingsAnalyzer.getTypes().contains(docType)) {
            throw new IllegalArgumentException("Type does not exist : " + docType);
        }
        return new LuceneDocBuilder(docType, luceneMappingsAnalyzer, id);
    }

    public boolean hasId() {
        return StringUtils.isNotBlank((String)this.getId());
    }

    @Nullable
    public String getId() {
        return (String)this.fieldsMap.get("_id");
    }

    public LuceneDocBuilder addBoolean(String fieldName, Boolean value) {
        this.assertFieldExists(fieldName);
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (!field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.BOOLEAN)) {
            throw new IllegalArgumentException("Trying to index as a boolean the field " + fieldName + " of type " + String.valueOf((Object)field.type));
        }
        this.fieldsMap.put(fieldName, value);
        return this;
    }

    public LuceneDocBuilder addString(String fieldName, String value) {
        this.assertFieldExists(fieldName);
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.STRING) || field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.TEXT)) {
            if (field.isMultiValued) {
                this.fieldsMap.put(fieldName, new ArrayList<String>(Collections.singletonList(value)));
            } else {
                this.fieldsMap.put(fieldName, value);
            }
        } else {
            throw new IllegalArgumentException("Trying to index as a string the field " + fieldName + " of type " + String.valueOf((Object)field.type));
        }
        return this;
    }

    public LuceneDocBuilder addStrings(String fieldName, Collection<String> value) {
        this.assertFieldExists(fieldName);
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (!field.isMultiValued) {
            throw new IllegalArgumentException("Trying to index as a collection of strings a field that is not multivalued : " + fieldName);
        }
        if (!field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.STRING) && !field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.TEXT)) {
            throw new IllegalArgumentException("Trying to index as a collection of strings the field " + fieldName + " of type " + String.valueOf((Object)field.type));
        }
        this.fieldsMap.put(fieldName, value);
        return this;
    }

    public LuceneDocBuilder appendString(String fieldName, String value) {
        this.assertFieldExists(fieldName);
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (!field.isMultiValued) {
            throw new IllegalArgumentException("Trying to index as a collection of strings a field that is not multivalued : " + fieldName);
        }
        if (!field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.STRING) && !field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.TEXT)) {
            throw new IllegalArgumentException("Trying to index as a collection of strings the field " + fieldName + " of type " + String.valueOf((Object)field.type));
        }
        if (this.fieldsMap.containsKey(fieldName)) {
            Collection list = (Collection)this.fieldsMap.get(fieldName);
            list.add(value);
            this.fieldsMap.put(fieldName, list);
        } else {
            this.fieldsMap.put(fieldName, new ArrayList<String>(Collections.singletonList(value)));
        }
        return this;
    }

    public LuceneDocBuilder addLong(String fieldName, Long value) {
        this.assertFieldExists(fieldName);
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (!field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.LONG)) {
            throw new IllegalArgumentException("Trying to index as a long the field " + fieldName + " of type " + String.valueOf((Object)field.type));
        }
        this.fieldsMap.put(fieldName, value);
        return this;
    }

    public LuceneDocBuilder addInt(String fieldName, Integer value) {
        this.assertFieldExists(fieldName);
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (!field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.INTEGER)) {
            throw new IllegalArgumentException("Trying to index as an int the field " + fieldName + " of type " + String.valueOf((Object)field.type));
        }
        this.fieldsMap.put(fieldName, value);
        return this;
    }

    public LuceneDocBuilder addJson(String fieldName, String value) {
        if (!this.luceneMappingsAnalyzer.getJsons(this.docType).contains(fieldName)) {
            throw new IllegalArgumentException("Trying to index as a JSON a field whose type is not a JSON : " + fieldName);
        }
        this.fieldsMap.put(fieldName, value);
        return this;
    }

    public boolean hasField(String fieldName) {
        return this.fieldsMap.containsKey(fieldName);
    }

    public LuceneDocBuilder remove(String fieldName) {
        this.fieldsMap.remove(fieldName);
        return this;
    }

    public Document buildDocument() {
        Document doc = new Document();
        for (Map.Entry<String, Object> dv : this.fieldsMap.entrySet()) {
            String fieldName = dv.getKey();
            Map<String, LuceneMappingsAnalyzer.Field> mapping = this.luceneMappingsAnalyzer.getMappingForType(this.docType);
            if (mapping.containsKey(fieldName)) {
                LuceneMappingsAnalyzer.MappingFieldType fieldType = mapping.get((Object)fieldName).type;
                switch (fieldType) {
                    case BOOLEAN: {
                        this.indexBoolean(doc, fieldName, (Boolean)dv.getValue());
                        break;
                    }
                    case LONG: {
                        this.indexLong(doc, fieldName, (Long)dv.getValue());
                        break;
                    }
                    case INTEGER: {
                        this.indexInteger(doc, fieldName, (Integer)dv.getValue());
                        break;
                    }
                    case STRING: 
                    case TEXT: {
                        if (mapping.get((Object)fieldName).isMultiValued) {
                            this.indexStrings(doc, fieldName, (Collection)dv.getValue());
                            break;
                        }
                        this.indexString(doc, fieldName, (String)dv.getValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown field type " + String.valueOf((Object)fieldType));
                    }
                }
                continue;
            }
            if (this.luceneMappingsAnalyzer.getJsons(this.docType).contains(fieldName)) {
                this.indexJson(doc, fieldName, (String)dv.getValue());
                continue;
            }
            throw new IllegalStateException("Field " + fieldName + " is not part of the schema");
        }
        return doc;
    }

    private void assertFieldExists(String fieldName) {
        if (!this.luceneMappingsAnalyzer.getMappingForType(this.docType).containsKey(fieldName)) {
            throw new IllegalArgumentException("Undeclared field [" + fieldName + "] for type [" + this.docType + "] - please update the json mapping");
        }
    }

    private void indexStrings(Document doc, String fieldName, Collection<String> fieldValues) {
        for (String fieldValue : fieldValues) {
            this.indexString(doc, fieldName, fieldValue);
        }
    }

    private void indexString(Document doc, String fieldName, String fieldValue) {
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        if (fieldValue != null) {
            Field.Store store;
            Field.Store store2 = store = this.luceneMappingsAnalyzer.getForceStore() || field.stored ? Field.Store.YES : Field.Store.NO;
            if (field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.TEXT)) {
                if (field.termVector && store == Field.Store.NO) {
                    logger.warnV("Term vector field [%s] should be stored to highlight search results", new Object[]{fieldName});
                }
                doc.add((IndexableField)(field.termVector ? new TextTermVectorField(fieldName, fieldValue, store) : new TextField(fieldName, fieldValue, store)));
            } else if (field.type.equals((Object)LuceneMappingsAnalyzer.MappingFieldType.STRING)) {
                doc.add((IndexableField)new StringField(fieldName, fieldValue, store));
            } else {
                logger.warn((Object)("Trying to index as a string a field whose type is not a string : " + fieldName));
            }
        }
        if (field.fields != null) {
            for (String key : field.fields) {
                this.indexString(doc, fieldName + "." + key, fieldValue);
            }
        }
    }

    private void indexBoolean(Document doc, String fieldName, Boolean fieldValue) {
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        doc.add((IndexableField)new StringField(fieldName, Boolean.TRUE.equals(fieldValue) ? "true" : "false", field.stored ? Field.Store.YES : Field.Store.NO));
    }

    private void indexInteger(Document doc, String fieldName, Integer fieldValue) {
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        doc.add((IndexableField)new IntField(fieldName, fieldValue.intValue(), field.stored ? Field.Store.YES : Field.Store.NO));
        if (field.withDocValues) {
            doc.add((IndexableField)new SortedNumericDocValuesField("docvalue_" + fieldName, (long)fieldValue.intValue()));
        }
    }

    private void indexLong(Document doc, String fieldName, Long fieldValue) {
        if (fieldValue == null) {
            return;
        }
        LuceneMappingsAnalyzer.Field field = this.luceneMappingsAnalyzer.getMappingForType(this.docType).get(fieldName);
        doc.add((IndexableField)new LongField(fieldName, fieldValue.longValue(), field.stored ? Field.Store.YES : Field.Store.NO));
    }

    private void indexJson(Document doc, String key, String value) {
        doc.add((IndexableField)new StoredField("$json_" + key, value));
    }
}

