/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.LuceneDocBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.custom.CustomAnalyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.en.PorterStemFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.WordDelimiterFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LuceneMappingsAnalyzer {
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.lucenemappingsanalyzer");
    public static final String indexNullValue = "__DKU__NULL__VALUE__";
    public static final String indexEmptyValue = "__DKU__EMPTY__VALUE__";
    private static final boolean forceStore = false;
    protected final String name;
    protected Map<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();
    protected Map<String, Map<String, Field>> mappingPerTypeMap = new HashMap<String, Map<String, Field>>();
    protected Map<String, Set<String>> jsonsPerType = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> restrictedFieldsPerType = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> multivaluedFieldsPerType = new HashMap<String, Set<String>>();
    protected Map<String, Map<String, Boolean>> serializableMappingPerType = new HashMap<String, Map<String, Boolean>>();
    protected Map<String, Map<String, MappingFieldType>> fieldTypeMappingPerType = new HashMap<String, Map<String, MappingFieldType>>();
    protected Map<String, Map<String, Boolean>> storedAndUnrestrictedMappingPerType = new HashMap<String, Map<String, Boolean>>();
    protected Map<String, Map<String, Boolean>> termVectorMappingPerType = new HashMap<String, Map<String, Boolean>>();
    protected Set<String> multivaluedFieldCondensedSet = null;
    protected Map<String, Field> condensedMapping = null;
    protected Map<String, Boolean> termVectorCondensedMapping = null;
    private final FacetsConfig facetsConfig = new FacetsConfig();
    public static final String POINT_PREFIX = "point_";
    public static final String DOC_VALUE_PREFIX = "docvalue_";
    private static final String LABEL_ANALYSIS = "analysis";
    private static final String LABEL_ANALYZER = "analyzer";
    private static final String LABEL_FILTER = "filter";
    private static final String LABEL_INDEX = "index";
    private static final String LABEL_MAPPINGS = "mappings";
    private static final String LABEL_PATTERN = "pattern";
    private static final String LABEL_PROPERTIES = "properties";
    private static final String LABEL_SOURCE = "_source";
    private static final String LABEL_EXCLUDES = "excludes";
    private static final String LABEL_SETTINGS = "settings";
    private static final String LABEL_TOKENIZER = "tokenizer";
    private static final String LABEL_TYPE = "type";
    private static final String FIELD_LABEL_ANALYZER = "analyzer";
    private static final String FIELD_LABEL_DOC_VALUES = "doc_values";
    private static final String FIELD_LABEL_INDEX = "index";
    private static final String FIELD_LABEL_FIELDS = "fields";
    private static final String FIELD_LABEL_TERM_VECTOR = "term_vector";
    private static final String FIELD_LABEL_TYPE = "type";
    public static final String FIELD_ID = "_id";
    public static final String FIELD_TYPE = "_type";
    private static final String FILTER_LABEL_NAME = "name";
    private static final String FILTER_NAME_ENGLISH = "english";
    private static final String DEFAULT_ANALYZER_VALUE = "default";
    private static final String TOKENIZER_LABEL_WHITESPACE = "whitespace";
    protected static final String FACET_PREFIX = "facet_";
    public static final String JSON_PREFIX = "$json_";
    public boolean isInitialized = false;
    private static final List<String> restrictedFields = List.of("authorized_members", "authorized_dashboard_groups", "authorized_dashboard_users", "authorized_discussion_groups", "authorized_discussion_users", "dataCollection");

    protected LuceneMappingsAnalyzer(String name) {
        this.name = name;
    }

    public LuceneMappingsAnalyzer(String name, String schema, Set<String> facets) {
        this(name, schema, facets, null);
    }

    public LuceneMappingsAnalyzer(String name, String schema, Set<String> facets, Set<String> multiValuedFields) {
        this(name, schema, facets, multiValuedFields, null);
    }

    public LuceneMappingsAnalyzer(String name, String schema, Set<String> facets, Set<String> multiValuedFields, Map<IndexableType, Set<String>> jsonFields) {
        this.name = name;
        try {
            JsonObject jsonSchema = (JsonObject)new Gson().fromJson(schema, JsonObject.class);
            this.buildAnalyzers(jsonSchema);
            this.buildMappings(jsonSchema, multiValuedFields == null ? Set.of() : multiValuedFields);
            this.buildSubMappings();
            this.postMappingAnalyzerAnalysis();
            if (facets != null) {
                facets.forEach(this::addFacet);
            }
            if (jsonFields != null) {
                jsonFields.keySet().forEach(objectType -> ((Set)jsonFields.get(objectType)).forEach(fieldName -> this.addJson(objectType.index(), (String)fieldName)));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while creating LuceneMappingsAnalyzer : " + name), (Throwable)e);
        }
    }

    private void buildAnalyzers(JsonObject jsonSchema) throws IOException {
        HashMap tokenizersMap = new HashMap();
        HashMap<String, Filter> filtersMap = new HashMap<String, Filter>();
        JsonObject settings = jsonSchema.getAsJsonObject(LABEL_SETTINGS);
        JsonObject analysisObj = settings.has("index") ? settings.getAsJsonObject("index").getAsJsonObject(LABEL_ANALYSIS) : settings.getAsJsonObject(LABEL_ANALYSIS);
        JsonObject tokenizers = analysisObj.getAsJsonObject(LABEL_TOKENIZER);
        if (tokenizers != null) {
            for (Object tokenizerName : tokenizers.keySet()) {
                JsonObject currentTokenizer = tokenizers.getAsJsonObject((String)tokenizerName);
                String type = currentTokenizer.get("type").getAsString();
                if (!type.equals(LABEL_PATTERN)) continue;
                String pattern = currentTokenizer.get(LABEL_PATTERN).getAsString();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put(LABEL_PATTERN, pattern);
                parameters.put("group", "-1");
                tokenizersMap.put(tokenizerName, parameters);
            }
        }
        JsonObject filters = analysisObj.getAsJsonObject(LABEL_FILTER);
        for (String filterName : filters.keySet()) {
            JsonObject currentFilter = filters.getAsJsonObject(filterName);
            String type = currentFilter.get("type").getAsString();
            if (type.equals(FilterType.STEMMER.toString())) {
                String name = currentFilter.get(FILTER_LABEL_NAME).getAsString();
                if (!name.equals(FILTER_NAME_ENGLISH)) continue;
                filtersMap.put(filterName, new Filter(PorterStemFilterFactory.class, null));
                continue;
            }
            if (!type.equals(FilterType.WORD_DELIMITER.toString())) continue;
            HashMap<String, String> wordDelimiterAttrs = new HashMap<String, String>();
            if (currentFilter.has(WordDelimiterOption.GENERATE_NUMBER_PARTS.label())) {
                wordDelimiterAttrs.put(WordDelimiterOption.GENERATE_NUMBER_PARTS.attribute(), currentFilter.get(WordDelimiterOption.GENERATE_NUMBER_PARTS.label()).getAsBoolean() ? "1" : "0");
            }
            if (currentFilter.has(WordDelimiterOption.STEM_ENGLISH_POSSESSIVE.label())) {
                wordDelimiterAttrs.put(WordDelimiterOption.STEM_ENGLISH_POSSESSIVE.attribute(), currentFilter.get(WordDelimiterOption.STEM_ENGLISH_POSSESSIVE.label()).getAsBoolean() ? "1" : "0");
            }
            if (currentFilter.has(WordDelimiterOption.SPLIT_ON_NUMERICS.label())) {
                wordDelimiterAttrs.put(WordDelimiterOption.SPLIT_ON_NUMERICS.attribute(), currentFilter.get(WordDelimiterOption.SPLIT_ON_NUMERICS.label()).getAsBoolean() ? "1" : "0");
            }
            if (currentFilter.has(WordDelimiterOption.PRESERVE_ORIGINAL.label())) {
                wordDelimiterAttrs.put(WordDelimiterOption.PRESERVE_ORIGINAL.attribute(), currentFilter.get(WordDelimiterOption.PRESERVE_ORIGINAL.label()).getAsBoolean() ? "1" : "0");
            }
            filtersMap.put(filterName, new Filter(WordDelimiterFilterFactory.class, wordDelimiterAttrs));
        }
        JsonObject analyzerJson = analysisObj.getAsJsonObject("analyzer");
        for (String analyzerName : analyzerJson.keySet()) {
            JsonObject currentAnalyzer = analyzerJson.getAsJsonObject(analyzerName);
            CustomAnalyzer.Builder analyzerBuilder = CustomAnalyzer.builder();
            String tokenizerString = currentAnalyzer.get(LABEL_TOKENIZER).getAsString();
            if (tokenizersMap.containsKey(tokenizerString)) {
                analyzerBuilder.withTokenizer(PatternTokenizerFactory.class, (Map)tokenizersMap.get(tokenizerString));
            } else if (tokenizerString.equals(TOKENIZER_LABEL_WHITESPACE)) {
                analyzerBuilder.withTokenizer(WhitespaceTokenizerFactory.class, new String[0]);
            }
            JsonElement filterJsonElt = currentAnalyzer.get(LABEL_FILTER);
            if (filterJsonElt.isJsonArray()) {
                JsonArray filtersJson = currentAnalyzer.getAsJsonArray(LABEL_FILTER);
                for (JsonElement filterJson : filtersJson) {
                    String filter = filterJson.getAsString();
                    this.addTokenToAnalyzerBuilder(analyzerBuilder, filtersMap, filter);
                }
            } else {
                String filter = filterJsonElt.getAsString();
                this.addTokenToAnalyzerBuilder(analyzerBuilder, filtersMap, filter);
            }
            this.analyzerMap.put(analyzerName, (Analyzer)analyzerBuilder.build());
        }
    }

    private void addTokenToAnalyzerBuilder(CustomAnalyzer.Builder analyzerBuilder, Map<String, Filter> filtersMap, String filterName) throws IOException {
        if (filtersMap.containsKey(filterName)) {
            Map<String, String> params = filtersMap.get((Object)filterName).params;
            if (params != null) {
                analyzerBuilder.addTokenFilter(filtersMap.get((Object)filterName).factoryClass, params);
            } else {
                analyzerBuilder.addTokenFilter(filtersMap.get((Object)filterName).factoryClass, new String[0]);
            }
        } else if (NativeTokenFilters.LOWERCASE.toString().equals(filterName)) {
            analyzerBuilder.addTokenFilter(LowerCaseFilterFactory.class, new String[0]);
        } else if (NativeTokenFilters.ASCII_FOLDING.toString().equals(filterName)) {
            analyzerBuilder.addTokenFilter(ASCIIFoldingFilterFactory.class, new String[0]);
        } else {
            logger.warn((Object)("Unknown token filter found : " + filterName));
        }
    }

    private void buildMappings(JsonObject jsonSchema, Set<String> multiValuedFields) {
        JsonObject mappingsObj = jsonSchema.getAsJsonObject(LABEL_MAPPINGS);
        for (String type : mappingsObj.keySet()) {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            JsonObject dssConceptObj = mappingsObj.getAsJsonObject(type);
            JsonObject fieldsObj = dssConceptObj.getAsJsonObject(LABEL_PROPERTIES);
            Set<String> sourceExcludedFields = this.getSourceExcludedFields(dssConceptObj);
            for (String fieldName : fieldsObj.keySet()) {
                JsonObject fieldObj = fieldsObj.getAsJsonObject(fieldName);
                this.handleObject(fieldMap, fieldObj, fieldName, sourceExcludedFields.contains(fieldName), "", type, multiValuedFields, false);
            }
            Field typeField = this.buildSimpleFieldString();
            fieldMap.put(FIELD_TYPE, typeField);
            Field idField = this.buildSimpleFieldString();
            fieldMap.put(FIELD_ID, idField);
            this.mappingPerTypeMap.put(type, fieldMap);
        }
    }

    private Set<String> getSourceExcludedFields(JsonObject dssConceptObj) {
        HashSet<String> sourceExcludedFields = new HashSet<String>();
        JsonObject sourceObj = dssConceptObj.getAsJsonObject(LABEL_SOURCE);
        if (sourceObj == null) {
            return sourceExcludedFields;
        }
        JsonArray sourceExcludedFieldsArr = sourceObj.getAsJsonArray(LABEL_EXCLUDES);
        if (sourceExcludedFieldsArr == null) {
            return sourceExcludedFields;
        }
        sourceExcludedFieldsArr.forEach(sourceExcludedField -> sourceExcludedFields.add(sourceExcludedField.getAsString()));
        return sourceExcludedFields;
    }

    private void handleObject(Map<String, Field> fieldMap, JsonObject fieldObj, String fieldName, boolean isSourceExcluded, String prefix, String type, Set<String> multiValuedFields, boolean inheritMultiValued) {
        boolean isSubField;
        String prefixedFieldName = prefix + fieldName;
        boolean isMultiValued = inheritMultiValued || multiValuedFields.contains(prefixedFieldName);
        boolean bl = isSubField = !prefix.isEmpty();
        if (!fieldObj.has("type") || fieldObj.get("type").getAsString().equals(FieldType.OBJECT.toString())) {
            this.handleObjectType(fieldMap, fieldObj, fieldName, isSourceExcluded, prefix, type, multiValuedFields, isMultiValued);
        } else if (fieldObj.get("type").getAsString().equals(FieldType.STRING.toString())) {
            this.handleFieldString(fieldMap, prefixedFieldName, fieldObj, isSourceExcluded, !prefix.isEmpty(), isMultiValued);
            if (fieldObj.has(FIELD_LABEL_FIELDS)) {
                JsonObject fieldsObj = fieldObj.get(FIELD_LABEL_FIELDS).getAsJsonObject();
                fieldsObj.keySet().forEach(fName -> this.handleFieldString(fieldMap, prefixedFieldName + "." + fName, fieldsObj.getAsJsonObject(fName), isSourceExcluded, true, isMultiValued));
            }
        } else if (fieldObj.get("type").getAsString().equals(FieldType.INTEGER.toString())) {
            boolean withDocValues = fieldObj.has(FIELD_LABEL_DOC_VALUES) && fieldObj.get(FIELD_LABEL_DOC_VALUES).getAsString().equals("true");
            this.handleFieldInt(fieldMap, prefixedFieldName, isSourceExcluded, isSubField, isMultiValued, withDocValues);
        } else if (fieldObj.get("type").getAsString().equals(FieldType.LONG.toString())) {
            this.handleFieldLong(fieldMap, prefixedFieldName, isSourceExcluded, isSubField, isMultiValued);
        } else if (fieldObj.get("type").getAsString().equals(FieldType.BOOLEAN.toString())) {
            this.handleFieldBool(fieldMap, prefixedFieldName, isSourceExcluded, isSubField, isMultiValued);
        } else {
            logger.warn((Object)("field label type not handled : " + String.valueOf(fieldObj.get("type"))));
        }
    }

    private void handleObjectType(Map<String, Field> fieldMap, JsonObject fieldObj, String fieldName, boolean isSourceExcluded, String prefix, String type, Set<String> multiValuedFields, boolean inheritMultiValued) {
        JsonObject fieldsObj = fieldObj.getAsJsonObject(LABEL_PROPERTIES);
        if (fieldsObj != null) {
            for (String subFieldName : fieldsObj.keySet()) {
                this.handleObject(fieldMap, fieldsObj.getAsJsonObject(subFieldName), subFieldName, isSourceExcluded, prefix + fieldName + ".", type, multiValuedFields, inheritMultiValued);
            }
        } else {
            logger.warn((Object)("object type with no properties found during building of mapping " + this.name + " : " + fieldName));
        }
        if (!isSourceExcluded && prefix.isEmpty()) {
            this.addJson(type, fieldName);
        }
    }

    private void handleFieldString(Map<String, Field> fieldMap, String fieldName, JsonObject fieldObj, boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField) {
        fieldMap.put(fieldName, this.buildFieldString(fieldObj, isSourceExcluded, isSubField, isMultiValuedField, restrictedFields.contains(fieldName)));
    }

    private void handleFieldInt(Map<String, Field> fieldMap, String fieldName, boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField, boolean withDocValue) {
        fieldMap.put(fieldName, this.buildFieldInt(isSourceExcluded, isSubField, isMultiValuedField, restrictedFields.contains(fieldName), withDocValue));
    }

    private void handleFieldLong(Map<String, Field> fieldMap, String fieldName, boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField) {
        fieldMap.put(fieldName, this.buildFieldLong(isSourceExcluded, isSubField, isMultiValuedField, restrictedFields.contains(fieldName)));
    }

    private void handleFieldBool(Map<String, Field> fieldMap, String fieldName, boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField) {
        fieldMap.put(fieldName, this.buildFieldBool(isSourceExcluded, isSubField, isMultiValuedField, restrictedFields.contains(fieldName)));
    }

    private Field buildFieldString(JsonObject fieldObj, boolean isSourceExcluded, boolean isSubField, boolean isMultiValued, boolean isRestricted) {
        Field field = new Field();
        field.serializable = !isSubField && !isSourceExcluded;
        field.isMultiValued = isMultiValued;
        field.stored = !isSubField;
        field.restricted = isRestricted;
        if (!fieldObj.has("index") || fieldObj.get("index").getAsString().equals(FieldIndexType.ANALYZED.toString())) {
            field.type = MappingFieldType.TEXT;
            field.analyzer = fieldObj.has("analyzer") ? fieldObj.get("analyzer").getAsString() : DEFAULT_ANALYZER_VALUE;
        } else if (fieldObj.get("index").getAsString().equals(FieldIndexType.NOT_ANALYZED.toString())) {
            field.type = MappingFieldType.STRING;
        } else if (fieldObj.get("index").getAsString().equals(FieldIndexType.NO.toString())) {
            field.type = MappingFieldType.STRING;
        } else {
            logger.warn((Object)("Unsupported field value for field index : " + fieldObj.get("index").getAsString()));
        }
        if (fieldObj.has(FIELD_LABEL_FIELDS)) {
            field.fields = fieldObj.getAsJsonObject(FIELD_LABEL_FIELDS).keySet();
        }
        if (fieldObj.has(FIELD_LABEL_TERM_VECTOR)) {
            if (TermVectorOption.WITH_POSITIONS_OFFSETS.toString().equals(fieldObj.get(FIELD_LABEL_TERM_VECTOR).getAsString())) {
                field.termVector = true;
                field.stored = true;
            } else if (TermVectorOption.NO.toString().equals(fieldObj.get(FIELD_LABEL_TERM_VECTOR).getAsString())) {
                field.termVector = false;
            } else {
                field.termVector = false;
                logger.warnV("Unsupported term vector option [%s]", new Object[]{fieldObj.get(FIELD_LABEL_TERM_VECTOR).getAsString()});
            }
        }
        return field;
    }

    private Field buildSimpleFieldString() {
        Field field = new Field();
        field.type = MappingFieldType.STRING;
        field.stored = true;
        field.serializable = true;
        field.isMultiValued = false;
        field.restricted = false;
        return field;
    }

    private Field buildFieldInt(boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField, boolean isRestricted, boolean withDocValues) {
        Field field = new Field();
        field.restricted = isRestricted;
        field.type = MappingFieldType.INTEGER;
        field.stored = !isSubField;
        field.serializable = !isSubField && !isSourceExcluded;
        field.isMultiValued = isMultiValuedField;
        field.withDocValues = withDocValues;
        return field;
    }

    private Field buildFieldLong(boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField, boolean isRestricted) {
        Field field = new Field();
        field.restricted = isRestricted;
        field.type = MappingFieldType.LONG;
        field.stored = !isSubField;
        field.serializable = !isSubField && !isSourceExcluded;
        field.isMultiValued = isMultiValuedField;
        return field;
    }

    private Field buildFieldBool(boolean isSourceExcluded, boolean isSubField, boolean isMultiValuedField, boolean isRestricted) {
        Field field = new Field();
        field.restricted = isRestricted;
        field.type = MappingFieldType.BOOLEAN;
        field.stored = !isSubField;
        field.serializable = !isSubField && !isSourceExcluded;
        field.isMultiValued = isMultiValuedField;
        return field;
    }

    public Map<String, Analyzer> getAnalyzerPerFieldMap(String type) {
        return this.mappingPerTypeMap.get(type).entrySet().stream().filter(e -> ((Field)e.getValue()).analyzer != null && !((Field)e.getValue()).analyzer.equals(DEFAULT_ANALYZER_VALUE)).collect(Collectors.toMap(Map.Entry::getKey, e -> this.analyzerMap.get(((Field)e.getValue()).analyzer)));
    }

    public Map<String, Analyzer> getAnalyzerPerFieldMap() {
        return this.mappingPerTypeMap.entrySet().stream().flatMap(m -> ((Map)m.getValue()).entrySet().stream()).filter(e -> ((Field)e.getValue()).analyzer != null).filter(e -> !((Field)e.getValue()).analyzer.equals(DEFAULT_ANALYZER_VALUE)).collect(Collectors.toMap(Map.Entry::getKey, m -> this.analyzerMap.get(((Field)m.getValue()).analyzer), (first, second) -> first));
    }

    public Analyzer getDefaultAnalyzer() {
        return this.analyzerMap.get(DEFAULT_ANALYZER_VALUE);
    }

    public Map<String, Field> getMappingForType(String type) {
        return this.mappingPerTypeMap.get(type);
    }

    public Map<String, Boolean> getStoredAndUnrestrictedMappingForType(String type) {
        return this.storedAndUnrestrictedMappingPerType.get(type);
    }

    public Map<String, MappingFieldType> getFieldTypeMappingForType(String type) {
        return this.fieldTypeMappingPerType.get(type);
    }

    public Map<String, Boolean> getSerializableMappingForType(String type) {
        return this.serializableMappingPerType.get(type);
    }

    public Set<String> getRestrictedFields(String type) {
        return this.restrictedFieldsPerType.get(type);
    }

    public Map<String, Boolean> getTermVectorMappingForType(String type) {
        return this.termVectorMappingPerType.get(type);
    }

    public Map<String, Boolean> getTermVectorCondensedMapping() {
        return this.termVectorCondensedMapping;
    }

    public Set<String> getMultivaluedFieldSetForType(String type) {
        return this.multivaluedFieldsPerType.get(type);
    }

    public Set<String> getMultivaluedFieldCondensedSet() {
        return this.multivaluedFieldCondensedSet;
    }

    public Map<String, Field> getCondensedMapping() {
        return this.condensedMapping;
    }

    private Field mergeSubFields(Field o1, Field o2) {
        if (o1.fields != null && o2.fields == null) {
            return new Field(o1);
        }
        if (o1.fields == null && o2.fields != null) {
            return new Field(o2);
        }
        if (o1.fields != null && o2.fields != null) {
            if (o1.fields.containsAll(o2.fields)) {
                return new Field(o1);
            }
            if (o2.fields.containsAll(o1.fields)) {
                return new Field(o2);
            }
            if (!o2.fields.containsAll(o1.fields) && !o1.fields.containsAll(o2.fields)) {
                Field field = new Field(o1);
                field.fields = Stream.concat(o1.fields.stream(), o2.fields.stream()).collect(Collectors.toSet());
                return field;
            }
        }
        return new Field(o1);
    }

    public Set<String> getBooleanFieldSetForType(String type) {
        return this.mappingPerTypeMap.get(type).entrySet().stream().filter(e -> ((Field)e.getValue()).type.equals((Object)MappingFieldType.BOOLEAN)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getBooleanFieldCondensedSet() {
        return this.mappingPerTypeMap.entrySet().stream().flatMap(m -> ((Map)m.getValue()).entrySet().stream()).filter(e -> ((Field)e.getValue()).type.equals((Object)MappingFieldType.BOOLEAN)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void addJson(String type, String jsonField) {
        if (this.jsonsPerType.containsKey(type)) {
            this.jsonsPerType.get(type).add(jsonField);
        } else {
            HashSet<String> jsonFieldSet = new HashSet<String>();
            jsonFieldSet.add(jsonField);
            this.jsonsPerType.put(type, jsonFieldSet);
        }
    }

    public Set<String> getJsons(String type) {
        if (!this.jsonsPerType.containsKey(type)) {
            return new HashSet<String>();
        }
        return this.jsonsPerType.get(type);
    }

    public Set<String> getTypes() {
        return this.mappingPerTypeMap.keySet();
    }

    public Set<String> getCondensedJsons() {
        return this.jsonsPerType.entrySet().stream().flatMap(m -> ((Set)m.getValue()).stream()).collect(Collectors.toSet());
    }

    private void postMappingAnalyzerAnalysis() {
        if (this.mappingPerTypeMap.size() == 1) {
            return;
        }
        HashMap analyzersPerField = new HashMap();
        for (String type : this.mappingPerTypeMap.keySet()) {
            Map<String, Field> mapping = this.mappingPerTypeMap.get(type);
            for (String field : mapping.keySet()) {
                Set<String> analyzersSet = analyzersPerField.containsKey(field) ? (Set)analyzersPerField.get(field) : new HashSet();
                analyzersSet.add(mapping.get((Object)field).analyzer);
                analyzersPerField.put(field, analyzersSet);
            }
        }
        Map<String, Set> reducedAnalyzersPerField = analyzersPerField.entrySet().stream().filter(x -> ((Set)x.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!reducedAnalyzersPerField.isEmpty()) {
            throw new RuntimeException("Too many analyzers for some fields : " + String.valueOf(reducedAnalyzersPerField));
        }
    }

    public void addFacet(String dimName) {
        this.addFacet(dimName, dimName);
    }

    private void addFacet(String dimName, String indexFieldName) {
        this.facetsConfig.setIndexFieldName(FACET_PREFIX + dimName, FACET_PREFIX + indexFieldName);
        if (this.isFieldMultiValued(dimName)) {
            this.facetsConfig.setMultiValued(FACET_PREFIX + dimName, true);
        }
    }

    private boolean isFieldMultiValued(String dimName) {
        return this.getMultivaluedFieldCondensedSet().contains(dimName);
    }

    public FacetsConfig getFacetsConfig() {
        return this.facetsConfig;
    }

    public PerFieldAnalyzerWrapper getPerFieldAnalyzerWrapper() {
        return new PerFieldAnalyzerWrapper(this.getDefaultAnalyzer(), this.getAnalyzerPerFieldMap());
    }

    public PerFieldAnalyzerWrapper getPerFieldAnalyzerWrapper(String type) {
        return new PerFieldAnalyzerWrapper(this.getDefaultAnalyzer(), this.getAnalyzerPerFieldMap(type));
    }

    public void addDocument(IndexWriter indexWriter, LuceneDocBuilder doc) throws IOException {
        Document luceneDocument = doc.buildDocument();
        Document builtDoc = this.addDocumentFacets(luceneDocument);
        if (doc.hasId()) {
            indexWriter.updateDocument(new Term(FIELD_ID, doc.getId()), (Iterable)builtDoc);
        } else {
            indexWriter.addDocument((Iterable)builtDoc);
        }
    }

    private Document addDocumentFacets(Document doc) throws IOException {
        if (this.facetsConfig.getDimConfigs().isEmpty()) {
            return doc;
        }
        for (Map.Entry entry : this.getFacetsConfig().getDimConfigs().entrySet()) {
            String fieldName = ((String)entry.getKey()).substring(FACET_PREFIX.length());
            String facetName = ((FacetsConfig.DimConfig)entry.getValue()).indexFieldName;
            if (doc.getFields(fieldName).length == 0) {
                doc.add((IndexableField)new SortedSetDocValuesFacetField(facetName, new String[]{indexNullValue}));
                continue;
            }
            for (IndexableField indexableField : doc.getFields(fieldName)) {
                String indexableFieldValue = indexableField.stringValue();
                doc.add((IndexableField)new SortedSetDocValuesFacetField(facetName, new String[]{indexableFieldValue.isEmpty() ? indexEmptyValue : indexableFieldValue}));
            }
        }
        return this.getFacetsConfig().build(doc);
    }

    protected void buildSubMappings() {
        this.condensedMapping = this.mappingPerTypeMap.entrySet().stream().flatMap(m -> ((Map)m.getValue()).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> {
            Field field = this.mergeSubFields((Field)o1, (Field)o2);
            field.isMultiValued = o1.isMultiValued || o2.isMultiValued;
            field.restricted = o1.restricted || o2.restricted;
            return field;
        }));
        this.termVectorCondensedMapping = this.condensedMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Field)e.getValue()).termVector));
        this.multivaluedFieldCondensedSet = this.mappingPerTypeMap.entrySet().stream().flatMap(m -> ((Map)m.getValue()).entrySet().stream()).filter(e -> ((Field)e.getValue()).isMultiValued).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (String type : this.mappingPerTypeMap.keySet()) {
            this.fieldTypeMappingPerType.put(type, this.mappingPerTypeMap.get(type).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Field)e.getValue()).type)));
            this.serializableMappingPerType.put(type, this.mappingPerTypeMap.get(type).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Field)e.getValue()).serializable && !((Field)e.getValue()).restricted)));
            this.restrictedFieldsPerType.put(type, this.mappingPerTypeMap.get(type).entrySet().stream().filter(e -> ((Field)e.getValue()).restricted).map(Map.Entry::getKey).collect(Collectors.toSet()));
            this.termVectorMappingPerType.put(type, this.mappingPerTypeMap.get(type).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Field)e.getValue()).termVector)));
            this.multivaluedFieldsPerType.put(type, this.mappingPerTypeMap.get(type).entrySet().stream().filter(e -> ((Field)e.getValue()).isMultiValued).map(Map.Entry::getKey).collect(Collectors.toSet()));
            this.storedAndUnrestrictedMappingPerType.put(type, this.mappingPerTypeMap.get(type).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Field)e.getValue()).stored && !((Field)e.getValue()).restricted)));
        }
    }

    public boolean getForceStore() {
        return false;
    }

    private static enum FilterType {
        STEMMER("stemmer"),
        WORD_DELIMITER("word_delimiter");

        private final String name;

        private FilterType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Filter {
        private Class<? extends TokenFilterFactory> factoryClass;
        private Map<String, String> params;

        Filter(Class<? extends TokenFilterFactory> factoryClass, Map<String, String> params) {
            this.factoryClass = factoryClass;
            this.params = params;
        }
    }

    private static enum WordDelimiterOption {
        GENERATE_NUMBER_PARTS("generate_number_parts", "generateNumberParts"),
        STEM_ENGLISH_POSSESSIVE("stem_english_possessive", "stemEnglishPossessive"),
        SPLIT_ON_NUMERICS("split_on_numerics", "splitOnNumerics"),
        PRESERVE_ORIGINAL("preserve_original", "preserveOriginal");

        private final String label;
        private final String attribute;

        private WordDelimiterOption(String label, String attribute) {
            this.label = label;
            this.attribute = attribute;
        }

        public String label() {
            return this.label;
        }

        public String attribute() {
            return this.attribute;
        }
    }

    private static enum NativeTokenFilters {
        ASCII_FOLDING("asciifolding"),
        LOWERCASE("lowercase");

        private final String name;

        private NativeTokenFilters(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Field {
        MappingFieldType type;
        String analyzer;
        boolean stored;
        boolean restricted;
        boolean serializable;
        Set<String> fields;
        boolean termVector;
        boolean isMultiValued = false;
        boolean withDocValues = false;

        public Field() {
        }

        public Field(Field f) {
            this.type = f.type;
            this.analyzer = f.analyzer;
            this.stored = f.stored;
            this.restricted = f.restricted;
            this.serializable = f.serializable;
            this.fields = f.fields;
            this.termVector = f.termVector;
            this.isMultiValued = f.isMultiValued;
        }

        public String toString() {
            return "Field{type=" + String.valueOf((Object)this.type) + ", analyzer='" + this.analyzer + "', stored=" + this.stored + ", restricted=" + this.restricted + ", serializable=" + this.serializable + ", fields=" + String.valueOf(this.fields) + ", termVector=" + this.termVector + ", isMultiValued=" + this.isMultiValued + "}";
        }
    }

    private static enum FieldType {
        OBJECT("object"),
        STRING("string"),
        INTEGER("integer"),
        LONG("long"),
        BOOLEAN("boolean");

        private final String name;

        private FieldType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum FieldIndexType {
        NO("no"),
        ANALYZED("analyzed"),
        NOT_ANALYZED("not_analyzed");

        private final String name;

        private FieldIndexType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MappingFieldType {
        BOOLEAN,
        LONG,
        INTEGER,
        STRING,
        TEXT;

    }

    private static enum TermVectorOption {
        NO("no"),
        YES("yes"),
        WITH_POSITIONS("with_positions"),
        WITH_OFFSETS("with_offsets"),
        WITH_POSITIONS_OFFSETS("with_positions_offsets");

        private final String name;

        private TermVectorOption(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

