/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchAllDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LuceneQueryWrapper {
    private Query query = null;
    private BooleanQuery postFilterQuery = null;
    private Map<String, BooleanQuery> facetQueryMap = new HashMap<String, BooleanQuery>();
    private Set<IndexableType> requestedTypes = new HashSet<IndexableType>();

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setPostFilterQuery(BooleanQuery postFilterQuery) {
        this.postFilterQuery = postFilterQuery;
    }

    public void addFacet(String facet) {
        this.facetQueryMap.put(facet, null);
    }

    public void addFacet(String facet, BooleanQuery filter) {
        this.facetQueryMap.put(facet, filter);
    }

    public Query getQuery() {
        if (this.query == null) {
            return new MatchAllDocsQuery();
        }
        return this.query;
    }

    public Query getTopDocsCollectorQuery() {
        if (this.query == null && this.postFilterQuery == null) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (this.query != null) {
            builder.add(this.query, BooleanClause.Occur.MUST);
        }
        if (this.postFilterQuery != null) {
            builder.add((Query)this.postFilterQuery, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    public Map<String, BooleanQuery> getFacetsQueriesMap() {
        return this.facetQueryMap;
    }

    public void addRequestedType(IndexableType requestedType) {
        this.requestedTypes.add(requestedType);
    }

    public Set<IndexableType> getRequestedTypes() {
        return this.requestedTypes;
    }
}

