/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.projects;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectSummaryService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private SavedModelsCRUDService smCRUDService;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private ManagedFolderDAO managedFoldersDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private PromptStudioDAO promptStudioDAO;

    public ProjectConfigContent computeConfigContent(String projectKey) throws Exception {
        ProjectConfigContent status = new ProjectConfigContent();
        status.datasets = this.datasetsDAO.listUnsafe(projectKey).size();
        status.recipes = this.recipesDAO.listUnsafe(projectKey).size();
        List<SavedModel> savedModels = this.smCRUDService.list(projectKey);
        status.savedModels = savedModels.size();
        for (SavedModel sm : savedModels) {
            if (sm.savedModelType == null || sm.savedModelType.savedModelHandlingType == null) continue;
            switch (sm.savedModelType.savedModelHandlingType) {
                case INTERNAL: 
                case EXTERNAL_MLFLOW: {
                    ++status.mlSavedModels;
                    break;
                }
                case LLM_GENERIC: {
                    ++status.llmSavedModels;
                    ++status.llmFineTunedModels;
                    break;
                }
                case RETRIEVAL_AUGMENTED_LLM: {
                    ++status.llmSavedModels;
                    ++status.llmRagModels;
                    break;
                }
                case PLUGIN_AGENT: 
                case PYTHON_AGENT: 
                case TOOLS_USING_AGENT: {
                    ++status.agents;
                }
            }
        }
        status.modelEvaluationStores = this.modelEvaluationStoresDAO.list(projectKey).size();
        status.labelingTasks = this.labelingTasksDAO.list(projectKey).size();
        status.managedFolders = this.managedFoldersDAO.listUnsafe(projectKey).size();
        status.knowledgeBanks = this.retrievableKnowledgeDAO.listUnsafe(projectKey).size();
        status.promptStudios = this.promptStudioDAO.listUnsafe(projectKey).size();
        status.analysis = this.analysisCRUDService.listHeadsUnsafe(projectKey, null).size();
        status.jupyterNotebooks = this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey).size();
        status.sqlNotebooks = this.sqlNotebooksService.listWithoutTimelineUnsafe(projectKey).size();
        status.insights = this.insightsService.listUnsafe(projectKey).size();
        status.dashboards = this.dashboardsService.listUnsafe(projectKey).size();
        return status;
    }

    public static class ProjectConfigContent {
        public int datasets;
        public int recipes;
        public int savedModels;
        public int modelEvaluationStores;
        public int managedFolders;
        public int scenarios;
        public int analysis;
        public int jupyterNotebooks;
        public int sqlNotebooks;
        public int insights;
        public int dashboards;
        public int labelingTasks;
        public int knowledgeBanks;
        public int promptStudios;
        public int mlSavedModels;
        public int llmSavedModels;
        public int llmRagModels;
        public int llmFineTunedModels;
        public int agents;
    }
}

