/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker;

import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.udf.AbstractPythonUDF;
import com.dataiku.dip.shaker.processors.udf.PythonParameter;
import com.dataiku.dip.shaker.processors.udf.PythonUDF;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.List;

public class ShakerUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker");

    private static void checkPermission(AuthCtx liu, ScriptStep step) throws UnauthorizedException {
        if (step instanceof ProcessorScriptStep) {
            if (PythonUDF.META.getName().equals(((ProcessorScriptStep)step).type)) {
                if (((PythonParameter)((ProcessorScriptStep)step).params).useKernel) {
                    liu.failIfNoSafeCode("execute a Python processor");
                } else {
                    boolean canSafeCode = ((DSSAuthCtx)liu).getPermissions().mayWriteSafeCode();
                    if (canSafeCode) {
                        liu.failIfNoUnsafeCode("execute a Python processor in Jython mode. Switch to 'Use a real Python process'");
                    } else {
                        liu.failIfNoUnsafeCode("execute a Python processor");
                    }
                }
            }
        } else if (step instanceof GroupScriptStep) {
            for (ProcessorScriptStep child : ((GroupScriptStep)step).steps) {
                ShakerUtils.checkPermission(liu, child);
            }
        } else {
            throw new NotImplementedException();
        }
    }

    public static void checkScriptCodePermission(AuthCtx liu, SerializedShakerScript script) throws UnauthorizedException {
        if (!liu.isUnsafeCodeAllowed()) {
            for (ScriptStep step : script.steps) {
                ShakerUtils.checkPermission(liu, step);
            }
        }
    }

    public static void warnDeprecatedPythonVersion(WarningsContext warnContext, String projectKey, ScriptStep step) {
        block7: {
            if (step instanceof ProcessorScriptStep) {
                ProcessorScriptStep psstep = (ProcessorScriptStep)step;
                try {
                    Processor proc = BaseProcessorsFactory.build(psstep, BaseProcessorsFactory.PipelineContext.fakePipelineContext());
                    if (!(proc instanceof AbstractPythonUDF)) break block7;
                    AbstractPythonUDF pyproc = (AbstractPythonUDF)proc;
                    String envName = pyproc.getCodeEnvName(projectKey);
                    StandardPythonInterpreter pythonInterpreter = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getPythonInterpreterVersion(envName, projectKey);
                    if (pyproc.getUseKernel() && pythonInterpreter != null && pythonInterpreter.isDeprecated()) {
                        warnContext.addWarning(WarningsContext.WarningType.DEPRECATED_PYTHON_INTERPRETER, String.format("Code-env '%s' uses '%s' which is deprecated and will soon be removed.", new Object[]{envName, pythonInterpreter}), logger);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)String.format("Evaluation of python interpreter deprecation status failed for step of type %s with error: ", psstep.type), (Throwable)e);
                }
            } else if (step instanceof GroupScriptStep) {
                for (ProcessorScriptStep child : ((GroupScriptStep)step).steps) {
                    ShakerUtils.warnDeprecatedPythonVersion(warnContext, projectKey, child);
                }
            }
        }
    }

    public static void warnDeprecatedPythonVersion(WarningsContext warnContext, String projectKey, List<ScriptStep> steps) {
        for (ScriptStep step : steps) {
            ShakerUtils.warnDeprecatedPythonVersion(warnContext, projectKey, step);
        }
    }
}

