/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.cleansing;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnDeletionSensitiveProcessor;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RemoveRowsOnEmpty {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "RemoveRowsOnEmpty";
        }

        @Override
        public String getDocPage() {
            return "remove-empty";
        }

        @Override
        public Category getCategory() {
            return Category.CLEANSING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING, ProcessorTag.FILTER});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.RemoveRowsOnEmpty.HELP", "Remove (or keep) rows for which cells in the selected column are empty. When using multiple columns, a row is considered matching if at least one of the selected columns is empty. \n\n# Options\n**Column**\nApply check to the following: \n* A single column\n* An explicit list of columns\n* All columns matching a regex pattern\n* All columns");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.RemoveRowsOnEmpty.DESCRIPTION", 1.actionVerb("Remove") + "/" + 1.actionVerb("Keep") + " rows where cell is empty")).withBool("keep", "", this.translate(language, "SHAKER.PROCESSOR.RemoveRowsOnEmpty.DESCRIPTION.KEEP.TRUE", "Keep rows"), this.translate(language, "SHAKER.PROCESSOR.RemoveRowsOnEmpty.DESCRIPTION.KEEP.FALSE", "Remove rows"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return AppliesToProcessor.selfReport(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public StreamImpl build(Parameter parameter) throws Exception {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new FilterSQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.cleansing.RemoveRowsOnEmptyNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                for (String outputColumn : updatedDatasetPairLineage.getOutputColumns()) {
                    updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage(pss.params, updatedDatasetPairLineage, outputColumn, AppliesToProcessor.AppliesToProcessorMeta.RelationDirection.TO, false, true);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class FilterSQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private FilterSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            List<String> appliesToColumns = input.getAppliesToColumns(this.parameter);
            if (input.isAnyCreatedOrModifiedByCurrentQuery(appliesToColumns)) {
                input = input.makeSubquery();
            }
            ArrayList<ExpressionBuilder> nullConds = new ArrayList<ExpressionBuilder>();
            for (String column : appliesToColumns) {
                Optional<SchemaColumn> inputColumnOptional = input.getInputColumn(column);
                if (!inputColumnOptional.isPresent()) {
                    throw new IllegalArgumentException("There is no column name or alias with the name '" + column + "'");
                }
                ExpressionBuilder isEmptyExpr = ((SchemaColumn)inputColumnOptional.get()).getType() == Type.STRING ? input.col(column).isNullOrEmptyString() : input.col(column).isnull();
                nullConds.add(isEmptyExpr);
            }
            if (this.parameter.keep) {
                eb = (ExpressionBuilder)nullConds.get(0);
                for (int i = 1; i < nullConds.size(); ++i) {
                    eb = eb.or((ExpressionBuilder)nullConds.get(i));
                }
                input.where(eb);
            } else {
                eb = (ExpressionBuilder)nullConds.get(0);
                for (int i = 1; i < nullConds.size(); ++i) {
                    eb = eb.or((ExpressionBuilder)nullConds.get(i));
                }
                input.where(eb.not());
            }
            return input;
        }
    }

    private static class StreamImpl
    extends AppliesToProcessor
    implements Processor,
    ColumnDeletionSensitiveProcessor {
        private final Parameter parameter;

        public StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        public void postProcess() {
        }

        @Override
        public AppliesToProcessor.AppliesToParams getParams() {
            return this.parameter;
        }

        @Override
        public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
            for (Column cd : columns) {
                String v = row.get(cd);
                if (v != null) continue;
                if (!this.parameter.keep) {
                    row.delete();
                }
                return;
            }
            if (this.parameter.keep) {
                row.delete();
            }
        }

        public InfoMessage getDeletedColumnsWarningMessage() {
            if (this.getParams().appliesTo == AppliesToProcessor.AppliesTo.ALL || this.getParams().appliesTo == AppliesToProcessor.AppliesTo.PATTERN) {
                return InfoMessage.warning((InfoMessage.MessageCode)ScriptStep.StepCodes.WARN_DELETED_COLUMN_MAY_BE_USED, (String)"This processor may produce unexpected results when used after a delete or rename processor on the DSS engine. It is recommended to split the steps into two separate recipes.");
            }
            return null;
        }
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public boolean keep;
    }
}

