/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ChangeCRSProcessor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<ChangeCRSProcessor, Parameter> META = new ProcessorMeta<ChangeCRSProcessor, Parameter>(){

        @Override
        public String getName() {
            return "ChangeCRSProcessor";
        }

        @Override
        public String getDocPage() {
            return "change-crs";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ChangeCRSProcessor.HELP", "This processor changes the Coordinates Reference System (CRS) of a geometry or geopoint column.\n\nSource and target CRS can be given either as a EPSG code (like: EPSG:4326) or as WKT.\n\nSQL engine can be used only for PostgreSQL connections with PostGIS enabled and only supports EPSG code.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public Object selfReport(Parameter param) {
            return JSON.deepCopyExcept((Object)param, (String[])new String[]{"geomCol"});
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ChangeCRSProcessor.DESCRIPTION", 1.actionVerb("Change") + " coordinates system")).withMNEColParam("geomCol", this.translate(language, "SHAKER.PROCESSOR.ChangeCRSProcessor.DESCRIPTION.GEOM_COL", "Geometry column")).withMNESParam("fromCRS", this.translate(language, "SHAKER.PROCESSOR.ChangeCRSProcessor.DESCRIPTION.FROM_CRS", "Source CRS")).withMNESParam("toCRS", this.translate(language, "SHAKER.PROCESSOR.ChangeCRSProcessor.DESCRIPTION.TO_CRS", "Target CRS"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter changeCRSParams = (Parameter)params;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            CRSHandler sourceCRSHandler = new CRSHandler(changeCRSParams.fromCRS);
            CRSHandler targetCRSHandler = new CRSHandler(changeCRSParams.toCRS);
            if (dialect instanceof PostgreSQLDialect) {
                if (sourceCRSHandler.isWKT() || targetCRSHandler.isWKT()) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine with WKT CRS: only valid EPSG SRID are accepted as CRS (ex: 'EPSG:4326')");
                } else {
                    ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                }
            } else {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use the selected SQL engine, only PostgreSQL with PostGIS support enabled can be used");
            }
            return ret;
        }

        @Override
        public ChangeCRSProcessor build(Parameter parameter) throws Exception {
            return new ChangeCRSProcessor(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter processorParams = (Parameter)pss.params;
            if (StringUtils.isBlank((String)processorParams.geomCol)) {
                throw new IllegalConfigurationException("Missing geometry column information for lineage on the change CRS processor.");
            }
            if (StringUtils.isBlank((String)processorParams.fromCRS)) {
                throw new IllegalConfigurationException("Missing source CRS column information for lineage on the change CRS processor.");
            }
            if (StringUtils.isBlank((String)processorParams.toCRS)) {
                throw new IllegalConfigurationException("Missing target CRS column information for lineage on the change CRS processor.");
            }
            return previousRecipeLineage;
        }
    };
    final Parameter parameter;
    Column geomCD;
    GeometryFactory factory = new GeometryFactory();
    MathTransform transform;
    GeometryMeaning geomMeaning = new GeometryMeaning();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker");

    public ChangeCRSProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() throws FactoryException {
        this.geomCD = this.getColumnFactory().column(this.parameter.geomCol, Processor.ProcessorRole.INPUT_COLUMN);
        try {
            Object sourceCRS = null;
            CRSHandler sourceCRSHandler = new CRSHandler(this.parameter.fromCRS);
            CRSHandler targetCRSHandler = new CRSHandler(this.parameter.toCRS);
            this.transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRSHandler.getCRS(), (CoordinateReferenceSystem)targetCRSHandler.getCRS(), (boolean)true);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new IllegalArgumentException("You need to install the Vecmath library to perform this conversion. Please see DSS doc: https://doc.dataiku.com/dss/latest/formats/shapefile.html", ncdfe);
        }
    }

    public void processRow(Row row) throws Exception {
        String val = row.get(this.geomCD);
        if (StringUtils.isBlank((String)val)) {
            return;
        }
        String convertedValue = null;
        Geometry geom = null;
        String error = null;
        try {
            geom = this.geomMeaning.toGeometry(val);
            if (geom == null) {
                error = String.format("Failed to parse geometry '%s'", val);
            }
        }
        catch (Exception e) {
            error = String.format("Failed to parse geometry '%s': %s", val, e.getMessage());
        }
        if (geom != null) {
            try {
                Geometry convertedGeom = JTS.transform((Geometry)geom, (MathTransform)this.transform);
                if (convertedGeom != null) {
                    convertedValue = convertedGeom.toString();
                } else {
                    error = String.format("Failed to transform CRS of geometry '%s'", val);
                }
            }
            catch (Exception e) {
                error = String.format("Failed to transform CRS of geometry '%s': %s", val, e.getMessage());
            }
        }
        row.put(this.geomCD, convertedValue);
        if (error != null) {
            this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_GEO, error, logger);
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String geomCol;
        String fromCRS;
        String toCRS;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class CRSHandler {
        private final String crsCode;

        private CRSHandler(String crsCode) {
            this.crsCode = crsCode;
        }

        public CoordinateReferenceSystem getCRS() throws FactoryException {
            if (this.crsCode.contains("PROJCS[")) {
                return CRS.parseWKT((String)this.crsCode);
            }
            return CRS.decode((String)this.crsCode, (boolean)true);
        }

        public int getEPSGCode() {
            try {
                return CRS.lookupEpsgCode((CoordinateReferenceSystem)this.getCRS(), (boolean)false);
            }
            catch (FactoryException fe) {
                String errorMessage = String.format("Invalid CRS '%s'. Only valid EPSG SRID are accepted for SQL (ex: 'EPSG:4326').", this.crsCode);
                logger.error((Object)errorMessage, (Throwable)fe);
                throw new IllegalArgumentException(errorMessage);
            }
        }

        public boolean isWKT() {
            return this.crsCode.contains("PROJCS[");
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            String affectedColumn = this.parameter.geomCol;
            if (chain.isCreatedOrModifiedByCurrentQuery(affectedColumn)) {
                chain = chain.makeSubquery();
            }
            CRSHandler sourceCRSHandler = new CRSHandler(this.parameter.fromCRS);
            CRSHandler targetCRSHandler = new CRSHandler(this.parameter.toCRS);
            ExpressionBuilder eb = chain.col(affectedColumn).stTransform(sourceCRSHandler.getEPSGCode(), targetCRSHandler.getEPSGCode());
            chain.replaceSelect(affectedColumn, eb, affectedColumn);
            chain.markColumnModified(affectedColumn);
            return chain;
        }
    }
}

