/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;

public class PythonIterator
implements Iterator<PyObject> {
    private final PyObject iterator;
    private PyObject next = null;

    public static PythonIterator of(PyObject obj) {
        try {
            PyObject pythonIterator = obj.__iter__();
            return new PythonIterator(pythonIterator);
        }
        catch (PyException e) {
            if (e.match(Py.TypeError)) {
                throw new IllegalArgumentException("In multirows mode, python's UDF process() must be an iterable object.", e);
            }
            throw e;
        }
    }

    private PythonIterator(PyObject iterator) {
        this.iterator = iterator;
        this.next = this.getNext();
    }

    private PyObject getNext() {
        return this.iterator.__iternext__();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public PyObject next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        PyObject res = this.next;
        this.next = this.getNext();
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

