/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TableSortingService {
    public void prepareSorting(final List<SerializedShakerScript.TableSorting> sorting, MemTable table) {
        if (sorting.size() == 0) {
            return;
        }
        final ArrayList columns = Lists.newArrayList();
        for (SerializedShakerScript.TableSorting s : sorting) {
            MemColumn column = table.getColumn(s.column);
            if (column == null) continue;
            columns.add(column);
        }
        ArrayList rowsToSort = Lists.newArrayList(table.rows);
        Collections.sort(rowsToSort, new Comparator<MemRow>(){

            @Override
            public int compare(MemRow a, MemRow b) {
                for (int i = 0; i < columns.size(); ++i) {
                    int cmp;
                    MemColumn column = (MemColumn)columns.get(i);
                    String va = a.get(column);
                    String vb = b.get(column);
                    if (StringUtils.isBlank((String)va) || StringUtils.isBlank((String)vb)) {
                        cmp = StringUtils.isBlank((String)va) ? (StringUtils.isBlank((String)vb) ? 0 : 1) : -1;
                    } else if (column.selectedType.type.isDouble()) {
                        double ca = column.selectedType.type.doubleValue(va);
                        double cb = column.selectedType.type.doubleValue(vb);
                        cmp = Double.compare(ca, cb);
                    } else {
                        cmp = va.compareTo(vb);
                    }
                    if (!((SerializedShakerScript.TableSorting)sorting.get((int)i)).ascending) {
                        cmp = -cmp;
                    }
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        });
        table.rows = rowsToSort;
    }
}

