/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.text;

import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.utils.ErrorContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StringMatchingMode implements Labelled
{
    FULL_STRING{

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            return StringMatchingMode.translate(language, "SHAKER.TEXT.MATCHING_MODE.COMPLETE", "Complete value");
        }
    }
    ,
    SUBSTRING{

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            return StringMatchingMode.translate(language, "SHAKER.TEXT.MATCHING_MODE.SUBSTRING", "Substring");
        }
    }
    ,
    PATTERN{

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            return StringMatchingMode.translate(language, "SHAKER.TEXT.MATCHING_MODE.REGEX", "Regular expression");
        }
    };

    public static final String PARAM_KEY = "mode";

    public static StringMatchingMode forName(String mode) {
        try {
            return StringMatchingMode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw ErrorContext.iaef((String)"Unknown String matching mode: %s - Expected 'full_string', 'substring' or 'pattern'", (Object)mode, (Object[])new Object[0]);
        }
    }

    public static StringMatchingMode forName(String mode, StringMatchingMode defaultValue) {
        if (mode == null) {
            return defaultValue;
        }
        return StringMatchingMode.forName(mode);
    }

    public static String[] getChoiceValues() {
        return new String[]{"full_string", "substring", "pattern"};
    }

    public static String[] getChoiceLabels() {
        return new String[]{"Complete value", "Substring", "Regular expression"};
    }

    private static String translate(String lang, String id, String defaultValue) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return ts.translate(lang, id, defaultValue, new Object[0]);
    }
}

