/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.submit;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.spark.submit.SparkKubernetesSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.spark.yarnaware.SparkYarnAwareJobHelper;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SparkSubmitHelper
extends SparkYarnAwareJobHelper<SparkSubmitJob> {
    protected final SparkExecutionConfig usedExecutionConfig;
    public static final String ARBITRARY_ARGUMENT_KEY = "dku.sparkSubmitArgs";
    protected static final String[] IVY_RUN_CONFS = new String[]{"backend-run", "common-run"};
    protected static final FilenameFilter JAR_FILES = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    };
    protected String k8sClusterIdInformationalOnly;
    private static Logger logger = Logger.getLogger((String)"dku.spark.submit.helper");

    public static SparkSubmitHelper build(String projectKey, AuthCtx authCtx, SparkSettings sparkSettings, HadoopSettings hadoopSettings, UserImpersonationTarget impersonationTarget, SparkExecutionConfig usedExecutionConfig) {
        if (SparkSubmitHelper.runsOnKubernetes(usedExecutionConfig)) {
            return new SparkKubernetesSubmitHelper(projectKey, authCtx, sparkSettings, hadoopSettings, impersonationTarget, usedExecutionConfig);
        }
        return new SparkSubmitHelper(projectKey, authCtx, sparkSettings, hadoopSettings, impersonationTarget, usedExecutionConfig);
    }

    public static boolean runsOnKubernetes(SparkExecutionConfig sec) {
        if (sec == null) {
            return false;
        }
        if (sec.kubernetesSettings.managedKubernetes) {
            return true;
        }
        for (ClusterProperty kv : sec.conf) {
            if (StringUtils.equals((String)kv.key, (String)"spark.master") && StringUtils.isNotBlank((String)kv.value) && kv.value.startsWith("k8s://")) {
                return true;
            }
            if (!ARBITRARY_ARGUMENT_KEY.equals(kv.key)) continue;
            boolean prevIsMaster = false;
            for (String arg : SparkSubmitHelper.splitDkuArgs(kv.value)) {
                if (prevIsMaster && StringUtils.isNotBlank((String)arg) && arg.startsWith("k8s://")) {
                    return true;
                }
                prevIsMaster = "--master".equals(arg);
            }
        }
        return false;
    }

    protected SparkSubmitHelper(String projectKey, AuthCtx authCtx, SparkSettings sparkSettings, HadoopSettings hadoopSettings, UserImpersonationTarget impersonationTarget, SparkExecutionConfig usedExecutionConfig) {
        super(projectKey, authCtx, sparkSettings, hadoopSettings, impersonationTarget);
        this.usedExecutionConfig = usedExecutionConfig;
    }

    public void setK8SClusterId(String k8sClusterIdInformationalOnly) {
        this.k8sClusterIdInformationalOnly = k8sClusterIdInformationalOnly;
    }

    protected static String getSparkSubmitFromSparkHome(SparkSettings ss) {
        File expectedSparkSubmit = new File(ss.sparkHome, "/bin/spark-submit");
        File expectedSpark2Submit = new File(ss.sparkHome, "/bin/spark2-submit");
        if (!expectedSparkSubmit.exists() && expectedSpark2Submit.exists()) {
            throw new IllegalArgumentException("Spark2 is no longer supported, please upgrade Spark to 3.x");
        }
        return ss.sparkHome + "/bin/spark-submit";
    }

    public static String getSparkVersion(SparkSettings ss) {
        String sparkVersion = null;
        if (ss != null && StringUtils.isNotBlank((String)ss.sparkHome)) {
            try {
                DKUtils.ExecutionResults versionOutput = DKUtils.execAndGetOutputAndErrors((String[])new String[]{SparkSubmitHelper.getSparkSubmitFromSparkHome(ss), "--version"}, null);
                if (versionOutput.rv != 0) {
                    throw new Exception("Spark-submit didn't respond to --version (return code=" + versionOutput.rv + ")");
                }
                Pattern versionPattern = Pattern.compile("^.* version ([^ ]*)$");
                for (String line : (versionOutput.out + versionOutput.err).split("\n")) {
                    Matcher versionMatcher = versionPattern.matcher(line);
                    if (!versionMatcher.matches()) continue;
                    sparkVersion = versionMatcher.group(1);
                }
                logger.info((Object)"Failed to find version in spark-submit output, assuming same as one from install-spark-integration");
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to get version from spark-submit, assuming same as one from install-spark-integration", (Throwable)e);
            }
        }
        return StringUtils.defaultIfBlank(sparkVersion, (String)SPARK_VERSION);
    }

    private String getCommand() {
        if (this.sparkSettings != null && StringUtils.isNotBlank((String)this.sparkSettings.sparkHome)) {
            return SparkSubmitHelper.getSparkSubmitFromSparkHome(this.sparkSettings);
        }
        String dkuSparkHome = System.getenv("DKU_SPARK_HOME");
        if (StringUtils.isNotBlank((String)dkuSparkHome)) {
            return dkuSparkHome + "/bin/spark-submit";
        }
        return "spark-submit";
    }

    public String getJars(boolean withJetty, boolean withSparklingWater) {
        List<File> cleanedJars = this.getJarsList(withJetty, withSparklingWater);
        return StringUtils.join(cleanedJars, (String)",");
    }

    public SparkExecutionConfig.SparklyrConfig getSparklyrConfig(SparkOverrideConfig soc) throws IOException, DKUSecurityException {
        SparkExecutionConfig.SparklyrConfig ret = new SparkExecutionConfig.SparklyrConfig();
        if (!this.sparkSettings.sparkEnabled) {
            throw ErrorContext.iae((String)"Cannot resolve Spark configuration: Spark is not enabled on this DSS instance");
        }
        SparkExecutionConfig parentConfig = this.sparkSettings.getByName(soc.inheritConf);
        for (ClusterProperty base : parentConfig.conf) {
            if (StringUtils.isBlank((String)base.key)) continue;
            ret.conf.put(base.key, base.value == null ? "" : base.value);
        }
        for (SimpleKeyValue overriden : soc.conf) {
            if (StringUtils.isBlank((String)overriden.key)) continue;
            ret.conf.put(overriden.key, overriden.value == null ? "" : overriden.value);
        }
        for (File f : this.getJarsList(false, false)) {
            ret.jars.add(f.getAbsolutePath());
        }
        return ret;
    }

    @Override
    protected List<File> getJarsList(String scalaVersion, String sparkVersion, boolean withJetty, boolean withSparklingWater) {
        return this.getJarsList(scalaVersion, sparkVersion, withJetty, withSparklingWater, true);
    }

    @Override
    public void buildCommandArgs(SparkSubmitJob ret, Map<String, String> conf) {
        for (Map.Entry<String, String> r : conf.entrySet()) {
            this.buildCommandArg(ret, new SimpleKeyValue(r.getKey(), r.getValue()));
        }
    }

    public void buildCommandArgs(SparkSubmitJob ret, ClusterPropertyList conf) {
        for (ClusterProperty kv : conf) {
            this.buildCommandArg(ret, new SimpleKeyValue(kv.key, kv.value));
        }
    }

    @Override
    public void buildCommandArgs(SparkSubmitJob ret, List<SimpleKeyValue> conf) {
        for (SimpleKeyValue kv : conf) {
            this.buildCommandArg(ret, kv);
        }
    }

    private void buildCommandArg(SparkSubmitJob ret, SimpleKeyValue r) {
        if (ARBITRARY_ARGUMENT_KEY.equals(r.key)) {
            for (String arg : SparkSubmitHelper.splitDkuArgs(r.value)) {
                ret.submitArgs.add(arg);
            }
        } else {
            ret.conf.add(r);
        }
    }

    private static List<String> splitDkuArgs(String value) {
        ArrayList ret = Lists.newArrayList();
        for (String arg : value.split("(?<!\\\\) ")) {
            ret.add(arg.replace("\\\\", "\\").replace("\\ ", " "));
        }
        return ret;
    }

    @Override
    protected SparkSubmitJob newSparkJob() {
        SparkSubmitJob sparkJob = new SparkSubmitJob();
        sparkJob.sparkSubmitCmd.add(this.getCommand());
        return sparkJob;
    }

    @Override
    public String getSparkVersionFromSettings() {
        return SparkSubmitHelper.getSparkVersion(this.sparkSettings);
    }

    public List<String> toCommand(SparkSubmitJob job) throws IOException {
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.addAll(job.sparkSubmitCmd);
        if (!job.conf.isEmpty()) {
            VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getGlobalContext();
            for (SimpleKeyValue kv : job.conf) {
                cmdline.add("--conf");
                cmdline.add(kv.key + "=" + vc.expandAllowUnresolved(kv.value));
            }
        }
        cmdline.addAll(job.submitArgs);
        cmdline.add("--jars");
        cmdline.add(StringUtils.join((Collection)job.jars, (String)","));
        if (!job.pyFiles.isEmpty()) {
            cmdline.add("--py-files");
            cmdline.add(StringUtils.join((Collection)job.pyFiles, (String)","));
        }
        if (!job.nonSecretGlobalFiles.isEmpty() || !job.secretDriverFiles.isEmpty()) {
            cmdline.add("--files");
            ArrayList concat = new ArrayList();
            concat.addAll(job.nonSecretGlobalFiles);
            concat.addAll(job.secretDriverFiles);
            cmdline.add(StringUtils.join(concat, (String)","));
        }
        if (StringUtils.isNotBlank((String)job.className)) {
            cmdline.add("--class");
            cmdline.add(job.className);
        }
        cmdline.add(job.file);
        cmdline.addAll(job.args);
        return cmdline;
    }

    @Override
    public boolean runsInClusterMode(SparkSubmitJob job) {
        ArrayList conf = Lists.newArrayList((Iterable)job.conf);
        boolean lastWasMaster = false;
        boolean lastWasDeployMode = false;
        for (String arg : job.sparkSubmitCmd) {
            if ("--master".equals(arg)) {
                lastWasMaster = true;
            }
            if ("--deploy-mode".equals(arg)) {
                lastWasDeployMode = true;
            }
            if (lastWasMaster) {
                conf.add(new SimpleKeyValue("spark.master", arg));
                lastWasMaster = false;
            }
            if (!lastWasDeployMode) continue;
            conf.add(new SimpleKeyValue("spark.submit.deployMode", arg));
            lastWasDeployMode = false;
        }
        if (this.usedExecutionConfig.kubernetesSettings.managedKubernetes) {
            conf.add(new SimpleKeyValue("spark.master", "k8s://"));
        }
        return super.runsInClusterMode(conf);
    }

    @Override
    protected void adjustEnvVars(EnvironmentStash stash) {
        stash.env.remove("HADOOP_TOKEN_FILE_LOCATION");
        HadoopLoader.addTicketCacheEnvVar(stash.env);
    }

    @Override
    protected void setupProxyUser(SparkSubmitJob job, String userName, boolean impersonated) {
        if (impersonated) {
            logger.info((Object)("Add Spark proxy user : " + userName));
            job.submitArgs.addAll(Lists.newArrayList((Object[])new String[]{"--proxy-user", userName}));
        } else if (this.hadoopSettings.kerberosLoginEnabled) {
            logger.info((Object)"Add Kerberos keytab and principal for DSS");
            job.submitArgs.addAll(Lists.newArrayList((Object[])new String[]{"--principal", this.hadoopSettings.dssPrincipal}));
            job.submitArgs.addAll(Lists.newArrayList((Object[])new String[]{"--keytab", this.hadoopSettings.dssKeytabPath}));
        }
    }

    @Override
    protected Closeable createAdditionalContextElement(SparkSubmitJob job, SparkJobHelper.RunMode runMode, File runDir, CodeEnvModel.UsedCodeEnvRef codeEnvRef, EnvironmentStash stash, boolean isCluster) throws IOException, InterruptedException {
        return null;
    }

    @Override
    protected void cleanupConf(SparkSubmitJob job, boolean isYarnCluster) {
        super.cleanupConf(job, isYarnCluster);
        if (!isYarnCluster) {
            if (job.hasConfKey("spark.driver.defaultJavaOptions", "spark.driver.extraJavaOptions")) {
                logger.info((Object)"Java options of the driver manually specified, not adding defaults for tuning the GC");
            } else {
                int numCores = Runtime.getRuntime().availableProcessors();
                int numThreads = Math.max(2, Math.min(8, numCores / 4));
                job.conf.add(new SimpleKeyValue("spark.driver.extraJavaOptions", "-XX:ParallelGCThreads=" + numThreads));
            }
        }
    }
}

