/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.util.ReflectionUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.org.joda.time.Chronology;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalTime;
import com.dataiku.dss.shadelib.org.joda.time.chrono.ISOChronology;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class BigQuerySimbaAvroReader {
    private static final int DEFAULT_BIG_DECIMAL_SCALE = 9;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.simba.avro");

    public static JsonElement readArray(Object object) throws ReflectiveOperationException {
        return BigQuerySimbaAvroReader.readObject(object, BigQueryType.ARRAY);
    }

    public static JsonElement readStruct(Object object) throws ReflectiveOperationException {
        return BigQuerySimbaAvroReader.readObject(object, BigQueryType.STRUCT);
    }

    private static JsonElement readObject(Object object, BigQueryType sqlType) throws ReflectiveOperationException {
        JsonObject result = new JsonObject();
        result.add("v", BigQuerySimbaAvroReader.readElement(object, sqlType));
        return result;
    }

    private static JsonElement readElement(Object object, BigQueryType sqlType) throws ReflectiveOperationException {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        switch (sqlType) {
            case ARRAY: {
                return BigQuerySimbaAvroReader.readArrayElement(object);
            }
            case STRUCT: {
                return BigQuerySimbaAvroReader.readStructElement(object);
            }
            case TIMESTAMP: {
                return new JsonPrimitive(BigQuerySimbaAvroReader.formatTimestamp((Long)object));
            }
            case TIME: {
                return new JsonPrimitive(BigQuerySimbaAvroReader.formatTime((Long)object));
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return new JsonPrimitive(BigQuerySimbaAvroReader.formatDecimal(object, sqlType));
            }
            case DATE: {
                return new JsonPrimitive(BigQuerySimbaAvroReader.formatDate((Integer)object));
            }
            case BYTES: {
                return new JsonPrimitive(BigQuerySimbaAvroReader.formatBytes((ByteBuffer)object));
            }
            case BOOLEAN: {
                return new JsonPrimitive(Boolean.valueOf(BigQuerySimbaAvroReader.formatBoolean(object)));
            }
        }
        return new JsonPrimitive(object.toString());
    }

    private static JsonElement readArrayElement(Object array) throws ReflectiveOperationException {
        if (array == null) {
            return JsonNull.INSTANCE;
        }
        Object schema = ReflectionUtils.invokeMethod(array, "getSchema", new Object[0]);
        Object elementType = ReflectionUtils.invokeMethod(schema, "getElementType", new Object[0]);
        BigQueryType bqType = new BigQueryTypeInferrer(elementType).getSQLType();
        Iterator iterator = (Iterator)ReflectionUtils.invokeMethod(array, "iterator", new Object[0]);
        JsonArray result = new JsonArray();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            result.add((JsonElement)(next != null ? BigQuerySimbaAvroReader.readObject(next, bqType) : JsonNull.INSTANCE));
        }
        return result;
    }

    private static JsonElement readStructElement(Object indexedRecord) throws ReflectiveOperationException {
        if (indexedRecord == null) {
            return JsonNull.INSTANCE;
        }
        JsonArray jsonArray = new JsonArray();
        List fields = ReflectionUtils.invokeMethod(List.class, ReflectionUtils.invokeMethod(Object.class, indexedRecord, "getSchema", new Object[0]), "getFields", new Object[0]);
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            Object schema = ReflectionUtils.invokeMethod(Object.class, fields.get(i), "schema", new Object[0]);
            BigQueryType bqType = new BigQueryTypeInferrer(schema).getSQLType();
            Object fieldValue = ReflectionUtils.getMethod(indexedRecord.getClass(), "get", Integer.TYPE).invoke(indexedRecord, i);
            jsonArray.add(BigQuerySimbaAvroReader.readObject(fieldValue, bqType));
        }
        JsonObject result = new JsonObject();
        result.add("f", (JsonElement)jsonArray);
        return result;
    }

    private static boolean formatBoolean(Object object) {
        return "true".equalsIgnoreCase(object.toString());
    }

    private static String formatBytes(ByteBuffer object) {
        return BaseEncoding.base64().encode(object.array());
    }

    private static String formatTimestamp(long value) {
        return DKUDateUtils.isoFormatUTC((long)(value / 1000L));
    }

    private static String formatDate(int daysSinceEpoch) {
        return new LocalDate(0L).plusDays(daysSinceEpoch).toString();
    }

    private static String formatTime(long value) {
        LocalTime localTime = new LocalTime(value / 1000L, (Chronology)ISOChronology.getInstanceUTC());
        return localTime.toString();
    }

    private static String formatDecimal(Object object, BigQueryType sqlType) {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        byteBuffer.position(0);
        byte[] payload = new byte[byteBuffer.remaining()];
        byteBuffer.get(payload);
        return new BigDecimal(new BigInteger(payload), sqlType == BigQueryType.BIGNUMERIC ? 38 : 9).toString();
    }

    private static enum BigQueryType {
        BOOLEAN,
        INT64,
        FLOAT64,
        BYTES,
        STRING,
        DATE,
        DATETIME,
        TIMESTAMP,
        TIME,
        NUMERIC,
        BIGNUMERIC,
        GEOGRAPHY,
        ARRAY,
        STRUCT;

    }

    private static class BigQueryTypeInferrer {
        private final Object typeHolder;
        private final Object elementType;

        public BigQueryTypeInferrer(Object schema) throws ReflectiveOperationException {
            Object type = ReflectionUtils.invokeMethod(schema, "getType", new Object[0]);
            if (type == null) {
                throw new IllegalArgumentException("Invalid schema. getType() returned null");
            }
            if ("UNION".equalsIgnoreCase(type.toString())) {
                List types = ReflectionUtils.invokeMethod(List.class, schema, "getTypes", new Object[0]);
                if (types.size() != 2) {
                    throw new IllegalArgumentException(String.format("Invalid schema. getTypes() for an UNION returned %d items instead of the expected 2.", types.size()));
                }
                this.typeHolder = types.get(1);
                this.elementType = ReflectionUtils.invokeMethod(this.typeHolder, "getType", new Object[0]);
            } else {
                this.elementType = type;
                this.typeHolder = schema;
            }
        }

        public BigQueryType getSQLType() throws ReflectiveOperationException {
            String avroLogicalTypeName = this.retrieveLogicalTypeName();
            String avroTypeName = this.elementType.toString().toLowerCase(Locale.ENGLISH);
            return this.retrieveSQLType(avroTypeName, avroLogicalTypeName);
        }

        private BigQueryType retrieveSQLType(String avroTypeName, @Nullable String avroLogicalTypeName) throws ReflectiveOperationException {
            switch (avroTypeName.toLowerCase(Locale.ROOT)) {
                case "boolean": {
                    return BigQueryType.BOOLEAN;
                }
                case "long": {
                    if ("timestamp-micros".equals(avroLogicalTypeName) || "timestamp-millis".equals(avroLogicalTypeName)) {
                        return BigQueryType.TIMESTAMP;
                    }
                    if ("time-micros".equals(avroLogicalTypeName) || "time-millis".equals(avroLogicalTypeName)) {
                        return BigQueryType.TIME;
                    }
                    return BigQueryType.INT64;
                }
                case "double": {
                    return BigQueryType.FLOAT64;
                }
                case "bytes": {
                    if ("decimal".equals(avroLogicalTypeName)) {
                        return this.getScale() > 9 ? BigQueryType.BIGNUMERIC : BigQueryType.NUMERIC;
                    }
                    return BigQueryType.BYTES;
                }
                case "string": {
                    if ("datetime".equals(avroLogicalTypeName)) {
                        return BigQueryType.DATETIME;
                    }
                    if ("geography".equals(avroLogicalTypeName)) {
                        return BigQueryType.GEOGRAPHY;
                    }
                    return BigQueryType.STRING;
                }
                case "int": {
                    if ("date".equals(avroLogicalTypeName)) {
                        return BigQueryType.DATE;
                    }
                    throw new IllegalArgumentException("Unexpected avro type \"" + avroTypeName + "\" with logical type \"" + avroLogicalTypeName + "\"");
                }
                case "array": {
                    return BigQueryType.ARRAY;
                }
                case "record": {
                    return BigQueryType.STRUCT;
                }
            }
            throw new IllegalArgumentException("Unexpected avro type: " + avroTypeName);
        }

        private String retrieveLogicalTypeName() {
            String result = null;
            try {
                Object logicalType = ReflectionUtils.invokeMethod(this.typeHolder, "getLogicalType", new Object[0]);
                if (logicalType != null) {
                    result = ReflectionUtils.invokeMethod(String.class, logicalType, "getName", new Object[0]);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (result == null) {
                try {
                    result = (String)this.getObjectProp("logicalType");
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return result;
        }

        private Object getObjectProp(String name) throws ReflectiveOperationException {
            return ReflectionUtils.invokeMethod(this.typeHolder, "getObjectProp", name);
        }

        private int getScale() throws ReflectiveOperationException {
            Object scaleRaw = this.getObjectProp("scale");
            if (scaleRaw == null) {
                return 9;
            }
            if (scaleRaw instanceof Number) {
                return ((Number)scaleRaw).intValue();
            }
            try {
                return Integer.parseInt(scaleRaw.toString());
            }
            catch (RuntimeException e) {
                logger.info((Object)("Unable to parse scale from avro schema: " + String.valueOf(scaleRaw)), (Throwable)e);
                return 9;
            }
        }
    }
}

