/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.theming.model;

import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import com.dataiku.dip.theming.model.ThemeColors;
import com.dataiku.dip.theming.model.ThemePalette;
import com.dataiku.dip.theming.model.TileFormatting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DSSBuiltinThemesRegistry {
    private final Map<String, DSSVisualizationTheme> registry = new HashMap<String, DSSVisualizationTheme>();
    private final ThemeColors themePaletteColors;

    public DSSBuiltinThemesRegistry(ThemeColors themePaletteColors) {
        this.themePaletteColors = themePaletteColors;
        DSSVisualizationTheme defaultTheme = this.createDefaultVisualizationTheme();
        DSSVisualizationTheme deuteranopia = this.deriveTheme(defaultTheme, "__dku_deuteranopia1__", "Deuteranopia", ThemeColors.ThemeColorId.dku_deuteranopia1);
        DSSVisualizationTheme tritanopia = this.deriveTheme(defaultTheme, "__dku_tritanopia1__", "Tritanopia", ThemeColors.ThemeColorId.dku_tritanopia1);
        DSSVisualizationTheme pastel1 = this.deriveTheme(defaultTheme, "__dku_pastel1__", "Pastel", ThemeColors.ThemeColorId.dku_pastel1);
        this.registry.put(defaultTheme.getId(), defaultTheme);
        this.registry.put(deuteranopia.getId(), deuteranopia);
        this.registry.put(tritanopia.getId(), tritanopia);
        this.registry.put(pastel1.getId(), pastel1);
    }

    public DSSVisualizationTheme get(String key) {
        return this.registry.get(key);
    }

    public boolean has(String key) {
        return this.registry.containsKey(key);
    }

    public Map<String, DSSVisualizationTheme> getAll() {
        return Collections.unmodifiableMap(this.registry);
    }

    private DSSVisualizationTheme createDefaultVisualizationTheme() {
        DSSVisualizationTheme defaultTheme = new DSSVisualizationTheme();
        defaultTheme.setId("__dku_dss_default_theme__");
        defaultTheme.setName("Default");
        String[] discreteThemePaletteColors = Objects.requireNonNull(this.themePaletteColors.getThemeColors(ThemeColors.ThemeColorId.default_theme));
        defaultTheme.setColors(discreteThemePaletteColors);
        ThemePalette discreteThemePalette = ThemePalette.createWithThemeColors(ThemePalette.ThemePaletteType.DISCRETE, ThemeColors.ThemeColorId.default_theme.toString(), null, null, ThemeColors.ThemeColorId.default_theme, this.themePaletteColors, false);
        ThemePalette continuousThemePalette = ThemePalette.createWithThemeColors(ThemePalette.ThemePaletteType.CONTINUOUS, ThemeColors.ThemeColorId.default_theme.toString(), null, null, ThemeColors.ThemeColorId.default_theme, this.themePaletteColors, false);
        ThemePalette divergingThemePalette = ThemePalette.createWithThemeColors(ThemePalette.ThemePaletteType.DIVERGING, ThemeColors.ThemeColorId.default_theme.toString(), null, null, ThemeColors.ThemeColorId.default_theme, this.themePaletteColors, false);
        defaultTheme.setThemePalettes(new DSSVisualizationTheme.ThemePalettes(discreteThemePalette, new ThemePalette[]{continuousThemePalette, continuousThemePalette.createRevThemePalette()}, divergingThemePalette));
        defaultTheme.setPalettes(new DSSVisualizationTheme.SelectedPalettes(discreteThemePalette.id, continuousThemePalette.id, divergingThemePalette.id));
        ChartDef.TextFormattingOptions generalFormatting = new ChartDef.TextFormattingOptions();
        generalFormatting.setFontSize(11);
        generalFormatting.setFontColor("#333333");
        generalFormatting.setHasBackground(false);
        generalFormatting.setFontFamily("SourceSansPro");
        defaultTheme.setGeneralFormatting(generalFormatting);
        ChartDef.TextFormattingOptions pageTitleFormatting = new ChartDef.TextFormattingOptions();
        pageTitleFormatting.setFontSize(28);
        pageTitleFormatting.setFontColor("#444444");
        pageTitleFormatting.setHasBackground(false);
        defaultTheme.setPageTitleFormatting(pageTitleFormatting);
        ChartDef.TextFormattingOptions tileTitleFormatting = new ChartDef.TextFormattingOptions();
        tileTitleFormatting.setFontSize(13);
        tileTitleFormatting.setFontColor("#000000");
        tileTitleFormatting.setHasBackground(false);
        defaultTheme.setTileTitleFormatting(tileTitleFormatting);
        ChartDef.TextFormattingOptions chartTitleFormatting = new ChartDef.TextFormattingOptions();
        chartTitleFormatting.setFontSize(15);
        chartTitleFormatting.setFontColor("#333333");
        chartTitleFormatting.setHasBackground(false);
        defaultTheme.setChartTitleFormatting(chartTitleFormatting);
        ChartDef.TextFormattingOptions legendFormatting = new ChartDef.TextFormattingOptions();
        legendFormatting.setFontSize(11);
        legendFormatting.setFontColor("#333333");
        legendFormatting.setHasBackground(false);
        defaultTheme.setLegendFormatting(legendFormatting);
        TileFormatting tileFormatting = new TileFormatting();
        tileFormatting.setBackgroundOpacity(1.0f);
        Tile.BorderOptions borderOptions = new Tile.BorderOptions();
        borderOptions.setColor("#CCCCCC");
        borderOptions.setRadius(0);
        borderOptions.setSize(1);
        tileFormatting.setBorderOptions(borderOptions);
        defaultTheme.setTileFormatting(tileFormatting);
        defaultTheme.setPageTitleAlignment("CENTER");
        defaultTheme.setBackgroundColor("#FFFFFF");
        defaultTheme.setTileSpacing(8);
        defaultTheme.setIsCustomized(false);
        defaultTheme.setIsBuiltIn(true);
        return defaultTheme;
    }

    private DSSVisualizationTheme deriveTheme(DSSVisualizationTheme baseTheme, String id, String name, ThemeColors.ThemeColorId themeColorId) {
        DSSVisualizationTheme theme = new DSSVisualizationTheme();
        theme.setId(id);
        theme.setName(name);
        String[] discreteThemePaletteColors = Objects.requireNonNull(this.themePaletteColors.getThemeColors(themeColorId));
        theme.setColors(discreteThemePaletteColors);
        ThemePalette discreteThemePalette = ThemePalette.createWithThemeColors(ThemePalette.ThemePaletteType.DISCRETE, null, null, null, themeColorId, this.themePaletteColors, false);
        ThemePalette continuousThemePalette = ThemePalette.createWithThemeColors(ThemePalette.ThemePaletteType.CONTINUOUS, null, null, null, themeColorId, this.themePaletteColors, false);
        ThemePalette divergingThemePalette = ThemePalette.createWithThemeColors(ThemePalette.ThemePaletteType.DIVERGING, null, null, null, themeColorId, this.themePaletteColors, false);
        theme.setThemePalettes(new DSSVisualizationTheme.ThemePalettes(discreteThemePalette, new ThemePalette[]{continuousThemePalette, continuousThemePalette.createRevThemePalette()}, divergingThemePalette));
        theme.setPalettes(new DSSVisualizationTheme.SelectedPalettes(discreteThemePalette.id, continuousThemePalette.id, divergingThemePalette.id));
        theme.setGeneralFormatting(baseTheme.getGeneralFormatting());
        theme.setPageTitleFormatting(baseTheme.getPageTitleFormatting());
        theme.setTileTitleFormatting(baseTheme.getTileTitleFormatting());
        theme.setChartTitleFormatting(baseTheme.getChartTitleFormatting());
        theme.setLegendFormatting(baseTheme.getLegendFormatting());
        theme.setTileFormatting(baseTheme.getTileFormatting());
        theme.setPageTitleAlignment(baseTheme.getPageTitleAlignment());
        theme.setBackgroundColor(baseTheme.getBackgroundColor());
        theme.setTileSpacing(baseTheme.getTileSpacing());
        theme.setIsCustomized(baseTheme.isCustomized());
        theme.setIsBuiltIn(baseTheme.isBuiltIn());
        return theme;
    }
}

