/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.TimelineItemEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.timelines.ProjectTimeline;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimelinesService {
    private static final boolean SEND_NOTIFICATION = true;
    private static long MAX_TIME_DIFF_TO_COLLAPSE = 43200000L;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    @Autowired
    private EnrichmentService enrichmentService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    public TimelinesService() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void push(TimelineItem ti) throws CodedSQLException {
        this.push(ti, true);
    }

    public void pushWithoutNotification(TimelineItem ti) throws CodedSQLException {
        this.push(ti, false);
    }

    private void push(TimelineItem ti, boolean sendNotification) throws CodedSQLException {
        this.updateTimelineDB(ti);
        if (!sendNotification) {
            return;
        }
        this.pubSub.publish(new TimelineItemEvent(ti));
    }

    private void updateTimelineDB(TimelineItem ti) throws CodedSQLException {
        TimelineItem latest = this.timelinesDB.getLatestForObject(ti.objectType, ti.projectKey, ti.objectId);
        if (this.collapse(ti, latest)) {
            logger.debug((Object)("Collapse timeline item " + String.valueOf((Object)ti.action) + " (projectKey=" + ti.projectKey + " objectId=" + ti.objectId + ")"));
            this.timelinesDB.update(ti);
        } else {
            logger.debug((Object)("Add timeline item " + String.valueOf((Object)ti.action) + " (projectKey=" + ti.projectKey + " objectId=" + ti.objectId + ")"));
            this.timelinesDB.insert(ti);
        }
    }

    public TimelineWithVersioning getObjectTimeline_NT(TaggableObjectsService.TaggableObject object, int from, int limit) {
        return this.getObjectTimeline_NT(object.getTaggableType(), object.getProjectKey(), object.getId(), object.creationTag, object.versionTag, from, limit);
    }

    public TimelineWithVersioning getObjectTimeline_NT(ITaggingService.TaggableType objectType, String projectKey, String objectId, VersionTag creationTag, VersionTag versionTag, int from, int limit) {
        try {
            TimelineWithVersioning ret = new TimelineWithVersioning();
            ret.items = this.timelinesDB.getForObject(objectType, projectKey, objectId, from, limit);
            List<String> contributors = this.timelinesDB.getContributorsForObject(objectType, projectKey, objectId);
            TimelineItem firstForObject = this.timelinesDB.getFirstForObject(objectType, projectKey, objectId);
            try (Transaction t = this.transactionService.beginRead();){
                JupyterService jupyterService;
                JupyterUtils.JupyterNotebookListEntry notebook;
                for (TimelineItem ti : ret.items) {
                    try {
                        this.enrichmentService.enrich(ti);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to enrich timeline item", (Throwable)e);
                    }
                }
                if (!ret.items.isEmpty()) {
                    this.updateTimelineWithModifiedAndCreation(ret, firstForObject);
                } else if (objectType == ITaggingService.TaggableType.JUPYTER_NOTEBOOK && (notebook = (jupyterService = (JupyterService)SpringUtils.getBean(JupyterService.class)).getOrNullUnsafe(projectKey, objectId)) != null) {
                    ret.lastModifiedOn = notebook.lastModifiedOn;
                    if (notebook.creationTag != null) {
                        ret.createdOn = notebook.creationTag.getLastModifiedOn();
                    }
                    if (!StringUtils.isBlank((String)notebook.creator)) {
                        ret.createdBy = this.usersService.getPublicUser(notebook.creator);
                    }
                    if (notebook.versionTag != null && !StringUtils.isBlank((String)notebook.versionTag.getLastAuthor())) {
                        ret.lastModifiedBy = this.usersService.getPublicUser(notebook.versionTag.getLastAuthor());
                    }
                }
                if ((ret.createdBy == null || ret.createdBy.login == null) && creationTag != null) {
                    ret.createdBy = this.usersService.getPublicUser(creationTag.getLastAuthor());
                }
                if ((ret.lastModifiedBy == null || ret.lastModifiedBy.login == null) && versionTag != null) {
                    ret.lastModifiedBy = this.usersService.getPublicUser(versionTag.getLastAuthor());
                }
                for (String login : contributors) {
                    ret.allContributors.add(this.usersService.getPublicUser(login));
                }
            }
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get object timeline ", (Throwable)e);
            return new TimelineWithVersioning();
        }
    }

    public ProjectTimeline getProjectTimeLineForExport_NT(String projectKey) throws CodedSQLException {
        return this.timelinesDB.getForProjectExport(projectKey);
    }

    public TimelineWithVersioning getProjectTimeline_NT(String projectKey, int from, int limit) throws CodedSQLException, IOException {
        TimelineWithVersioning ret = this.timelinesDB.getForProject(projectKey, from, limit);
        List<String> contributors = this.timelinesDB.getContributors(projectKey);
        TimelineItem firstForObject = this.timelinesDB.getFirstForObject(ITaggingService.TaggableType.PROJECT, projectKey, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            for (TimelineItem ti : ret.items) {
                try {
                    this.enrichmentService.enrich(ti);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to enrich timeline item", (Throwable)e);
                }
            }
            this.updateTimelineWithModifiedAndCreation(ret, firstForObject);
            for (String login : contributors) {
                ret.allContributors.add(this.usersService.getPublicUser(login));
            }
        }
        return ret;
    }

    public TimelineWithVersioning getWikiTimeline_NT(String projectKey, int from, int limit) throws CodedSQLException, IOException {
        TimelineWithVersioning ret = this.timelinesDB.getForWiki(projectKey, from, limit);
        List<String> contributors = this.timelinesDB.getContributorsForWiki(projectKey);
        TimelineItem firstForObject = this.timelinesDB.getFirstForObject(ITaggingService.TaggableType.ARTICLE, projectKey, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            for (TimelineItem ti : ret.items) {
                try {
                    this.enrichmentService.enrich(ti);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to enrich timeline item", (Throwable)e);
                }
            }
            this.updateTimelineWithModifiedAndCreation(ret, firstForObject);
            for (String login : contributors) {
                ret.allContributors.add(this.usersService.getPublicUser(login));
            }
        }
        return ret;
    }

    public Map<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> getCreationAndUpdateInfoForAllObjects(List<String> projectKeys) {
        try {
            return this.timelinesDB.getCreationAndUpdateInfoForAllObjects(projectKeys);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read timeline", (Throwable)e);
            return new HashMap<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo>();
        }
    }

    public HeadWithVersioningInfo getCreationAndUpdateInfo(TaggableObjectsService.TaggableObjectRef tor) {
        HeadWithVersioningInfo head = new HeadWithVersioningInfo();
        try {
            TimelineItem first = this.timelinesDB.getFirstForObject(tor.type, tor.projectKey, tor.id);
            TimelineItem latest = this.timelinesDB.getLatestForObject(tor.type, tor.projectKey, tor.id);
            head.createdBy = new PublicUser();
            if (first != null) {
                head.createdBy.login = first.user;
                head.createdOn = first.time;
            }
            head.lastModifiedBy = new PublicUser();
            if (latest != null) {
                head.lastModifiedBy.login = latest.user;
                head.lastModifiedOn = latest.time;
                if (first == null) {
                    head.createdOn = latest.time;
                    head.createdBy.login = latest.user;
                }
            } else if (first == null) {
                logger.errorV("Failed to read timeline for object %s in project %s", new Object[]{tor.id, tor.projectKey});
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read timeline", (Throwable)e);
        }
        return head;
    }

    public TimelineItem getFirstForObjectNoCache(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        try {
            return this.timelinesDB.getFirstForObjectNoCache(objectType, projectKey, objectId);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read timeline", (Throwable)e);
            return null;
        }
    }

    public TimelineItem getFirstForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        try {
            return this.timelinesDB.getFirstForObject(objectType, projectKey, objectId);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read timeline", (Throwable)e);
            return null;
        }
    }

    public TimelineItem getLatestForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        try {
            return this.timelinesDB.getLatestForObject(objectType, projectKey, objectId);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read timeline", (Throwable)e);
            return null;
        }
    }

    public Pair<TimelineItem, TimelineItem> getLatestForProjectAndLatestForProjectAndUser(String projectKey, String user) {
        try {
            return this.timelinesDB.getLatestForProjectAndLatestForProjectAndUser(projectKey, user);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read timeline", (Throwable)e);
            return new Pair(null, null);
        }
    }

    private List<String> getContributorsForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        return this.timelinesDB.getContributorsForObject(objectType, projectKey, objectId);
    }

    public List<String> getContributorsForObject(TaggableObjectsService.TaggableObjectRef tor) {
        return this.getContributorsForObject(tor.type, tor.projectKey, tor.id);
    }

    public Map<TaggableObjectsService.TaggableObjectRef, Collection<String>> getContributorsForAllObjects(List<String> projectKeys) {
        return this.timelinesDB.getContributorsForAllObjects(projectKeys);
    }

    public List<String> getContributors(String projectKey) {
        try {
            return this.timelinesDB.getContributors(projectKey);
        }
        catch (Exception t) {
            logger.error((Object)"Failed to read timeline", (Throwable)t);
            return new ArrayList<String>();
        }
    }

    private boolean collapse(TimelineItem a, TimelineItem b) {
        return a != null && b != null && a.action == b.action && a.action.isCollapsable() && !a.action.isRenaming() && StringUtils.equals((String)a.user, (String)b.user) && Math.abs(a.time - b.time) < MAX_TIME_DIFF_TO_COLLAPSE;
    }

    private void updateTimelineWithModifiedAndCreation(TimelineWithVersioning ret, TimelineItem firstForObject) throws IOException {
        if (!ret.items.isEmpty()) {
            ret.lastModifiedBy = this.usersService.getPublicUser(ret.items.get((int)0).user);
            ret.lastModifiedOn = ret.items.get((int)0).time;
        }
        if (firstForObject != null) {
            ret.createdBy = this.usersService.getPublicUser(firstForObject.user);
            ret.createdOn = firstForObject.time;
        }
    }

    public static class TimelineWithVersioning
    extends HeadWithVersioningInfo {
        public List<PublicUser> allContributors = new ArrayList<PublicUser>();
        public List<TimelineItem> items = new ArrayList<TimelineItem>();
    }
}

