/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.timelines.workspace.AbstractWorkspaceTimelinesService;
import com.dataiku.dip.timelines.workspace.IWorkspaceTimelinesDBService;
import com.dataiku.dip.timelines.workspace.MultiWorkspaceTimelinesInternalDB;
import com.dataiku.dip.timelines.workspace.SingleWorkspaceTimelinesInternalDB;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineBehavior;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkspaceTimelinesInternalDB
extends AbstractWorkspaceTimelinesService {
    @Autowired
    private DSSDBConnectionsManagementService internalDBConnectionsService;
    private IWorkspaceTimelinesDBService concreteTimelinesDAO;

    @PostConstruct
    public void init() throws CodedSQLException {
        this.concreteTimelinesDAO = this.internalDBConnectionsService.isUsingInternalH2() ? new MultiWorkspaceTimelinesInternalDB() : new SingleWorkspaceTimelinesInternalDB();
    }

    @Override
    public WorkspaceTimelineBehavior getDao(String workspaceKey) throws CodedSQLException {
        return this.concreteTimelinesDAO.getDao(workspaceKey);
    }

    @Override
    public DSSDBConnection acquireConnection(String workspaceKey, boolean isReadOnly) throws CodedSQLException {
        return this.concreteTimelinesDAO.acquireConnection(workspaceKey, isReadOnly);
    }

    @Override
    public void createWorkspace(String workspaceKey) throws CodedSQLException {
        this.concreteTimelinesDAO.createWorkspace(workspaceKey);
    }

    @Override
    public void deleteForWorkspace(String workspaceKey) {
        this.concreteTimelinesDAO.deleteForWorkspace(workspaceKey);
    }
}

