/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.git.IProjectCommitModeService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.ProjectTransactionCommitedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.exceptions.TransactionFailedException;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.GitCommitSeparator;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.ICommitBehavior;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DSSCommitBehavior
implements ICommitBehavior {
    private String projectKey;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.commitbehavior");

    public void executeStartCommitTask() {
        this.projectKey = null;
    }

    public List<? extends CommitDef> getCommitList(File root, AuthCtx user, String message, MinimalRWTransaction.TransactionGitCommitPolicy gitCommitPolicy, List<RelFile> changes) throws TransactionFailedException {
        List<Object> gitCommits = new ArrayList();
        GitCommitSeparator sep = new GitCommitSeparator(ApplicationConfigurator.getGitMode(), ApplicationConfigurator.getPluginGitMode());
        List<DSSCommitDef> candidateGitCommits = sep.commitDefsFromChanges(changes, new GitModel.GitAuthor(user), message, root);
        if (candidateGitCommits.size() == 1) {
            this.projectKey = candidateGitCommits.get((int)0).itemId;
        }
        try {
            switch (gitCommitPolicy) {
                case IF_AUTO: 
                case IF_NOT_ALL_EXPLICIT: {
                    IProjectCommitModeService service = (IProjectCommitModeService)SpringUtils.getBean(IProjectCommitModeService.class);
                    for (DSSCommitDef candidate : candidateGitCommits) {
                        logger.info((Object)("Candidate commit " + String.valueOf(candidate)));
                        switch (candidate.type) {
                            case GLOBAL: {
                                gitCommits.add(candidate);
                                break;
                            }
                            case PROJECT: {
                                IProjectCommitModeService.ProjectCommitMode pcm = service.getForProject(candidate.itemId);
                                if (pcm == IProjectCommitModeService.ProjectCommitMode.AUTO || gitCommitPolicy == MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT && pcm != IProjectCommitModeService.ProjectCommitMode.ALL_EXPLICIT) {
                                    gitCommits.add(candidate);
                                    break;
                                }
                                logger.infoV("Ignoring git commit (project is in %s mode): %s", new Object[]{pcm, candidate});
                                break;
                            }
                            case PLUGIN: {
                                if (ApplicationConfigurator.getGeneralSettings().pluginDevExplicitCommit) {
                                    logger.infoV("Ignoring git commit (plugins are in explicit commit mode): %s", new Object[]{candidate});
                                    break;
                                }
                                gitCommits.add(candidate);
                            }
                        }
                    }
                    break;
                }
                case NO: {
                    logger.infoV("Ignoring %s git commits", new Object[]{candidateGitCommits.size()});
                    break;
                }
                case YES: {
                    gitCommits = candidateGitCommits;
                }
            }
        }
        catch (IOException e) {
            throw new TransactionFailedException("Failed to determine what to commit to Git", (Throwable)e);
        }
        return gitCommits;
    }

    public void executeEndCommitTask(AuthCtx user, String message) {
        if (this.projectKey != null) {
            PubSubService notifService = (PubSubService)((Object)SpringUtils.getBean(PubSubService.class));
            String projectName = this.projectKey;
            notifService.publish(new ProjectTransactionCommitedEvent(user.getIdentifier(), this.projectKey, projectName, message));
        }
    }
}

