/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.alerting;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.AbstractMonitoredThing;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertConfig;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertEvent;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertReporter;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.AbstractMonitoredApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.MonitoredManagedApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.settings.UnifiedMonitoringSettingsService;
import com.dataiku.dip.utils.DKULogger;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class UnifiedMonitoringAlertReporterRunner {
    @Autowired
    UsersDAO usersDAO;
    @Autowired
    UnifiedMonitoringSettingsService unifiedMonitoringSettingsService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    private final UnifiedMonitoringAlertReporter reporter;
    private final AbstractMonitoredThing newSnapshot;
    @Nullable
    private final AbstractMonitoredThing previousSnapshot;
    private final UnifiedMonitoringAlertConfig alertConfig;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.alerting.reportrunner");

    public UnifiedMonitoringAlertReporterRunner(UnifiedMonitoringAlertReporter reporter, UnifiedMonitoringAlertConfig alertConfig, AbstractMonitoredThing newSnapshot, @Nullable AbstractMonitoredThing previousSnapshot) {
        this.alertConfig = alertConfig;
        this.reporter = reporter;
        this.newSnapshot = newSnapshot;
        this.previousSnapshot = previousSnapshot;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void sendMessage() throws Exception {
        String studioExternalUrl;
        logger.infoV("Start sending message for alert config {%s} with reporter {%s} for endpoint {%s}", new Object[]{this.alertConfig.name, this.reporter.name, this.newSnapshot.displayedName});
        VariableLookup lookup = new VariableLookup();
        lookup.addVariable("alertConfigName", this.alertConfig.name);
        lookup.addVariable("alertConfigDescription", this.alertConfig.description);
        lookup.addVariable("deploymentId", this.newSnapshot.deploymentId);
        lookup.addVariable("displayName", this.newSnapshot.displayedName);
        lookup.addVariable("previousDeploymentStatus", this.previousSnapshot != null ? this.previousSnapshot.umDeploymentStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
        lookup.addVariable("currentDeploymentStatus", this.newSnapshot.umDeploymentStatus.toString());
        lookup.addVariable("previousGlobalStatus", this.previousSnapshot != null ? this.previousSnapshot.umGlobalStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
        lookup.addVariable("currentGlobalStatus", this.newSnapshot.umGlobalStatus.toString());
        try (Transaction t = this.transactionService.beginRead();){
            studioExternalUrl = this.generalSettingsDAO.read().studioExternalUrl;
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot retrieve the studio external URL", (Throwable)e);
            studioExternalUrl = "";
        }
        lookup.addVariable("unifiedMonitoringUrl", "%s/unified-monitoring/".formatted(studioExternalUrl));
        this.enhanceLookupWithSnapshotInfo(lookup, this.previousSnapshot, this.newSnapshot);
        IntegrationMeta.PermissionCheckContext permissionCheckContext = new IntegrationMeta.PermissionCheckContext(false);
        IntegrationEventHandler sender = IntegrationHooksRegistry.buildSender(null, this.reporter.messaging, permissionCheckContext);
        UnifiedMonitoringAlertEvent alertEvent = new UnifiedMonitoringAlertEvent(lookup);
        InfoMessage.InfoMessages outcome = new InfoMessage.InfoMessages();
        sender.handleEvent(alertEvent, outcome);
        outcome.summarize();
        if (outcome.fatal || outcome.error || outcome.warning) {
            logger.warn((Object)("Send message completed with warnings: " + outcome.report()));
        } else {
            logger.info((Object)"Done sending message");
        }
    }

    public void enhanceLookupWithSnapshotInfo(VariableLookup lookup, AbstractMonitoredThing previousSnapshot, AbstractMonitoredThing newSnapshot) {
        AbstractMonitoredThing newEndpointSnapshot;
        if (newSnapshot instanceof AbstractMonitoredApiEndpoint) {
            newEndpointSnapshot = (AbstractMonitoredApiEndpoint)newSnapshot;
            lookup.addVariable("endpointName", newEndpointSnapshot.endpointName);
            lookup.addVariable("previousModelStatus", previousSnapshot != null ? ((AbstractMonitoredApiEndpoint)previousSnapshot).umModelStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
            lookup.addVariable("currentModelStatus", newEndpointSnapshot.umModelStatus.toString());
        }
        if (newSnapshot instanceof MonitoredManagedApiEndpoint) {
            newEndpointSnapshot = (MonitoredManagedApiEndpoint)newSnapshot;
            lookup.addVariable("previousGovernanceStatus", previousSnapshot != null ? previousSnapshot.umGovernanceStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
            lookup.addVariable("currentGovernanceStatus", ((MonitoredManagedApiEndpoint)newEndpointSnapshot).umGovernanceStatus.toString());
        }
        if (newSnapshot instanceof AbstractMonitoredProjectDeployment) {
            newEndpointSnapshot = (AbstractMonitoredProjectDeployment)newSnapshot;
            lookup.addVariable("deployedProjectKey", ((AbstractMonitoredProjectDeployment)newEndpointSnapshot).deployedProjectKey);
            lookup.addVariable("bundleName", ((AbstractMonitoredProjectDeployment)newEndpointSnapshot).bundleName);
            lookup.addVariable("previousModelsStatus", previousSnapshot != null ? ((AbstractMonitoredProjectDeployment)previousSnapshot).umProjectModelStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
            lookup.addVariable("currentModelsStatus", ((AbstractMonitoredProjectDeployment)newEndpointSnapshot).umProjectModelStatus.toString());
            lookup.addVariable("previousExecutionStatus", previousSnapshot != null ? ((AbstractMonitoredProjectDeployment)previousSnapshot).umProjectExecutionStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
            lookup.addVariable("currentExecutionStatus", ((AbstractMonitoredProjectDeployment)newEndpointSnapshot).umProjectExecutionStatus.toString());
            lookup.addVariable("previousDataStatus", previousSnapshot != null ? ((AbstractMonitoredProjectDeployment)previousSnapshot).umDataQualityStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
            lookup.addVariable("currentDataStatus", ((AbstractMonitoredProjectDeployment)newEndpointSnapshot).umDataQualityStatus.toString());
            lookup.addVariable("previousGovernanceStatus", previousSnapshot != null ? previousSnapshot.umGovernanceStatus.toString() : UnifiedMonitoringStatus.NO_STATUS.toString());
            lookup.addVariable("currentGovernanceStatus", ((AbstractMonitoredProjectDeployment)newEndpointSnapshot).umGovernanceStatus.toString());
        }
    }
}

