/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DKUNumberUtils {
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;
    private static final long TERA = 0x10000000000L;

    public static String printSmartBytesSize(long size) {
        return DKUNumberUtils.printSmartBytesSize(size, Locale.getDefault());
    }

    public static String printSmartBytesSize(long size, Locale locale) {
        if (size < 0L) {
            return "-" + (size == Long.MIN_VALUE ? DKUNumberUtils.printSmartBytesSize(Long.MAX_VALUE, locale) : DKUNumberUtils.printSmartBytesSize(-size, locale));
        }
        DecimalFormat df = new DecimalFormat("#.#");
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        if (size < 1024L) {
            return size + " bytes";
        }
        if (size < 0x100000L) {
            return df.format((double)size / 1024.0) + " KB";
        }
        if (size < 0x40000000L) {
            return df.format((double)size / 1048576.0) + " MB";
        }
        if (size < 0x10000000000L) {
            return df.format((double)size / 1.073741824E9) + " GB";
        }
        return df.format((double)size / 1.099511627776E12) + " TB";
    }
}

