/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.ApplicationConfigurator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final ThreadLocal<StupidityFactory> threadLocalStupidity = new ThreadLocal();

    private static StupidityFactory getStupid() {
        StupidityFactory sf = threadLocalStupidity.get();
        if (sf == null) {
            sf = new StupidityFactory();
            threadLocalStupidity.set(sf);
        }
        return sf;
    }

    public static Document parse(byte[] in) throws SAXException, IOException {
        return XMLUtils.parse(new ByteArrayInputStream(in));
    }

    public static Document parse(InputStream is) throws SAXException, IOException {
        StupidityFactory sf = XMLUtils.getStupid();
        sf.builder.reset();
        sf.builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        });
        return sf.builder.parse(is);
    }

    public static Document parse(String input) throws SAXException, IOException {
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(input));
        StupidityFactory sf = XMLUtils.getStupid();
        sf.builder.reset();
        sf.builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        });
        return sf.builder.parse(is);
    }

    public static String writeToString(Document document) throws TransformerException {
        Transformer transformer;
        StupidityFactory sf = XMLUtils.getStupid();
        StringWriter swr = new StringWriter();
        try {
            transformer = sf.tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Error("Could not create XML transformer (this may be due to the presence of additional JARs which are incompatible with DSS)", e);
        }
        transformer.transform(new DOMSource(document), new StreamResult(swr));
        return swr.toString();
    }

    private static class StupidityFactory {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        DocumentBuilder builder;

        StupidityFactory() {
            try {
                this.factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                if (!ApplicationConfigurator.getParams().getBoolParam("dku.security.xml.dangerous.allowUnsafeExternalEntities", false)) {
                    this.factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    this.factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    this.factory.setXIncludeAware(false);
                }
                this.builder = this.factory.newDocumentBuilder();
            }
            catch (Throwable e) {
                throw new Error("Could not create XML document builder (this may be due to the presence of additional JARs which are incompatible with DSS)", e);
            }
        }
    }
}

