/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.aggregations;

import com.google.refine.expr.functions.aggregations.AggregatedFunction;
import com.google.refine.expr.functions.math.Sum;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.udaf.UdafUtils;
import java.util.Properties;

public class SumAgg
extends AggregatedFunction {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (UdafUtils.isSumGRELFormula(args)) {
            return new Sum().call(bindings, args);
        }
        return super.call(bindings, args);
    }

    @Override
    public Documentation getDocumentation() {
        Documentation doc = new Documentation("GREL.FUNCTION.SumAgg.DOCUMENTATION", "Returns the sum of an expression (aggregated or not)").withParams("column c | array a | value1, value2 ...").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.AGGREGATIONS", "Aggregations").withExample(Example.with("ColumnA + 10").returns("sum of all ColumnA values after adding 10 to each"));
        doc.examples.addAll(new Sum().getDocumentation().examples);
        return doc;
    }

    @Override
    public String prettyName() {
        return "sum";
    }
}

