/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Odd
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1 && args[0] != null && args[0] instanceof Number) {
            Number n = (Number)args[0];
            if (n instanceof Long || n instanceof Integer || n instanceof Short) {
                return Odd.roundUpToOdd(n.longValue());
            }
            return Odd.roundUpToOdd(n.doubleValue());
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a number");
    }

    public static double roundUpToOdd(double d) {
        double temp = Math.ceil(d);
        return temp % 2.0 == 0.0 ? temp + 1.0 : temp;
    }

    public static long roundUpToOdd(long l) {
        return l % 2L == 0L ? l + 1L : l;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Odd.DOCUMENTATION", "Rounds a number up to the nearest odd integer.").withParams("number d").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("5.3").returns("7.0")).withExample(Example.with("-5.3").returns("-5.0"));
    }
}

