/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;

public class Contains
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object s1 = args[0];
            Object s2 = args[1];
            if (s1 instanceof String && s2 instanceof String) {
                return ((String)s1).contains((String)s2);
            }
            if (s1 != null && s2 != null) {
                return s1.toString().contains(s2.toString());
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Contains.DOCUMENTATION", "Returns whether <code>s</code> contains <code>frag</code>.").withParams("string s, string frag").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"", "\"llo\"").returns("true"));
    }
}

