/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Date;
import javax.measure.MetricPrefix;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.MeasurementRange;
import org.geotools.util.Range;
import si.uom.SI;

public class DateRange
extends Range<Date> {
    private static final long serialVersionUID = -6400011350250757942L;
    private static final Unit<Time> MILLISECOND = MetricPrefix.MILLI((Unit)SI.SECOND);

    public DateRange(Date startTime, Date endTime) {
        super(Date.class, DateRange.clone(startTime), DateRange.clone(endTime));
    }

    public DateRange(Date startTime, boolean isMinIncluded, Date endTime, boolean isMaxIncluded) {
        super(Date.class, DateRange.clone(startTime), isMinIncluded, DateRange.clone(endTime), isMaxIncluded);
    }

    public DateRange(MeasurementRange<?> range, Date origin) {
        this(range, DateRange.getConverter(range.getUnits()), origin.getTime());
    }

    private DateRange(MeasurementRange<?> range, UnitConverter converter, long origin) {
        super(Date.class, new Date(origin + Math.round(converter.convert(range.getMinimum()))), range.isMinIncluded(), new Date(origin + Math.round(converter.convert(range.getMaximum()))), range.isMaxIncluded());
    }

    private static Date clone(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    private static UnitConverter getConverter(Unit<Time> source) {
        if (source == null) {
            throw new UnconvertibleException(Errors.format(142));
        }
        return source.getConverterTo(MILLISECOND);
    }

    @Override
    public Date getMinValue() {
        return DateRange.clone((Date)super.getMinValue());
    }

    @Override
    public Date getMaxValue() {
        return DateRange.clone((Date)super.getMaxValue());
    }
}

