/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

public class NoDependenciesRFC4180CSVParser {
    private StringBuilder currentField = new StringBuilder();
    private boolean inQuotes;
    private BufferedReader br;
    private char delimiter;
    private char quote = (char)34;

    public NoDependenciesRFC4180CSVParser(BufferedReader reader, char delimiter) {
        this.delimiter = delimiter;
        this.br = reader;
    }

    public boolean next(List<String> out) throws IOException {
        if (!this.inQuotes) assert (this.currentField.length() == 0);
        out.clear();
        do {
            String line;
            if ((line = this.br.readLine()) == null) {
                if (!this.inQuotes) {
                    return false;
                }
                if (this.currentField != null && this.currentField.length() > 0) {
                    String currentStr = this.currentField.toString();
                    if (currentStr.length() > 100) {
                        currentStr = currentStr.substring(0, 100);
                    }
                    throw new IOException("Unterminated quoted field at the end of the file (while reading: '" + currentStr + "...')");
                }
                throw new IOException("Unterminated quoted field at the end of the file");
            }
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == this.quote) {
                    if (!this.inQuotes) {
                        this.inQuotes = true;
                        continue;
                    }
                    if (line.length() > i + 1 && line.charAt(i + 1) == this.quote) {
                        this.currentField.append('\"');
                        ++i;
                        continue;
                    }
                    this.inQuotes = false;
                    continue;
                }
                if (c == this.delimiter) {
                    if (this.inQuotes) {
                        this.currentField.append(c);
                        continue;
                    }
                    out.add(this.currentField.toString());
                    this.currentField.setLength(0);
                    continue;
                }
                this.currentField.append(c);
            }
            if (this.inQuotes) {
                this.currentField.append('\n');
                continue;
            }
            out.add(this.currentField.toString());
            this.currentField.setLength(0);
        } while (this.inQuotes);
        return true;
    }
}

