/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDe;
import io.confluent.kafka.serializers.AvroSchemaUtils;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.utils.VerifiableProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaAvroSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    protected boolean autoRegisterSchema;

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config);
        this.autoRegisterSchema = config.autoRegisterSchema();
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected KafkaAvroSerializerConfig serializerConfig(VerifiableProperties props) {
        return new KafkaAvroSerializerConfig(props.props());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] serializeImpl(String subject, Object object) throws SerializationException {
        Schema schema = null;
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            Object value;
            int id;
            schema = AvroSchemaUtils.getSchema(object, this.useSchemaReflection);
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Avro schema: ";
                id = this.schemaRegistry.register(subject, schema);
            } else {
                restClientErrorMsg = "Error retrieving Avro schema: ";
                id = this.schemaRegistry.getId(subject, schema);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            Object object2 = value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
            if (schema.getType().equals((Object)Schema.Type.BYTES)) {
                if (value instanceof byte[]) {
                    out.write((byte[])value);
                } else {
                    if (!(value instanceof ByteBuffer)) throw new SerializationException("Unrecognized bytes object of type: " + value.getClass().getName());
                    out.write(((ByteBuffer)value).array());
                }
            } else {
                void var9_14;
                BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
                if (value instanceof SpecificRecord) {
                    SpecificDatumWriter specificDatumWriter = new SpecificDatumWriter(schema);
                } else if (this.useSchemaReflection) {
                    ReflectDatumWriter reflectDatumWriter = new ReflectDatumWriter(schema);
                } else {
                    GenericDatumWriter genericDatumWriter = new GenericDatumWriter(schema);
                }
                var9_14.write(value, (Encoder)encoder);
                encoder.flush();
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw new SerializationException(restClientErrorMsg + schema, (Throwable)e);
        }
    }
}

