/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.streamimpl;

import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.utils.JSON;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.HashMap;

public class StreamRow
implements Row {
    private String[] data;
    public static final int MAX_ARRAY_SIZE = 32768;
    public static final int INITIAL_FALLBACK_MAP_CAPACITY = 16384;
    private TIntObjectHashMap<String> fallbackMap;
    private StreamColumnFactory columnFactory;
    private Row.RowContext recordContext;
    private boolean deleted;

    @Override
    public String get(Column cd) {
        StreamColumn ssc = (StreamColumn)cd;
        if (this.columnFactory == null) {
            this.columnFactory = ssc.columnFactory;
        }
        if (this.columnFactory != ssc.columnFactory) {
            this.columnFactory.complainAboutMixedUpColumnFactories(ssc);
            ssc = this.columnFactory.getColumnIncludingInvisible(ssc.getName());
            if (ssc == null) {
                return null;
            }
        }
        if (ssc.storageIndex < 32768) {
            if (this.data == null) {
                return null;
            }
            if (ssc.storageIndex < this.data.length) {
                return this.data[ssc.storageIndex];
            }
            return null;
        }
        if (this.fallbackMap == null) {
            return null;
        }
        return (String)this.fallbackMap.get(ssc.storageIndex);
    }

    public long getApproximateMemoryUsage() {
        long usage = 0L;
        if (this.data != null) {
            for (String s : this.data) {
                if (s == null) continue;
                usage += (long)s.length() * 2L;
            }
        }
        if (this.fallbackMap != null) {
            for (Object o : this.fallbackMap.values()) {
                if (o == null || !(o instanceof String)) continue;
                usage += (long)((String)o).length() * 2L;
            }
        }
        return usage + 64L;
    }

    private int determineBufferSize(int index) {
        int size;
        for (size = 2; index >= size; size *= 2) {
        }
        return size;
    }

    @Override
    public void put(Column cd, String value) {
        if (value != null && value.isEmpty()) {
            value = null;
        }
        StreamColumn ssc = (StreamColumn)cd;
        if (this.columnFactory == null) {
            this.columnFactory = ssc.columnFactory;
        }
        if (this.columnFactory != ssc.columnFactory) {
            this.columnFactory.complainAboutMixedUpColumnFactories(ssc);
            ssc = this.columnFactory.invisibleColumn(ssc.getName());
        }
        if (ssc.storageIndex < 32768) {
            if (this.data == null) {
                if (value == null) {
                    return;
                }
                this.data = new String[this.determineBufferSize(ssc.storageIndex)];
            } else if (ssc.storageIndex >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.determineBufferSize(ssc.storageIndex));
            }
            this.data[ssc.storageIndex] = value;
        } else {
            if (this.fallbackMap == null) {
                if (value == null) {
                    return;
                }
                this.fallbackMap = new TIntObjectHashMap(16384, 0.75f, -1);
            }
            this.fallbackMap.put(ssc.storageIndex, (Object)value);
        }
    }

    @Override
    public void delete(Column key) {
        this.put(key, null);
    }

    @Override
    public Row with(ColumnFactory cf, String key, String value) {
        this.put(cf.column(key), value);
        return this;
    }

    @Override
    public void put(Column key, int value) {
        this.put(key, Integer.toString(value));
    }

    @Override
    public void put(Column key, long value) {
        this.put(key, Long.toString(value));
    }

    @Override
    public void put(Column key, double value) {
        this.put(key, Double.toString(value));
    }

    @Override
    public void put(Column key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    @Override
    public Row with(Column key, String value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Row with(Column key, int value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Row with(Column key, long value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Row with(Column key, double value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Row with(Column key, boolean value) {
        this.put(key, value);
        return this;
    }

    @Override
    public double getAsDoubleOrNaN(Column cd) {
        try {
            return Double.parseDouble(this.get(cd));
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    @Override
    public String get(Column cd, String defaultValue) {
        String v = this.get(cd);
        if (v == null || v.length() == 0) {
            return defaultValue;
        }
        return v;
    }

    @Override
    public boolean empty(Column cd) {
        String v = this.get(cd);
        return v == null || v.length() == 0;
    }

    public String toString() {
        HashMap<String, String> temp = new HashMap<String, String>();
        if (this.columnFactory != null) {
            for (Column column : this.columnFactory.columnsIncludingInvisible()) {
                String value = this.get(column);
                if (value == null) continue;
                temp.put(column.getName(), value);
            }
        }
        return "ROW: " + JSON.json(temp);
    }

    @Override
    public void delete() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Row.RowContext getRowContext() {
        if (this.recordContext == null) {
            this.recordContext = new Row.RowContext();
        }
        return this.recordContext;
    }

    @Override
    public void get(Column cd, CellData buf) {
        String dataInCell = this.get(cd);
        if (dataInCell == null || dataInCell.length() == 0) {
            buf.reset();
        } else {
            buf.set(dataInCell.toCharArray(), 0, dataInCell.length());
        }
    }
}

