/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.$internal.client.spooling.SpooledSegment;
import io.trino.jdbc.$internal.okhttp3.Call;
import io.trino.jdbc.$internal.okhttp3.Callback;
import io.trino.jdbc.$internal.okhttp3.Headers;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SegmentLoader
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(SegmentLoader.class.getPackage().getName());
    private final Call.Factory callFactory;

    public SegmentLoader() {
        this(new OkHttpClient());
    }

    public SegmentLoader(Call.Factory callFactory) {
        this.callFactory = Objects.requireNonNull(callFactory, "callFactory is null");
    }

    public InputStream load(SpooledSegment segment) throws IOException {
        return this.loadFromURI(segment.getDataUri(), segment.getHeaders());
    }

    public InputStream loadFromURI(URI segmentUri, Map<String, List<String>> headers) throws IOException {
        Headers requestHeaders = SegmentLoader.toHeaders(headers);
        Request request = new Request.Builder().url(segmentUri.toString()).headers(requestHeaders).build();
        Response response = this.callFactory.newCall(request).execute();
        if (response.body() == null) {
            throw new IOException("Could not open segment for streaming, got empty body");
        }
        if (response.isSuccessful()) {
            return this.delegatingInputStream(response, response.body().byteStream(), segmentUri, requestHeaders);
        }
        throw new IOException(String.format("Could not open segment for streaming, got error '%s' with code %d", response.message(), response.code()));
    }

    private void delete(URI segmentUri, Headers headers) {
        Request deleteRequest = new Request.Builder().delete().url(segmentUri.toString()).headers(headers).build();
        this.callFactory.newCall(deleteRequest).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException cause) {
                logger.log(Level.WARNING, "Could not acknowledge spooled segment", cause);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
            }
        });
    }

    private InputStream delegatingInputStream(final Response response, final InputStream delegate, final URI segmentUri, final Headers headers) {
        return new FilterInputStream(this, delegate){
            final /* synthetic */ SegmentLoader this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void close() throws IOException {
                try (Response ignored = response;
                     InputStream ignored2 = delegate;){
                    this.this$0.delete(segmentUri, headers);
                }
            }
        };
    }

    private static Headers toHeaders(Map<String, List<String>> headers) {
        Headers.Builder builder = new Headers.Builder();
        headers.forEach((key, values2) -> values2.forEach(value -> builder.add((String)key, (String)value)));
        return builder.build();
    }

    @Override
    public void close() {
        if (this.callFactory instanceof OkHttpClient) {
            ((OkHttpClient)this.callFactory).dispatcher().executorService().shutdown();
        }
    }
}

