/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.filter.FilterNameTypeMapping;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class FilterCapabilities {
    public static final long NO_OP = 0L;
    public static final long NONE = 0x40000000L;
    public static final long ALL = Integer.MIN_VALUE;
    public static final long SPATIAL_BBOX = 1L;
    public static final long SPATIAL_EQUALS = 2L;
    public static final long SPATIAL_DISJOINT = 4L;
    public static final long SPATIAL_INTERSECT = 8L;
    public static final long SPATIAL_TOUCHES = 16L;
    public static final long SPATIAL_CROSSES = 32L;
    public static final long SPATIAL_WITHIN = 64L;
    public static final long SPATIAL_CONTAINS = 128L;
    public static final long SPATIAL_OVERLAPS = 256L;
    public static final long SPATIAL_BEYOND = 512L;
    public static final long SPATIAL_DWITHIN = 1024L;
    public static final long LIKE = 2048L;
    public static final long BETWEEN = 4096L;
    public static final long NULL_CHECK = 8192L;
    public static final long SIMPLE_ARITHMETIC = 16384L;
    public static final long FUNCTIONS = 32768L;
    public static final long COMPARE_EQUALS = 65536L;
    public static final long COMPARE_GREATER_THAN = 131072L;
    public static final long COMPARE_GREATER_THAN_EQUAL = 262144L;
    public static final long COMPARE_LESS_THAN = 524288L;
    public static final long COMPARE_LESS_THAN_EQUAL = 0x100000L;
    public static final long COMPARE_NOT_EQUALS = 0x200000L;
    public static final long FID = 0x400000L;
    public static final long LOGIC_AND = 0x800000L;
    public static final long LOGIC_NOT = 0x1000000L;
    public static final long LOGIC_OR = 0x2000000L;
    public static final long LOGICAL = 0x3800000L;
    public static final long SIMPLE_COMPARISONS = 0x3F0000L;
    public static final FilterCapabilities SIMPLE_COMPARISONS_OPENGIS;
    public static final FilterCapabilities LOGICAL_OPENGIS;
    static final Map<Long, Object> intTypeToOpenGisTypeMap;
    private long ops = 0L;
    private Set<Class> functions = new HashSet<Class>();

    public FilterCapabilities(long filterCapabilitiesType) {
        this.addType(filterCapabilitiesType);
    }

    public FilterCapabilities() {
        this(0L);
    }

    public FilterCapabilities(Class type) {
        this.addType(type);
    }

    public void addType(long type) {
        if ((this.ops & type) != 0L) {
            return;
        }
        this.ops |= type;
        for (Map.Entry<Long, Object> longObjectEntry : intTypeToOpenGisTypeMap.entrySet()) {
            Object filter;
            Map.Entry<Long, Object> entry = longObjectEntry;
            long key = entry.getKey();
            if ((key & type) == 0L || (filter = entry.getValue()) == null) continue;
            if (filter instanceof Class[]) {
                Class[] filters;
                for (Class aClass : filters = (Class[])filter) {
                    this.addType(aClass, false);
                }
                continue;
            }
            this.addType((Class)filter, false);
        }
    }

    public void addType(Class type) {
        if (Filter.class.isAssignableFrom(type) || Expression.class.isAssignableFrom(type)) {
            this.addType(32768L);
            this.functions.add(type);
        }
    }

    public void addType(Class type, boolean addFunctionType) {
        if (Filter.class.isAssignableFrom(type) || Expression.class.isAssignableFrom(type)) {
            if (addFunctionType) {
                this.addType(32768L);
            }
            this.functions.add(type);
        }
    }

    public void addAll(FilterCapabilities capabilities) {
        this.addType(capabilities.ops);
        this.functions.addAll(capabilities.functions);
    }

    public FilterCapabilities convertFilterTypeToMask(short type) {
        if (type == -12345) {
            return FilterNameTypeMapping.NO_OP_CAPS;
        }
        if (type == 12345) {
            return FilterNameTypeMapping.ALL_CAPS;
        }
        FilterCapabilities object = FilterNameTypeMapping.filterTypeToFilterCapabilitiesMap.get(type);
        return object;
    }

    public boolean supports(Filter filter) {
        for (Class function : this.functions) {
            if (!function.isAssignableFrom(filter.getClass())) continue;
            return true;
        }
        if (this.functions.contains(filter.getClass())) {
            return true;
        }
        short filterType = FilterCapabilities.getFilterType(filter);
        if (filterType == 0) {
            return false;
        }
        return this.supports(filterType);
    }

    public boolean fullySupports(Filter filter) {
        boolean supports = true;
        if (filter == null) {
            throw new IllegalArgumentException("Null filters can not be unpacked, did you mean Filter.INCLUDE?");
        }
        if (filter instanceof BinaryLogicOperator) {
            BinaryLogicOperator lf = (BinaryLogicOperator)filter;
            for (Filter testFilter : lf.getChildren()) {
                if (this.fullySupports(testFilter)) continue;
                supports = false;
                break;
            }
        } else if (filter instanceof Not) {
            Not lf = (Not)filter;
            if (!this.fullySupports(lf.getFilter())) {
                supports = false;
            }
        } else {
            supports = this.supports(filter);
        }
        return supports;
    }

    private boolean supports(long type) {
        return (this.ops & type) == type;
    }

    public boolean supports(FilterCapabilities type) {
        return (this.ops & type.ops) == type.ops && this.functions.containsAll(type.functions);
    }

    public boolean supports(Class type) {
        if (this.functions.contains(type)) {
            return true;
        }
        for (Class functionClass : this.functions) {
            if (!functionClass.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public long getScalarOps() {
        return this.ops & 0x3FFF800L;
    }

    public long getSpatialOps() {
        return this.ops & 0x7FFL;
    }

    public static FilterCapabilities findOperation(String name) {
        return FilterNameTypeMapping.findOperation(name);
    }

    public static FilterCapabilities findFunction(String name) {
        return FilterNameTypeMapping.findFunction(name);
    }

    private static short getFilterType(Filter filter) {
        if (filter == null) {
            return 0;
        }
        if (filter == Filter.EXCLUDE) {
            return -12345;
        }
        if (filter == Filter.INCLUDE) {
            return 12345;
        }
        if (filter instanceof PropertyIsBetween) {
            return 19;
        }
        if (filter instanceof PropertyIsEqualTo) {
            return 14;
        }
        if (filter instanceof PropertyIsGreaterThan) {
            return 16;
        }
        if (filter instanceof PropertyIsGreaterThanOrEqualTo) {
            return 18;
        }
        if (filter instanceof PropertyIsLessThan) {
            return 15;
        }
        if (filter instanceof PropertyIsLessThanOrEqualTo) {
            return 17;
        }
        if (filter instanceof PropertyIsNotEqualTo) {
            return 23;
        }
        if (filter instanceof Id) {
            return 22;
        }
        if (filter instanceof BBOX) {
            return 4;
        }
        if (filter instanceof Beyond) {
            return 13;
        }
        if (filter instanceof Contains) {
            return 11;
        }
        if (filter instanceof Crosses) {
            return 9;
        }
        if (filter instanceof Disjoint) {
            return 6;
        }
        if (filter instanceof DWithin) {
            return 24;
        }
        if (filter instanceof Equals) {
            return 5;
        }
        if (filter instanceof Intersects) {
            return 7;
        }
        if (filter instanceof Overlaps) {
            return 12;
        }
        if (filter instanceof Touches) {
            return 8;
        }
        if (filter instanceof Within) {
            return 10;
        }
        if (filter instanceof PropertyIsLike) {
            return 20;
        }
        if (filter instanceof And) {
            return 2;
        }
        if (filter instanceof Not) {
            return 3;
        }
        if (filter instanceof Or) {
            return 1;
        }
        if (filter instanceof PropertyIsNull) {
            return 21;
        }
        if (filter instanceof Filter) {
            return 0;
        }
        return 0;
    }

    static {
        intTypeToOpenGisTypeMap = new HashMap<Long, Object>();
        SIMPLE_COMPARISONS_OPENGIS = new FilterCapabilities();
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsGreaterThan.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsGreaterThanOrEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsLessThanOrEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsLessThan.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsNotEqualTo.class);
        LOGICAL_OPENGIS = new FilterCapabilities();
        LOGICAL_OPENGIS.addType(And.class);
        LOGICAL_OPENGIS.addType(Not.class);
        LOGICAL_OPENGIS.addType(Or.class);
        intTypeToOpenGisTypeMap.put(1L, BBOX.class);
        intTypeToOpenGisTypeMap.put(2L, Equals.class);
        intTypeToOpenGisTypeMap.put(4L, Disjoint.class);
        intTypeToOpenGisTypeMap.put(8L, Intersects.class);
        intTypeToOpenGisTypeMap.put(16L, Touches.class);
        intTypeToOpenGisTypeMap.put(32L, Crosses.class);
        intTypeToOpenGisTypeMap.put(64L, Within.class);
        intTypeToOpenGisTypeMap.put(128L, Contains.class);
        intTypeToOpenGisTypeMap.put(256L, Overlaps.class);
        intTypeToOpenGisTypeMap.put(512L, Beyond.class);
        intTypeToOpenGisTypeMap.put(1024L, DWithin.class);
        intTypeToOpenGisTypeMap.put(16384L, new Class[]{Add.class, Subtract.class, Multiply.class, Divide.class});
        intTypeToOpenGisTypeMap.put(65536L, PropertyIsEqualTo.class);
        intTypeToOpenGisTypeMap.put(0x200000L, PropertyIsNotEqualTo.class);
        intTypeToOpenGisTypeMap.put(131072L, PropertyIsGreaterThan.class);
        intTypeToOpenGisTypeMap.put(262144L, PropertyIsGreaterThanOrEqualTo.class);
        intTypeToOpenGisTypeMap.put(524288L, PropertyIsLessThan.class);
        intTypeToOpenGisTypeMap.put(0x100000L, PropertyIsLessThanOrEqualTo.class);
        intTypeToOpenGisTypeMap.put(8192L, PropertyIsNull.class);
        intTypeToOpenGisTypeMap.put(2048L, PropertyIsLike.class);
        intTypeToOpenGisTypeMap.put(4096L, PropertyIsBetween.class);
        intTypeToOpenGisTypeMap.put(0x800000L, And.class);
        intTypeToOpenGisTypeMap.put(0x2000000L, Or.class);
        intTypeToOpenGisTypeMap.put(0x1000000L, Not.class);
    }
}

