/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.time_series.TimeSeriesDatapoint;
import com.dataiku.gh.core.services.time_series.ITimeSeriesService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TimeSeriesController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ITimeSeriesService timeSeriesService;

    @AuditedCall(value={"msgType", "time-series-get", "timeSeriesId", "${timeSeriesId}", "timestampMin", "${timestampMin}", "timestampMax", "${timestampMax}"})
    @RequestMapping(value={"/api/time-series/get"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String timeSeriesId, @RequestParam(required=false) Long timestampMin, @RequestParam(required=false) Long timestampMax) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        TimeSeriesController.writeJSON((HttpServletResponse)resp, this.timeSeriesService.get(authCtx, timeSeriesId, timestampMin, timestampMax));
    }

    @AuditedCall(value={"msgType", "time-series-delete", "timeSeriesId", "${timeSeriesId}", "timestampMin", "${timestampMin}", "timestampMax", "${timestampMax}"})
    @RequestMapping(value={"/api/time-series/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.TIMESERIES_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String timeSeriesId, @RequestParam(required=false) Long timestampMin, @RequestParam(required=false) Long timestampMax) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.timeSeriesService.delete(authCtx, timeSeriesId, timestampMin, timestampMax);
        TimeSeriesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "time-series-create"})
    @RequestMapping(value={"/api/time-series/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.TIMESERIES_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) @Nullable Set<TimeSeriesDatapoint> datapoints) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        String idCreated = this.timeSeriesService.create(authCtx, Optional.ofNullable(datapoints).orElse(Sets.newHashSet()));
        TimeSeriesController.writeJSON((HttpServletResponse)resp, (Object)JSON.kv((String)"id", (Object)idCreated).get());
    }

    @AuditedCall(value={"msgType", "time-series-push", "timeSeriesId", "${timeSeriesId}"})
    @RequestMapping(value={"/api/time-series/push"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.TIMESERIES_PUSH)
    public void push(HttpServletRequest req, HttpServletResponse resp, @RequestParam Set<TimeSeriesDatapoint> datapoints, @RequestParam(required=false) Boolean upsert) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.timeSeriesService.push(authCtx, datapoints, upsert == null || upsert != false);
        TimeSeriesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

