/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintExport;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.import_export.ExportedEntity;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.ui.UIBlueprint;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminBlueprintsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IExportedEntityMigrationService importExportMigrationService;
    @Autowired
    private IAdminBlueprintsService adminBlueprintsService;

    @AuditedCall(value={"msgType", "admin-blueprint-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprints/get"}, method={RequestMethod.GET})
    @ResponseBody
    public UIBlueprint get(HttpServletRequest req, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminBlueprintsService.getBlueprint(authCtx, blueprintId);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprints/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_CREATE)
    @ResponseBody
    public UIBlueprint create(HttpServletRequest req, @RequestParam Blueprint blueprint, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprint b = this.adminBlueprintsService.createBlueprint(authCtx, blueprint, newIdentifier);
            this.auditTrailService.generic("admin-blueprint-create").with("blueprintId", b.blueprint.id).emit();
            return b;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprints/import-with-versions"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_IMPORT)
    @ResponseBody
    public void importWithVersions(HttpServletRequest req, @RequestParam JsonObject toImport, @RequestParam(required=false) UsersContainersValidationConfig.ValidationBehavior signoffImportRoles, @RequestParam(required=false) BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintExport bpWithVersions = this.importExportMigrationService.unwrapAndMigrateExportedEntity(toImport, BlueprintExport.class);
            this.adminBlueprintsService.importBlueprintWithVersions(authCtx, bpWithVersions, Optional.ofNullable(signoffImportRoles).orElse(UsersContainersValidationConfig.ValidationBehavior.ALL), Optional.ofNullable(migrationPathImportBehavior).orElse(BlueprintVersionExport.MigrationPathImportBehavior.FAIL_IMPORT_ON_EXISTING_MIGRATION_OR_MISSING_VERSION));
            this.auditTrailService.generic("admin-blueprint-with-versions-import").with("blueprintId", bpWithVersions.blueprint.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-with-versions-import", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-blueprint-with-versions-export", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprints/export-with-versions"}, method={RequestMethod.POST})
    @ResponseBody
    public ExportedEntity<BlueprintExport> exportWithVersions(HttpServletRequest req, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        BlueprintExport blueprintExport = this.adminBlueprintsService.exportBlueprintWithVersions(authCtx, blueprintId);
        return this.importExportMigrationService.wrapToExportedEntity(blueprintExport);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprints/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_SAVE)
    @ResponseBody
    public UIBlueprint save(HttpServletRequest req, @RequestParam Blueprint blueprint) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprint b = this.adminBlueprintsService.saveBlueprint(authCtx, blueprint);
            this.auditTrailService.generic("admin-blueprint-save").with("blueprintId", b.blueprint.id).emit();
            return b;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-blueprints-list"})
    @RequestMapping(value={"/api/admin/blueprints/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIBlueprint> list(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminBlueprintsService.listBlueprints(authCtx);
    }

    @AuditedCall(value={"msgType", "admin-blueprint-delete", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprints/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminBlueprintsService.deleteBlueprint(authCtx, blueprintId);
    }
}

