/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.dss;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class DSSDeployerArtifactsContainer {
    private final Map<String, DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer> apiDeployerInfras = new HashMap<String, DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer> projectDeployerInfras = new HashMap<String, DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer> projectDeployerDeployments = new HashMap<String, DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer> apiDeployerDeployments = new HashMap<String, DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer>();
    public final List<DSSArtifactContainer<?>> duplicatedArtifacts = new ArrayList();

    public Map<String, DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer> getAPIInfras() {
        return this.apiDeployerInfras;
    }

    public Map<String, DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer> getProjectInfras() {
        return this.projectDeployerInfras;
    }

    public Map<String, DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer> getAPIDeployments() {
        return this.apiDeployerDeployments;
    }

    public Map<String, DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer> getProjectDeployments() {
        return this.projectDeployerDeployments;
    }

    public void addAPIInfra(Artifact artifact) {
        this.addAPIInfra(DSSArtifactContainer.buildAPIDeployerInfra(artifact));
    }

    public void addAPIInfra(DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getAPIInfras, container);
    }

    public void addProjectInfra(Artifact artifact) {
        this.addProjectInfra(DSSArtifactContainer.buildProjectDeployerInfra(artifact));
    }

    public void addProjectInfra(DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getProjectInfras, container);
    }

    public void addAPIDeployment(Artifact artifact) {
        this.addAPIDeployment(DSSArtifactContainer.buildAPIDeployerDeployment(artifact));
    }

    public void addAPIDeployment(DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getAPIDeployments, container);
    }

    public void addProjectDeployment(Artifact artifact) {
        this.addProjectDeployment(DSSArtifactContainer.buildProjectDeployerDeployment(artifact));
    }

    public void addProjectDeployment(DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getProjectDeployments, container);
    }

    protected final <T extends DSSArtifactContainer<T>> void checkDuplicateAndAdd(Supplier<Map<String, T>> getTarget, T container) {
        Map<String, T> map = getTarget.get();
        if (map.containsKey(container.getIdentifier())) {
            this.duplicatedArtifacts.add(container);
        } else {
            map.put(container.getIdentifier(), container);
        }
    }
}

