/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.enriched;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionTrace;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactDetails;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.visitors.IEnrichedArtifactVisitor;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.commons.lang3.StringUtils;

public class EnrichedArtifactWithoutPermissions {
    public Blueprint blueprint;
    public BlueprintVersion blueprintVersion;
    public BlueprintVersionTrace blueprintVersionTrace;
    public Artifact artifact;
    public final List<Signoff> signoffs = new ArrayList<Signoff>();
    public EnrichedArtifactDetails enrichedArtifactDetails = new EnrichedArtifactDetails();

    public EnrichedArtifactWithoutPermissions() {
    }

    public EnrichedArtifactWithoutPermissions(Blueprint blueprint, BlueprintVersion blueprintVersion, BlueprintVersionTrace blueprintVersionTrace, Artifact artifact, @Nullable List<Signoff> signoffs, EnrichedArtifactDetails enrichedArtifactDetails) {
        this.blueprint = blueprint;
        this.blueprintVersion = blueprintVersion;
        this.blueprintVersionTrace = blueprintVersionTrace;
        this.artifact = artifact;
        this.signoffs.addAll((Collection)MoreObjects.firstNonNull(signoffs, Collections.emptyList()));
        this.enrichedArtifactDetails = enrichedArtifactDetails;
    }

    protected void acceptWithoutSelf(IEnrichedArtifactVisitor enrichedArtifactVisitor) {
        this.blueprint.accept(enrichedArtifactVisitor);
        this.blueprintVersion.accept(enrichedArtifactVisitor);
        this.blueprintVersionTrace.accept(enrichedArtifactVisitor);
        this.artifact.accept(enrichedArtifactVisitor);
        this.signoffs.forEach(signoff -> signoff.accept(enrichedArtifactVisitor));
    }

    public static EnrichedArtifactWithoutPermissions build(Blueprint blueprint, BlueprintVersion blueprintVersion, BlueprintVersionTrace blueprintVersionTrace, Artifact artifact, @Nullable List<Signoff> signoffs, EnrichedArtifactDetails enrichedArtifactDetails) {
        return new EnrichedArtifactWithoutPermissions(blueprint, blueprintVersion, blueprintVersionTrace, artifact, signoffs, enrichedArtifactDetails);
    }

    public Optional<Signoff> findSignoffByStepId(String stepId) {
        return this.signoffs.stream().filter(it -> StringUtils.equals((CharSequence)it.signoffId.stepId, (CharSequence)stepId)).findFirst();
    }

    public Signoff findMandatorySignoffByStepId(String stepId) throws NotFoundException {
        return this.findSignoffByStepId(stepId).orElseThrow(() -> new NotFoundException("Sign-off for step " + stepId + " does not exist in artifact " + (this.artifact != null ? this.artifact.id : "")));
    }

    @Nullable
    public String getCurrentOngoingWorkflowStepId() {
        return this.artifact.getCurrentOngoingWorkflowStepId(this.blueprintVersion.workflowDefinition.stepDefinitions);
    }

    @Nullable
    public String getFurthestFinishedStepId() {
        ReverseListIterator reverseListIterator = new ReverseListIterator(this.blueprintVersion.workflowDefinition.stepDefinitions);
        while (reverseListIterator.hasNext()) {
            StepDefinition stepDefinition = (StepDefinition)reverseListIterator.next();
            ArtifactWorkflowStep artifactWorkflowStep = this.artifact.workflow.steps.get(stepDefinition.id);
            if (artifactWorkflowStep == null || !artifactWorkflowStep.isFinished()) continue;
            return stepDefinition.id;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichedArtifactWithoutPermissions that = (EnrichedArtifactWithoutPermissions)o;
        return Objects.equals(this.blueprint, that.blueprint) && Objects.equals(this.blueprintVersion, that.blueprintVersion) && Objects.equals(this.blueprintVersionTrace, that.blueprintVersionTrace) && Objects.equals(this.artifact, that.artifact) && Objects.equals(this.signoffs, that.signoffs) && Objects.equals(this.enrichedArtifactDetails, that.enrichedArtifactDetails);
    }

    public int hashCode() {
        return Objects.hash(this.blueprint, this.blueprintVersion, this.blueprintVersionTrace, this.artifact, this.signoffs, this.enrichedArtifactDetails);
    }
}

