/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.signoff;

import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.models.signoff.SignoffRecurrenceConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.visitors.ISignoffConfigurationVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SignoffConfiguration {
    public SignoffConfigurationId id;
    public String title;
    @Nullable
    public String description;
    public boolean mandatory = true;
    public List<SignoffUsersGroup> feedbackUsersGroups = new ArrayList<SignoffUsersGroup>();
    public List<SignoffUser> approvers = new ArrayList<SignoffUser>();
    public SignoffRecurrenceConfiguration recurrenceConfiguration = new SignoffRecurrenceConfiguration();

    public void accept(ISignoffConfigurationVisitor visitor) {
        this.feedbackUsersGroups.forEach(group -> group.accept(visitor));
        this.approvers.forEach(user -> user.accept(visitor));
        this.recurrenceConfiguration.accept(visitor);
        visitor.visit(this);
    }

    public Optional<SignoffUsersGroup> findFeedbackGroupById(String groupId) {
        return this.feedbackUsersGroups.stream().filter(group -> StringUtils.equals((CharSequence)group.id, (CharSequence)groupId)).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignoffConfiguration that = (SignoffConfiguration)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.feedbackUsersGroups, that.feedbackUsersGroups) && Objects.equals(this.approvers, that.approvers) && Objects.equals(this.recurrenceConfiguration, that.recurrenceConfiguration) && this.mandatory == that.mandatory;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.feedbackUsersGroups, this.approvers, this.recurrenceConfiguration, this.mandatory);
    }
}

